/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataSlotService;
import com.ibm.ws.container.service.metadata.ModuleMetaDataListener;
import com.ibm.ws.container.service.metadata.extended.ModuleMetaDataExtender;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.api.JaxRsModuleInfoBuilder;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleInfo;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleMetaData;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleType;
import com.ibm.ws.jaxrs20.utils.JaxRsUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, property={"service.vendor=IBM"}, configurationPolicy=ConfigurationPolicy.OPTIONAL)
public class JaxRsModuleMetaDataListener
implements ModuleMetaDataListener,
ModuleMetaDataExtender {
    private static final TraceComponent tc = Tr.register(JaxRsModuleMetaDataListener.class, null, null);
    private final Map<JaxRsModuleType, JaxRsModuleInfoBuilder> jaxRsModuleInfoBuilderMap = new ConcurrentHashMap<JaxRsModuleType, JaxRsModuleInfoBuilder>();
    private final AtomicServiceReference<ClassLoadingService> classLoadingServiceSR = new AtomicServiceReference("classLoadingService");
    static final long serialVersionUID = -2086695826136031983L;

    /*
     * WARNING - void declaration
     */
    public ExtendedModuleInfo extendModuleMetaData(ExtendedModuleInfo moduleInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("extendModuleMetaData(" + moduleInfo.getName() + ") : " + moduleInfo), (Object[])new Object[0]);
        }
        ModuleMetaData mmd = moduleInfo.getMetaData();
        Container moduleContainer = moduleInfo.getContainer();
        try {
            if (!JaxRsUtils.isEJBModule((Container)moduleContainer) && !JaxRsUtils.isWebModule((Container)moduleContainer)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unsupported Module, no JaxRsModuleMetaData will be created for " + moduleInfo.getName()), (Object[])new Object[0]);
                }
                return null;
            }
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.jaxrs20.component.JaxRsModuleMetaDataListener", (String)"79", (Object)this, (Object[])new Object[]{moduleInfo});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unsupported Module, no JaxRsModuleMetaData will be created for " + moduleInfo.getName()), (Object[])new Object[0]);
            }
            return null;
        }
        try {
            JaxRsModuleMetaData jaxRsModuleMetaData = this.createJaxRsModuleMetaData(mmd, moduleContainer, moduleInfo.getClassLoader());
            JaxRsModuleInfo jaxRsModuleInfo = this.createJaxRsModuleInfo(moduleContainer);
            for (ModuleMetaData nestedMMD : moduleInfo.getNestedMetaData()) {
                jaxRsModuleMetaData.getEnclosingModuleMetaDatas().add(nestedMMD);
                JaxRsModuleMetaData.setJaxRsModuleMetaData((ModuleMetaData)nestedMMD, (JaxRsModuleMetaData)jaxRsModuleMetaData);
            }
            JaxRsModuleInfoBuilder jaxRsModuleInfoBuilder = null;
            if (JaxRsUtils.isWebModule((Container)moduleContainer)) {
                jaxRsModuleInfoBuilder = this.jaxRsModuleInfoBuilderMap.get(JaxRsModuleType.WEB);
            } else if (JaxRsUtils.isEJBModule((Container)moduleContainer)) {
                jaxRsModuleInfoBuilder = this.jaxRsModuleInfoBuilderMap.get(JaxRsModuleType.EJB);
            }
            if (jaxRsModuleInfoBuilder != null) {
                return jaxRsModuleInfoBuilder.build(mmd, moduleContainer, jaxRsModuleInfo);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No JaxRsModuleInfoBuilder added to JaxRsModuleMetaDataListener.", (Object[])new Object[0]);
            }
            return null;
        }
        catch (UnableToAdaptException jaxRsModuleMetaData) {
            void e;
            FFDCFilter.processException((Throwable)jaxRsModuleMetaData, (String)"com.ibm.ws.jaxrs20.component.JaxRsModuleMetaDataListener", (String)"115", (Object)this, (Object[])new Object[]{moduleInfo});
            throw new IllegalStateException((Throwable)e);
        }
    }

    private JaxRsModuleMetaData createJaxRsModuleMetaData(ModuleMetaData mmd, Container moduleContainer, ClassLoader moduleClassLoader) throws UnableToAdaptException {
        NonPersistentCache overlayCache = (NonPersistentCache)moduleContainer.adapt(NonPersistentCache.class);
        JaxRsModuleMetaData jaxRsModuleMetaData = (JaxRsModuleMetaData)overlayCache.getFromCache(JaxRsModuleMetaData.class);
        if (jaxRsModuleMetaData == null) {
            ClassLoader appContextClassLoader = ((ClassLoadingService)this.classLoadingServiceSR.getServiceWithException()).createThreadContextClassLoader(moduleClassLoader);
            jaxRsModuleMetaData = new JaxRsModuleMetaData(mmd, moduleContainer, appContextClassLoader);
            overlayCache.addToCache(JaxRsModuleMetaData.class, (Object)jaxRsModuleMetaData);
        } else {
            jaxRsModuleMetaData.getEnclosingModuleMetaDatas().add(mmd);
        }
        JaxRsModuleMetaData.setJaxRsModuleMetaData((ModuleMetaData)mmd, (JaxRsModuleMetaData)jaxRsModuleMetaData);
        return jaxRsModuleMetaData;
    }

    private JaxRsModuleInfo createJaxRsModuleInfo(Container moduleContainer) throws UnableToAdaptException {
        NonPersistentCache overlayCache = (NonPersistentCache)moduleContainer.adapt(NonPersistentCache.class);
        JaxRsModuleInfo jaxRsModuleInfo = (JaxRsModuleInfo)overlayCache.getFromCache(JaxRsModuleInfo.class);
        if (jaxRsModuleInfo == null) {
            if (JaxRsUtils.isWebModule((Container)moduleContainer)) {
                jaxRsModuleInfo = new JaxRsModuleInfo(JaxRsModuleType.WEB);
            } else if (JaxRsUtils.isEJBModule((Container)moduleContainer)) {
                jaxRsModuleInfo = new JaxRsModuleInfo(JaxRsModuleType.EJB);
            }
        }
        overlayCache.addToCache(JaxRsModuleInfo.class, (Object)jaxRsModuleInfo);
        return jaxRsModuleInfo;
    }

    public void moduleMetaDataCreated(MetaDataEvent<ModuleMetaData> event) {
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.classLoadingServiceSR.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.classLoadingServiceSR.deactivate(cc);
    }

    /*
     * WARNING - void declaration
     */
    public void moduleMetaDataDestroyed(MetaDataEvent<ModuleMetaData> event) {
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("moduleMetaDataDestroyed(" + ((ModuleMetaData)event.getMetaData()).getName() + ") : " + event.getMetaData()), (Object[])new Object[0]);
            }
            try {
                Container moduleContainer = event.getContainer();
                if (moduleContainer != null) {
                    NonPersistentCache overlayCache = (NonPersistentCache)moduleContainer.adapt(NonPersistentCache.class);
                    overlayCache.removeFromCache(JaxRsModuleMetaData.class);
                }
            }
            catch (UnableToAdaptException moduleContainer) {
                void ex;
                FFDCFilter.processException((Throwable)moduleContainer, (String)"com.ibm.ws.jaxrs20.component.JaxRsModuleMetaDataListener", (String)"176", (Object)this, (Object[])new Object[]{event});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)("moduleMetaDataDestroyed(" + ((ModuleMetaData)event.getMetaData()).getName() + ") : Failed to remove metadata from overlay cache"), (Object[])new Object[]{ex});
            }
        }
        JaxRsModuleMetaData moduleMetaData = JaxRsModuleMetaData.getJaxRsModuleMetaData((ModuleMetaData)((ModuleMetaData)event.getMetaData()));
        if (moduleMetaData != null) {
            JaxRsModuleMetaData.setJaxRsModuleMetaData((ModuleMetaData)((ModuleMetaData)event.getMetaData()), null);
            if (moduleMetaData.getJ2EEName().equals(((ModuleMetaData)event.getMetaData()).getJ2EEName())) {
                moduleMetaData.destroy();
                ClassLoadingService classLoadingService = (ClassLoadingService)this.classLoadingServiceSR.getService();
                if (classLoadingService != null) {
                    classLoadingService.destroyThreadContextClassLoader(moduleMetaData.getAppContextClassLoader());
                }
            }
        }
    }

    @Reference(name="metaDataSlotService", service=MetaDataSlotService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setMetaDataSlotService(MetaDataSlotService slotService) {
        JaxRsModuleMetaData.jaxrsModuleSlot = slotService.reserveMetaDataSlot(ModuleMetaData.class);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setMetaDataSlotService : moduleSlot=" + JaxRsModuleMetaData.jaxrsModuleSlot), (Object[])new Object[0]);
        }
    }

    protected void unsetMetaDataSlotService(MetaDataSlotService slotService) {
        JaxRsModuleMetaData.jaxrsModuleSlot = null;
    }

    @Reference(name="jaxRsModuleInfoBuilders", service=JaxRsModuleInfoBuilder.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void registerJaxRsModuleInfoBuilder(JaxRsModuleInfoBuilder jaxRsModuleInfoBuilder) {
        this.jaxRsModuleInfoBuilderMap.put(jaxRsModuleInfoBuilder.getSupportType(), jaxRsModuleInfoBuilder);
    }

    protected void unregisterJaxRsModuleInfoBuilder(JaxRsModuleInfoBuilder jaxRsModuleInfoBuilder) {
        this.jaxRsModuleInfoBuilderMap.remove(jaxRsModuleInfoBuilder.getSupportType());
    }

    @Reference(name="classLoadingService", service=ClassLoadingService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingServiceSR.setReference(ref);
    }

    protected void unsetClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingServiceSR.unsetReference(ref);
    }
}

