/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.webcontainer61.srt;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.request.IRequest;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.util.RequestUtils;
import com.ibm.wsspi.webcontainer.util.WSServletInputStream;
import io.openliberty.webcontainer60.osgi.srt.SRTConnectionContext60;
import io.openliberty.webcontainer60.srt.SRTServletRequest60;
import io.openliberty.webcontainer61.osgi.srt.SRTConnectionContext61;
import io.openliberty.webcontainer61.srt.SRTInputStream61;
import io.openliberty.websphere.servlet61.IRequest61;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SRTServletRequest61
extends SRTServletRequest60
implements HttpServletRequest {
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("io.openliberty.webcontainer61.srt");
    private static final String CLASS_NAME = SRTServletRequest61.class.getName();

    public SRTServletRequest61(SRTConnectionContext61 context) {
        super((SRTConnectionContext60)context);
    }

    public void initForNextRequest(IRequest req) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "initForNextRequest", "this->" + String.valueOf((Object)this) + " :  req ->" + String.valueOf(req));
        }
        super.initForNextRequest(req);
    }

    protected WSServletInputStream createInputStream() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "createInputStream", "this [" + String.valueOf((Object)this) + "]");
        }
        return new SRTInputStream61(this);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "getRequestDispatcher", " path [" + path + "] " + String.valueOf((Object)this));
        }
        if (path == null) {
            return null;
        }
        if ((path = RequestUtils.normalizePath((String)path)) == null) {
            return null;
        }
        return super.getRequestDispatcher(path);
    }

    public void setCharacterEncoding(Charset charset) {
        String encoding;
        String string = encoding = charset == null ? null : charset.name();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setCharacterEncoding", "Charset name [" + encoding + "] [" + String.valueOf((Object)this) + "]");
        }
        try {
            if (encoding != null) {
                super.setCharacterEncoding(encoding, true);
            } else {
                String msg = nls.getFormattedMessage("unsupported.request.encoding.[{0}]", new Object[]{charset}, "Unsupported encoding specified --> " + String.valueOf(charset));
                logger.logp(Level.SEVERE, CLASS_NAME, "setRequestCharacterEncoding", msg);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.logp(Level.INFO, CLASS_NAME, "setCharacterEncoding", "Unable to set request character encoding based upon Charset", e);
        }
    }

    public void setSSLAttributesInRequest(HttpServletRequest httpServletReq, String cs) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setSSLAttributesInRequest", (Object)this);
        }
        String secureProtocol = null;
        super.setSSLAttributesInRequest(httpServletReq, cs);
        if (cs != null) {
            secureProtocol = ((IRequest61)this.getIRequest()).getSecureProtocol();
        }
        if (secureProtocol != null) {
            httpServletReq.setAttribute("jakarta.servlet.request.secure_protocol", (Object)secureProtocol);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setSSLAttributesInRequest", (Object)this);
        }
    }
}

