/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.processor.impl.interfaces.BrowseCursor;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.utils.ras.SibTr;

public class JSBrowseCursor
implements BrowseCursor {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(JSBrowseCursor.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private NonLockingCursor msgStoreNonLockingCursor;

    public JSBrowseCursor(NonLockingCursor msgStoreNonLockingCursor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"JSBrowseCursor", (Object)msgStoreNonLockingCursor);
        }
        this.msgStoreNonLockingCursor = msgStoreNonLockingCursor;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"JSBrowseCursor", (Object)this);
        }
    }

    @Override
    public JsMessage next() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"next");
        }
        AbstractItem msg = null;
        if (this.msgStoreNonLockingCursor != null) {
            try {
                msg = this.msgStoreNonLockingCursor.next();
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSBrowseCursor.next", (String)"1:106:1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSBrowseCursor", "1:113:1.1", e});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"next", (Object)((Object)e));
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.JSBrowseCursor", "1:124:1.1", e}, null), (Throwable)e);
            }
            if (msg != null) {
                JsMessage jsMsg = ((SIMPMessage)msg).getMessage();
                jsMsg.setRedeliveredCount(msg.guessUnlockCount());
                try {
                    jsMsg = jsMsg.getReceived();
                }
                catch (MessageCopyFailedException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSBrowseCursor.next", (String)"1:146:1.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSBrowseCursor", "1:153:1.1", e});
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"next", (Object)((Object)e));
                    }
                    throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.JSBrowseCursor", "1:164:1.1", e}, null), (Throwable)e);
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"next", (Object)jsMsg);
                }
                return jsMsg;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"next", null);
        }
        return null;
    }

    @Override
    public void finished() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"finished");
        }
        if (this.msgStoreNonLockingCursor != null) {
            this.msgStoreNonLockingCursor.finished();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"finished");
        }
    }
}

