/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.ref;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.cache.ref.Indirection;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

final class IndirectionList {
    private static TraceComponent tc = SibTr.register(IndirectionList.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private long _currentCount = 0L;
    private long _currentSize = 0L;
    private Indirection _first = null;
    private Indirection _last = null;

    IndirectionList() {
    }

    final synchronized boolean append(Indirection indirection, AbstractItem item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_append", (Object)indirection);
        }
        boolean appended = false;
        if (null == indirection) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"ignoring null indirection");
            }
        } else if (null == item) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"ignoring append of indirection to null item");
            }
        } else if (null != indirection.itemCacheGetNextLink() || null != indirection.itemCacheGetPrevioustLink()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("indirection already linked: " + indirection.getID()));
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("link: " + indirection.getID() + " (count=" + this._currentCount + ",size=" + this._currentSize + ")"));
            }
            if (null == this._first || null == this._last) {
                indirection.itemCacheSetNextLink(null);
                indirection.itemCacheSetPreviousLink(null);
                this._last = indirection;
                this._first = indirection;
            } else if (this._first == this._last) {
                if (indirection == this._first) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("indirection already linked: " + indirection.getID()));
                    }
                } else {
                    indirection.itemCacheSetNextLink(null);
                    indirection.itemCacheSetPreviousLink(this._first);
                    this._last = indirection;
                    this._first.itemCacheSetNextLink(this._last);
                }
            } else {
                indirection.itemCacheSetNextLink(null);
                indirection.itemCacheSetPreviousLink(this._last);
                this._last.itemCacheSetNextLink(indirection);
                this._last = indirection;
            }
            indirection.itemCacheSetManagedReference(item);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("linked: " + indirection.getID() + " (count=" + this._currentCount + ",size=" + this._currentSize + ")"));
            }
            appended = true;
            ++this._currentCount;
            this._currentSize += (long)indirection.getInMemoryItemSize();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_append", (Object)appended);
        }
        return appended;
    }

    final synchronized long getCurrentCount() {
        return this._currentCount;
    }

    final synchronized long getCurrentSize() {
        return this._currentSize;
    }

    final synchronized Indirection getFirst() {
        return this._first;
    }

    final synchronized Indirection removeFirst() {
        Indirection removed = this._first;
        if (null == removed) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"list empty, reset counters");
            }
            this._currentCount = 0L;
            this._currentSize = 0L;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("unlinking " + removed.getID()));
            }
            if (removed == this._last) {
                this._first = null;
                this._last = null;
                this._currentCount = 0L;
                this._currentSize = 0L;
            } else {
                this._first = removed.itemCacheGetNextLink();
                this._first.itemCacheSetPreviousLink(null);
                --this._currentCount;
                this._currentSize -= (long)removed.getInMemoryItemSize();
            }
            removed.itemCacheSetManagedReference(null);
            removed.itemCacheSetNextLink(null);
            removed.itemCacheSetPreviousLink(null);
        }
        return removed;
    }

    final synchronized boolean unlink(Indirection indirection) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_unlink", (Object)indirection);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("unlink: " + indirection.getID() + " (count=" + this._currentCount + ",size=" + this._currentSize + ")"));
        }
        boolean unlinked = false;
        if (null == this._first || null == this._last) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"empty list");
            }
        } else if (this._first == this._last) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"one element list");
            }
            if (indirection == this._first) {
                this._first = null;
                this._last = null;
                unlinked = true;
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"indirection not in list!");
            }
        } else if (null == indirection.itemCacheGetNextLink() && null == indirection.itemCacheGetPrevioustLink()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"indirection not linked");
            }
        } else if (indirection == this._first) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"indirection is first");
            }
            if (null == indirection.itemCacheGetNextLink()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"_unlink");
                }
                throw new SevereMessageStoreException("unexpected null forward link");
            }
            this._first = indirection.itemCacheGetNextLink();
            this._first.itemCacheSetPreviousLink(null);
            unlinked = true;
        } else if (indirection == this._last) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"indirection is last");
            }
            if (null == indirection.itemCacheGetPrevioustLink()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"_unlink");
                }
                throw new SevereMessageStoreException("unexpected null backward link");
            }
            this._last = indirection.itemCacheGetPrevioustLink();
            this._last.itemCacheSetNextLink(null);
            unlinked = true;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"indirection is in middle");
            }
            if (null == indirection.itemCacheGetNextLink() || null == indirection.itemCacheGetPrevioustLink()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"_unlink");
                }
                throw new SevereMessageStoreException("unexpected null link");
            }
            Indirection before = indirection.itemCacheGetPrevioustLink();
            Indirection after = indirection.itemCacheGetNextLink();
            before.itemCacheSetNextLink(after);
            after.itemCacheSetPreviousLink(before);
            unlinked = true;
        }
        indirection.itemCacheSetNextLink(null);
        indirection.itemCacheSetPreviousLink(null);
        if (unlinked) {
            indirection.itemCacheSetManagedReference(null);
            --this._currentCount;
            this._currentSize -= (long)indirection.getInMemoryItemSize();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_unlink", (Object)unlinked);
        }
        return unlinked;
    }

    final void xmlWriteOn(FormattedWriter writer) throws IOException {
        for (Indirection ind = this.getFirst(); null != ind; ind = ind.itemCacheGetNextLink()) {
            writer.newLine();
            ind.xmlShortWriteOn(writer);
        }
    }
}

