/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemMembership;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.msgstore.ReferenceMembership;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.List;

public class ItemReference
extends AbstractItem {
    private static TraceComponent tc = SibTr.register(ItemReference.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private Item _item;
    private ItemMembership _referredMembership;
    private boolean _sizeRefsByMsgSize = false;

    public ItemReference() {
    }

    public ItemReference(Item item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this._item = item;
        this._referredMembership = (ItemMembership)item._getMembership();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public final Item getReferredItem() throws SevereMessageStoreException {
        if (null == this._item) {
            if (null == this._referredMembership) {
                MessageStore messageStore;
                long refID;
                ReferenceMembership m = (ReferenceMembership)this._getMembership();
                if (null == m) {
                    throw new NotInMessageStore();
                }
                if (null != m && -1L != (refID = m.getReferencedID()) && null != (messageStore = this.getOwningMessageStore())) {
                    this._referredMembership = (ItemMembership)messageStore.getMembership(refID);
                }
            }
            if (null != this._referredMembership) {
                this._item = (Item)this._referredMembership.getItem();
            }
        }
        return this._item;
    }

    @Override
    public int getPriority() {
        if (null != this._item) {
            return this._item.getPriority();
        }
        return this._referredMembership.getPriority();
    }

    @Override
    public final boolean isItemReference() {
        return true;
    }

    @Override
    public void restore(List<DataSlice> dataSlices) throws PersistentDataEncodingException, SevereMessageStoreException {
        super.restore(dataSlices);
        long referredID = ((ReferenceMembership)this._getMembership()).getReferencedID();
        this._referredMembership = (ItemMembership)this.getOwningMessageStore().getMembership(referredID);
    }

    public final ReferenceStream getReferenceStream() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReferenceStream");
        }
        ReferenceStream referenceStream = null;
        ReferenceMembership m = (ReferenceMembership)this._getMembership();
        if (null == m) {
            throw new NotInMessageStore();
        }
        if (null != m) {
            referenceStream = m.getOwningReferenceStream();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getReferenceStream", (Object)referenceStream);
        }
        return referenceStream;
    }

    public void setSizeRefsByMsgSize(boolean sizeByMsgSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSizeRefsByMsgSize", (Object)sizeByMsgSize);
        }
        this._sizeRefsByMsgSize = sizeByMsgSize;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSizeRefsByMsgSize");
        }
    }

    public boolean getSizeRefsByMsgSize() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSizeRefsByMsgSize");
        }
        boolean retval = this._sizeRefsByMsgSize;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSizeRefsByMsgSize", (Object)retval);
        }
        return retval;
    }

    @Override
    public int getInMemoryDataSize() {
        int dataSize;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getInMemoryDataSize");
        }
        if (this._sizeRefsByMsgSize) {
            try {
                dataSize = this.getReferredItem().getInMemoryDataSize();
            }
            catch (SevereMessageStoreException e) {
                FFDCFilter.processException((Throwable)((Object)e), (String)"com.ibm.ws.sib.msgstore.ItemReference.getInMemoryDataSize", (String)"244", (Object)this);
                dataSize = super.getInMemoryDataSize();
            }
        } else {
            dataSize = super.getInMemoryDataSize();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getInMemoryDataSize", (Object)dataSize);
        }
        return dataSize;
    }
}

