/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class ConsumerDispatcherState {
    private static final int SUBSTATE_PRIORITY = 0;
    private static final TraceComponent tc = SibTr.register(ConsumerDispatcherState.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private String subscriptionID = null;
    private SIBUuid12 topicSpaceUuid = null;
    private String topicSpaceName = null;
    private String topicSpaceBusName = null;
    private String[] topics = null;
    private String user = null;
    private boolean isSIBServerSubject = false;
    private String durableHome = null;
    private String targetDest = null;
    private Map userData = null;
    private SelectionCriteria[] selectionCriteriaList = null;
    private boolean ready = true;
    private boolean noLocal = false;
    private boolean isCloned = false;
    private SIBUuid8 remoteMEUuid = null;
    private boolean durable = false;

    public ConsumerDispatcherState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"ConsumerDispatcherState");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"ConsumerDispatcherState");
        }
    }

    public ConsumerDispatcherState(SIBUuid12 topicSpace, SelectionCriteria criteria, String topicSpaceName, String topicSpaceBusName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"ConsumerDispatcherState", (Object)new Object[]{topicSpace, criteria, topicSpaceName, topicSpaceBusName});
        }
        this.topicSpaceUuid = topicSpace;
        this.topicSpaceName = topicSpaceName;
        this.topicSpaceBusName = topicSpaceBusName;
        this.topics = new String[]{criteria == null ? null : criteria.getDiscriminator()};
        this.selectionCriteriaList = new SelectionCriteria[]{criteria == null ? null : criteria};
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"ConsumerDispatcherState", (Object)this);
        }
    }

    public ConsumerDispatcherState(String subscriptionID, SIBUuid12 topicSpace, SelectionCriteria criteria, boolean noLocal, String durHome, String topicSpaceName, String topicSpaceBusName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"ConsumerDispatcherState", (Object)new Object[]{subscriptionID, topicSpace, criteria, noLocal, durHome, topicSpaceName, topicSpaceBusName});
        }
        this.subscriptionID = subscriptionID;
        this.noLocal = noLocal;
        this.topicSpaceUuid = topicSpace;
        this.topicSpaceName = topicSpaceName;
        this.topicSpaceBusName = topicSpaceBusName;
        this.durableHome = durHome;
        this.topics = new String[]{criteria == null ? null : criteria.getDiscriminator()};
        this.selectionCriteriaList = new SelectionCriteria[]{criteria == null ? null : criteria};
        if (this.durableHome != null && subscriptionID != null) {
            this.durable = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"ConsumerDispatcherState", (Object)this);
        }
    }

    public ConsumerDispatcherState(String subscriptionID, SIBUuid12 topicSpace, boolean noLocal, String durHome, String topicSpaceName, String topicSpaceBusName, SelectionCriteria[] selectionCriteriaList, HashMap userData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"ConsumerDispatcherState", (Object)new Object[]{subscriptionID, topicSpace, noLocal, durHome, topicSpaceName, topicSpaceBusName, selectionCriteriaList, userData});
        }
        this.subscriptionID = subscriptionID;
        this.noLocal = noLocal;
        this.topicSpaceUuid = topicSpace;
        this.topicSpaceName = topicSpaceName;
        this.topicSpaceBusName = topicSpaceBusName;
        this.durableHome = durHome;
        if (selectionCriteriaList != null) {
            this.topics = new String[selectionCriteriaList.length];
            for (int i = 0; i < selectionCriteriaList.length; ++i) {
                this.topics[i] = selectionCriteriaList[i] == null ? null : selectionCriteriaList[i].getDiscriminator();
            }
            this.selectionCriteriaList = selectionCriteriaList;
        }
        if (this.durableHome != null && subscriptionID != null) {
            this.durable = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"ConsumerDispatcherState", (Object)this);
        }
    }

    public SIBUuid12 getTopicSpaceUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTopicSpaceUuid");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTopicSpaceUuid", (Object)this.topicSpaceUuid);
        }
        return this.topicSpaceUuid;
    }

    public SelectionCriteria getSelectionCriteria() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSelectionCriteria");
        }
        SelectionCriteria criteria = null;
        if (this.selectionCriteriaList != null) {
            criteria = this.selectionCriteriaList[0];
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSelectionCriteria", (Object)criteria);
        }
        return criteria;
    }

    public String getSubscriberID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSubscriberID");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSubscriberID", (Object)this.subscriptionID);
        }
        return this.subscriptionID;
    }

    public String[] getTopics() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTopics");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTopics", (Object)this.topics);
        }
        return this.topics;
    }

    public void removeTopic(String topic) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeTopic", (Object)topic);
        }
        SelectionCriteria[] tmp = this.selectionCriteriaList;
        for (int i = 0; i < this.selectionCriteriaList.length; ++i) {
            if ((this.selectionCriteriaList[i].getDiscriminator() != null || topic != null) && (topic == null || !this.selectionCriteriaList[i].getDiscriminator().equals(topic))) continue;
            if (this.selectionCriteriaList.length == 1) {
                this.selectionCriteriaList = null;
                this.topics = null;
                break;
            }
            tmp = new SelectionCriteria[this.selectionCriteriaList.length - 1];
            System.arraycopy(this.selectionCriteriaList, 0, tmp, 0, i);
            System.arraycopy(this.selectionCriteriaList, i + 1, tmp, i, this.selectionCriteriaList.length - i - 1);
            this.selectionCriteriaList = tmp;
            this.topics = new String[this.selectionCriteriaList.length];
            for (int t = 0; t < this.selectionCriteriaList.length; ++t) {
                this.topics[t] = this.selectionCriteriaList[t] == null ? null : this.selectionCriteriaList[t].getDiscriminator();
            }
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeTopic");
        }
    }

    public String getTopic() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTopic");
        }
        if (this.topics == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTopic", null);
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTopic");
        }
        return this.topics[0];
    }

    public String getUser() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUser");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUser", (Object)this.user);
        }
        return this.user;
    }

    public void setTopicSpaceUuid(SIBUuid12 topicSpace) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTopicSpaceUuid", (Object)topicSpace);
        }
        this.topicSpaceUuid = topicSpace;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTopicSpaceUuid");
        }
    }

    public void setSubscriberID(String subscriptionID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSubscriberID", (Object)subscriptionID);
        }
        this.subscriptionID = subscriptionID;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSubscriberID");
        }
    }

    public void setUser(String user, boolean isSIBServerSubject) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setUser", (Object)user);
        }
        this.user = user;
        this.isSIBServerSubject = isSIBServerSubject;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setUser");
        }
    }

    public boolean isSIBServerSubject() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isSIBServerSubject");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isSIBServerSubject", (Object)this.isSIBServerSubject);
        }
        return this.isSIBServerSubject;
    }

    protected boolean isDurable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isDurable");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isDurable", (Object)this.durable);
        }
        return this.durable;
    }

    public void setDurable(boolean isDurable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDurable", (Object)isDurable);
        }
        this.durable = isDurable;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDurable");
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ConsumerDispatcherState) {
            ConsumerDispatcherState subState = (ConsumerDispatcherState)obj;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"equals");
            }
            boolean equal = true;
            if (this.subscriptionID == null) {
                if (subState.getSubscriberID() != null) {
                    equal = false;
                }
            } else if (!this.subscriptionID.equals(subState.getSubscriberID())) {
                equal = false;
            }
            if (this.topicSpaceUuid == null) {
                if (subState.getTopicSpaceUuid() != null) {
                    equal = false;
                }
            } else if (!this.topicSpaceUuid.equals((Object)subState.getTopicSpaceUuid())) {
                equal = false;
            }
            SelectionCriteria[] criteriaToCheck = subState.getSelectionCriteriaList();
            if (this.selectionCriteriaList == null) {
                if (criteriaToCheck != null) {
                    equal = false;
                }
            } else if (criteriaToCheck == null) {
                equal = false;
            } else {
                for (int i = 0; i < this.selectionCriteriaList.length; ++i) {
                    if (this.selectionCriteriaList[i] == null) {
                        if (criteriaToCheck[i] == null) continue;
                        equal = false;
                        continue;
                    }
                    if (criteriaToCheck[i] == null) {
                        equal = false;
                        continue;
                    }
                    if (this.selectionCriteriaList[i].equals(criteriaToCheck[i])) continue;
                    equal = false;
                }
            }
            if (this.noLocal != subState.isNoLocal()) {
                equal = false;
            }
            if (this.isCloned != subState.isCloned()) {
                equal = false;
            }
            boolean bl = equal = equal && (this.durableHome == subState.durableHome || this.durableHome != null && this.durableHome.equals(subState.durableHome));
            if (!equal && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Subscriptions not equal " + this.toString() + " & " + subState.toString()));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"equals", (Object)equal);
            }
            return equal;
        }
        return false;
    }

    public int hashCode() {
        if (this.subscriptionID == null) {
            return 0;
        }
        return this.subscriptionID.hashCode();
    }

    public boolean equalUser(ConsumerDispatcherState subState) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"equalUser");
        }
        boolean equal = this.equalUser(subState.getUser(), subState.isSIBServerSubject());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"equalUser", (Object)equal);
        }
        return equal;
    }

    public boolean equalUser(String otherUser, boolean isOtherSIBServerSubject) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"equalUser", (Object)new Object[]{otherUser, isOtherSIBServerSubject});
        }
        boolean equal = true;
        if (this.user == null || this.user.equals("")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Old user was null or empty, dur sub established with security switched off");
            }
            this.setUser(otherUser, isOtherSIBServerSubject);
        } else if (!this.user.equals(otherUser)) {
            equal = false;
        } else if (this.isSIBServerSubject()) {
            if (!isOtherSIBServerSubject) {
                equal = false;
            }
        } else if (isOtherSIBServerSubject) {
            equal = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"equalUser", (Object)equal);
        }
        return equal;
    }

    public boolean isReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isReady");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isReady", (Object)this.ready);
        }
        return this.ready;
    }

    public void setReady(boolean ready) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReady", (Object)ready);
        }
        this.ready = ready;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReady");
        }
    }

    public boolean isNoLocal() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isNoLocal");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isNoLocal", (Object)this.noLocal);
        }
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setNoLocal", (Object)noLocal);
        }
        this.noLocal = noLocal;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setNoLocal");
        }
    }

    public String toString() {
        String filter = null;
        if (this.selectionCriteriaList != null) {
            filter = this.selectionCriteriaList.toString();
        }
        if (this.topics != null && this.topics.length > 0) {
            return "Subscription to " + this.subscriptionID + ":" + this.topicSpaceBusName + ":" + this.topicSpaceName + ":" + this.topicSpaceUuid + ":" + this.topics[0] + ":" + filter + ":" + this.user + ":" + this.durableHome;
        }
        return "Subscription to " + this.subscriptionID + ":" + this.topicSpaceBusName + ":" + this.topicSpaceName + ":" + this.topicSpaceUuid + ":" + Arrays.toString(this.topics) + ":" + filter + ":" + this.user + ":" + this.durableHome;
    }

    protected int getPriority() {
        return 0;
    }

    public void setDurableHome(String val) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDurableHome", (Object)val);
        }
        this.durableHome = val;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDurableHome");
        }
    }

    public boolean isCloned() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isCloned");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isCloned", (Object)this.isCloned);
        }
        return this.isCloned;
    }

    public void setIsCloned(boolean isCloned) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setIsCloned", (Object)isCloned);
        }
        this.isCloned = isCloned;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setIsCloned");
        }
    }

    public String getDurableHome() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDurableHome");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDurableHome", (Object)this.durableHome);
        }
        return this.durableHome;
    }

    public String getTopicSpaceName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTopicSpaceName");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTopicSpaceName", (Object)this.topicSpaceName);
        }
        return this.topicSpaceName;
    }

    public void setTopicSpaceName(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTopicSpaceName", (Object)name);
        }
        this.topicSpaceName = name;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTopicSpaceName");
        }
    }

    public String getTopicSpaceBusName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTopicSpaceBusName");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTopicSpaceBusName", (Object)this.topicSpaceBusName);
        }
        return this.topicSpaceBusName;
    }

    public void setTopicSpaceBusName(String busname) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTopicSpaceBusName", (Object)busname);
        }
        this.topicSpaceBusName = busname;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTopicSpaceBusName");
        }
    }

    public Map getUserData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUserData");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUserData", (Object)this.userData);
        }
        return this.userData;
    }

    public void setUserData(Map userData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setUserData", (Object)userData);
        }
        this.userData = userData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setUserData");
        }
    }

    public String getTargetDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTargetDestination");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTargetDestination", (Object)this.targetDest);
        }
        return this.targetDest;
    }

    public void setTargetDestination(String targetDest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTargetDestination", (Object)targetDest);
        }
        this.targetDest = targetDest;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTargetDestination");
        }
    }

    public SelectionCriteria[] getSelectionCriteriaList() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSelectionCriteriaList");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSelectionCriteriaList", (Object)this.selectionCriteriaList);
        }
        return this.selectionCriteriaList;
    }

    public boolean addSelectionCriteria(SelectionCriteria selCriteria) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addSelectionCriteria", (Object)selCriteria);
        }
        boolean duplicateCriteria = false;
        if (this.selectionCriteriaList == null) {
            this.topics = new String[]{selCriteria == null ? null : selCriteria.getDiscriminator()};
            this.selectionCriteriaList = new SelectionCriteria[]{selCriteria};
        } else {
            for (int i = 0; i < this.selectionCriteriaList.length; ++i) {
                if ((this.selectionCriteriaList[i] != null || selCriteria != null) && !this.selectionCriteriaList[i].equals(selCriteria)) continue;
                duplicateCriteria = true;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)"Duplicate selectionCriteria exists");
                break;
            }
            if (!duplicateCriteria) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Adding selection criteria");
                }
                SelectionCriteria[] tmp = new SelectionCriteria[this.selectionCriteriaList.length + 1];
                System.arraycopy(this.selectionCriteriaList, 0, tmp, 0, this.selectionCriteriaList.length);
                tmp[this.selectionCriteriaList.length] = selCriteria;
                this.selectionCriteriaList = tmp;
                String[] tmptopics = new String[this.topics.length + 1];
                System.arraycopy(this.topics, 0, tmptopics, 0, this.topics.length);
                tmptopics[this.topics.length] = selCriteria == null ? null : selCriteria.getDiscriminator();
                this.topics = tmptopics;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addSelectionCriteria", (Object)duplicateCriteria);
        }
        return duplicateCriteria;
    }

    public boolean removeSelectionCriteria(SelectionCriteria selCriteria) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeSelectionCriteria", (Object)selCriteria);
        }
        SelectionCriteria[] tmp = this.selectionCriteriaList;
        boolean removedCriteria = false;
        for (int i = 0; i < this.selectionCriteriaList.length; ++i) {
            if (!this.selectionCriteriaList[i].equals(selCriteria)) continue;
            if (this.selectionCriteriaList.length == 1) {
                this.selectionCriteriaList = null;
                this.topics = null;
            } else {
                tmp = new SelectionCriteria[this.selectionCriteriaList.length - 1];
                System.arraycopy(this.selectionCriteriaList, 0, tmp, 0, i);
                System.arraycopy(this.selectionCriteriaList, i + 1, tmp, i, this.selectionCriteriaList.length - i - 1);
                this.selectionCriteriaList = tmp;
                this.topics = new String[this.selectionCriteriaList.length];
                for (int t = 0; t < this.selectionCriteriaList.length; ++t) {
                    this.topics[t] = this.selectionCriteriaList[t] == null ? null : this.selectionCriteriaList[t].getDiscriminator();
                }
            }
            removedCriteria = true;
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeSelectionCriteria", (Object)removedCriteria);
        }
        return removedCriteria;
    }

    public void setSelectionCriteriaListOnRestore(SelectionCriteria[] selectionCriteriaList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSelectionCriteriaListOnRestore", (Object)selectionCriteriaList);
        }
        if (selectionCriteriaList != null) {
            this.topics = new String[selectionCriteriaList.length];
            for (int i = 0; i < selectionCriteriaList.length; ++i) {
                this.topics[i] = selectionCriteriaList[i] == null ? null : selectionCriteriaList[i].getDiscriminator();
            }
            this.selectionCriteriaList = selectionCriteriaList;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSelectionCriteriaListOnRestore");
        }
    }

    public SIBUuid8 getRemoteMEUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRemoteMEUuid");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRemoteMEUuid", (Object)this.remoteMEUuid);
        }
        return this.remoteMEUuid;
    }

    public void setRemoteMEUuid(SIBUuid8 remoteMEUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setRemoteMEUuid", (Object)remoteMEUuid);
        }
        this.remoteMEUuid = remoteMEUuid;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setRemoteMEUuid");
        }
    }
}

