/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.cdi;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.cdi.CDIServiceUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.concurrent.internal.cdi.ConcurrencyExtensionMetadata;
import io.openliberty.concurrent.internal.cdi.ContextServiceBean;
import io.openliberty.concurrent.internal.cdi.ManagedExecutorBean;
import io.openliberty.concurrent.internal.cdi.ManagedScheduledExecutorBean;
import io.openliberty.concurrent.internal.cdi.ManagedThreadFactoryBean;
import io.openliberty.concurrent.internal.cdi.interceptor.AsyncInterceptor;
import io.openliberty.concurrent.internal.qualified.QualifiedResourceFactories;
import io.openliberty.concurrent.internal.qualified.QualifiedResourceFactory;
import jakarta.enterprise.concurrent.Asynchronous;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.ContextServiceDefinition;
import jakarta.enterprise.concurrent.ManagedExecutorDefinition;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorDefinition;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import jakarta.enterprise.concurrent.ManagedThreadFactoryDefinition;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.Extension;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConcurrencyExtension
implements Extension {
    private static final TraceComponent tc = Tr.register(ConcurrencyExtension.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.cdi.resources.CWWKCMessages");
    private static final Annotation[] DEFAULT_QUALIFIER_ARRAY = new Annotation[]{Default.Literal.INSTANCE};
    private static final Set<Annotation> DEFAULT_QUALIFIER_SET = Set.of(Default.Literal.INSTANCE);
    private ConcurrencyExtensionMetadata extSvc;
    private boolean producedDefaultMTF;
    static final long serialVersionUID = 7566179763312338846L;

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        AnnotatedType bindingType = beanManager.createAnnotatedType(Asynchronous.class);
        beforeBeanDiscovery.addInterceptorBinding(bindingType);
        AnnotatedType interceptorType = beanManager.createAnnotatedType(AsyncInterceptor.class);
        beforeBeanDiscovery.addAnnotatedType(interceptorType, CDIServiceUtils.getAnnotatedTypeIdentifier((AnnotatedType)interceptorType, this.getClass()));
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        List<Map<List<String>, QualifiedResourceFactory>> listFromApp;
        List<Map<List<String>, QualifiedResourceFactory>> listFromModule;
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cmd == null) {
            throw new IllegalStateException();
        }
        J2EEName jeeName = cmd.getJ2EEName();
        BundleContext bundleContext = FrameworkUtil.getBundle(ConcurrencyExtension.class).getBundleContext();
        ServiceReference ref = bundleContext.getServiceReference(QualifiedResourceFactories.class);
        this.extSvc = (ConcurrencyExtensionMetadata)bundleContext.getService(ref);
        CDI cdi = CDI.current();
        if (!cdi.select(ContextService.class, DEFAULT_QUALIFIER_ARRAY).isResolvable()) {
            event.addBean((Bean)new ContextServiceBean(this.extSvc.defaultContextServiceFactory, DEFAULT_QUALIFIER_SET));
        }
        if (!cdi.select(ManagedExecutorService.class, DEFAULT_QUALIFIER_ARRAY).isResolvable()) {
            event.addBean((Bean)new ManagedExecutorBean(this.extSvc.defaultManagedExecutorFactory, DEFAULT_QUALIFIER_SET));
        }
        if (!cdi.select(ManagedScheduledExecutorService.class, DEFAULT_QUALIFIER_ARRAY).isResolvable()) {
            event.addBean((Bean)new ManagedScheduledExecutorBean(this.extSvc.defaultManagedScheduledExecutorFactory, DEFAULT_QUALIFIER_SET));
        }
        if (!cdi.select(ManagedThreadFactory.class, DEFAULT_QUALIFIER_ARRAY).isResolvable()) {
            event.addBean((Bean)new ManagedThreadFactoryBean(cmd, this.extSvc, DEFAULT_QUALIFIER_SET));
            this.producedDefaultMTF = true;
        }
        if ((listFromModule = this.extSvc.removeAll(cmd.getJ2EEName().toString())) != null) {
            this.addBeans(event, listFromModule);
        }
        if ((listFromApp = this.extSvc.removeAll(jeeName.getApplication())) != null) {
            this.addBeans(event, listFromApp);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addBeans(AfterBeanDiscovery event, List<Map<List<String>, QualifiedResourceFactory>> list) {
        Map<List<String>, QualifiedResourceFactory> qualifiedContextServices = list.get(QualifiedResourceFactory.Type.ContextService.ordinal());
        for (QualifiedResourceFactory qualifiedResourceFactory : qualifiedContextServices.values()) {
            try {
                event.addBean((Bean)new ContextServiceBean(qualifiedResourceFactory));
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.concurrent.internal.cdi.ConcurrencyExtension", (String)"162", (Object)this, (Object[])new Object[]{event, list});
                Tr.error((TraceComponent)tc, (String)"CWWKC1411.qualified.res.err", (Object[])new Object[]{ContextService.class.getSimpleName(), ContextServiceDefinition.class.getSimpleName(), "context-service", qualifiedResourceFactory.getName(), qualifiedResourceFactory.getQualifiers(), ConcurrencyExtension.toArtifactName(qualifiedResourceFactory.getDeclaringMetadata()), ConcurrencyExtension.toStackTrace(throwable)});
            }
        }
        Map<List<String>, QualifiedResourceFactory> qualifiedManagedExecutors = list.get(QualifiedResourceFactory.Type.ManagedExecutorService.ordinal());
        for (QualifiedResourceFactory qualifiedResourceFactory : qualifiedManagedExecutors.values()) {
            try {
                event.addBean((Bean)new ManagedExecutorBean(qualifiedResourceFactory));
            }
            catch (Throwable throwable) {
                void x;
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.concurrent.internal.cdi.ConcurrencyExtension", (String)"180", (Object)this, (Object[])new Object[]{event, list});
                Tr.error((TraceComponent)tc, (String)"CWWKC1411.qualified.res.err", (Object[])new Object[]{ManagedExecutorService.class.getSimpleName(), ManagedExecutorDefinition.class.getSimpleName(), "managed-executor", qualifiedResourceFactory.getName(), qualifiedResourceFactory.getQualifiers(), ConcurrencyExtension.toArtifactName(qualifiedResourceFactory.getDeclaringMetadata()), ConcurrencyExtension.toStackTrace((Throwable)x)});
            }
        }
        Map<List<String>, QualifiedResourceFactory> map = list.get(QualifiedResourceFactory.Type.ManagedScheduledExecutorService.ordinal());
        for (QualifiedResourceFactory factory : map.values()) {
            try {
                event.addBean((Bean)new ManagedScheduledExecutorBean(factory));
            }
            catch (Throwable throwable) {
                void x;
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.concurrent.internal.cdi.ConcurrencyExtension", (String)"198", (Object)this, (Object[])new Object[]{event, list});
                Tr.error((TraceComponent)tc, (String)"CWWKC1411.qualified.res.err", (Object[])new Object[]{ManagedScheduledExecutorService.class.getSimpleName(), ManagedScheduledExecutorDefinition.class.getSimpleName(), "managed-scheduled-executor", factory.getName(), factory.getQualifiers(), ConcurrencyExtension.toArtifactName(factory.getDeclaringMetadata()), ConcurrencyExtension.toStackTrace((Throwable)x)});
            }
        }
        Map<List<String>, QualifiedResourceFactory> map2 = list.get(QualifiedResourceFactory.Type.ManagedThreadFactory.ordinal());
        for (QualifiedResourceFactory factory : map2.values()) {
            try {
                event.addBean((Bean)new ManagedThreadFactoryBean(factory, this.extSvc));
            }
            catch (Throwable throwable) {
                void x;
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.concurrent.internal.cdi.ConcurrencyExtension", (String)"216", (Object)this, (Object[])new Object[]{event, list});
                Tr.error((TraceComponent)tc, (String)"CWWKC1411.qualified.res.err", (Object[])new Object[]{ManagedThreadFactory.class.getSimpleName(), ManagedThreadFactoryDefinition.class.getSimpleName(), "managed-thread-factory", factory.getName(), factory.getQualifiers(), ConcurrencyExtension.toArtifactName(factory.getDeclaringMetadata()), ConcurrencyExtension.toStackTrace((Throwable)x)});
            }
        }
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        if (this.producedDefaultMTF) {
            CDI cdi = CDI.current();
            Instance instance = cdi.select(ManagedThreadFactory.class, new Annotation[0]);
            ManagedThreadFactory mtf = (ManagedThreadFactory)instance.get();
            mtf.toString();
        }
    }

    @Trivial
    private static String toArtifactName(MetaData metadata) {
        if (metadata instanceof ComponentMetaData) {
            return ((ComponentMetaData)metadata).getJ2EEName().toString();
        }
        if (metadata instanceof ModuleMetaData) {
            return ((ModuleMetaData)metadata).getJ2EEName().toString();
        }
        if (metadata instanceof ApplicationMetaData) {
            return ((ApplicationMetaData)metadata).getJ2EEName().toString();
        }
        return metadata.getName();
    }

    @Trivial
    private static String toStackTrace(Throwable x) {
        StringWriter s = new StringWriter();
        x.printStackTrace(new PrintWriter(s));
        return s.toString();
    }
}

