/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.servlet.CacheProxyRequest;
import com.ibm.ws.cache.servlet.ResponseSideEffect;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

class MementoEntry
implements Serializable {
    private static final long serialVersionUID = 0x50002002L;
    private static TraceComponent tc = Tr.register(MementoEntry.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    String cacheName;
    String template = null;
    Object[] contents = null;
    byte[] attributeTableBytes = null;
    CacheProxyRequest.Attribute[] attributeTable = null;
    byte[] endAttributeTableBytes = null;
    CacheProxyRequest.Attribute[] endAttributeTable = null;
    boolean include = false;
    boolean namedDispatch = false;
    String contextPath = null;
    boolean doNotConsume = false;
    String servletClassName = null;
    int outputStyle = 3;
    boolean externallyCacheable = false;
    boolean async = false;

    MementoEntry(String cName, String template, byte[] attributeTableBytes, byte[] endAttributeTableBytes, boolean include, boolean namedDispatch, String contextPath) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Building new Memento Entry for " + template + ", attributeTableBytes, endAttributeTableBytes, include = " + include + ", contextPath is " + contextPath), (Object[])new Object[0]);
        }
        this.cacheName = cName;
        this.template = template;
        this.contextPath = contextPath;
        this.attributeTableBytes = attributeTableBytes;
        this.endAttributeTableBytes = endAttributeTableBytes;
        this.include = include;
        this.namedDispatch = namedDispatch;
    }

    MementoEntry(String cName, String template, CacheProxyRequest.Attribute[] attributeTable, CacheProxyRequest.Attribute[] endAttributeTable, boolean include, boolean namedDispatch, String contextPath) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Building new Memento Entry for " + template + ", attributeTable = " + this.prettyPrintAttributeTable(attributeTable) + ", endAttributeTable = " + this.prettyPrintAttributeTable(endAttributeTable) + ", include = " + include + ", contextPath is " + contextPath), (Object[])new Object[0]);
        }
        this.cacheName = cName;
        this.contextPath = contextPath;
        this.template = template;
        this.attributeTable = attributeTable;
        this.endAttributeTable = endAttributeTable;
        this.include = include;
        this.namedDispatch = namedDispatch;
    }

    void addContents(Object[] contents) {
        this.contents = contents;
    }

    Object[] getContents() {
        return this.contents;
    }

    String getTemplate() {
        return this.template;
    }

    CacheProxyRequest.Attribute[] getAttributeTable() {
        if (this.attributeTable != null) {
            return this.attributeTable;
        }
        if (this.attributeTableBytes == null) {
            return null;
        }
        try {
            return (CacheProxyRequest.Attribute[])SerializationUtility.deserialize((byte[])this.attributeTableBytes, (String)this.cacheName);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.servlet.MementoEntry.getAttributeTable", (String)"134", (Object)this);
            return null;
        }
    }

    byte[] getAttributeTableBytes() {
        return this.attributeTableBytes;
    }

    CacheProxyRequest.Attribute[] getEndAttributeTable() {
        if (this.endAttributeTable != null) {
            return this.endAttributeTable;
        }
        if (this.endAttributeTableBytes == null) {
            return null;
        }
        try {
            return (CacheProxyRequest.Attribute[])SerializationUtility.deserialize((byte[])this.endAttributeTableBytes, null);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.servlet.MementoEntry.getEndAttributeTable", (String)"134", (Object)this);
            return null;
        }
    }

    byte[] getEndAttributeTableBytes() {
        return this.endAttributeTableBytes;
    }

    boolean getInclude() {
        return this.include;
    }

    boolean getNamedDispatch() {
        return this.namedDispatch;
    }

    String getContextPath() {
        return this.contextPath;
    }

    public boolean getDoNotConsume() {
        return this.doNotConsume;
    }

    public void setDoNotConsume(boolean doNotConsume) {
        this.doNotConsume = doNotConsume;
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public void setServletClassName(String servletClassName) {
        this.servletClassName = servletClassName;
    }

    public void setOutputStyle(int outputStyle) {
        this.outputStyle = outputStyle;
    }

    public void setExternallyCacheable(boolean externallyCacheable) {
        this.externallyCacheable = externallyCacheable;
    }

    public boolean isExternallyCacheable() {
        return this.externallyCacheable;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean a) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("template=" + this.template + " async=" + a), (Object[])new Object[0]);
        }
        this.async = a;
    }

    public byte[] toByteArray(String charEnc) throws IOException {
        if (!this.isExternallyCacheable()) {
            throw new IllegalStateException("Cannot obtain byteArray since caching was not enabled for this fragment");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWriter osw = null;
        byte[] array = null;
        for (int i = 0; i < this.contents.length; ++i) {
            Object object = this.contents[i];
            if (object instanceof byte[]) {
                if (this.outputStyle != 1) {
                    throw new IllegalStateException("MementoEntry " + this + " with outputStyle " + this.outputStyle + " cannot contain byte arrays");
                }
                outputStream.write((byte[])object, 0, ((byte[])object).length);
                outputStream.flush();
                continue;
            }
            if (object instanceof char[]) {
                if (this.outputStyle != 2) {
                    throw new IllegalStateException("MementoEntry " + this + " with outputStyle " + this.outputStyle + " cannot contain char arrays");
                }
                if (osw == null) {
                    try {
                        osw = new OutputStreamWriter((OutputStream)outputStream, charEnc);
                    }
                    catch (UnsupportedEncodingException uex) {
                        FFDCFilter.processException((Throwable)uex, (String)"com.ibm.ws.cache.servlet.FragmentComposer.toByteArray", (String)"671", (Object)this);
                        osw = new OutputStreamWriter(outputStream);
                    }
                }
                osw.write((char[])object, 0, ((char[])object).length);
                osw.flush();
                continue;
            }
            if (object instanceof String || object instanceof ResponseSideEffect) continue;
            if (!(object instanceof MementoEntry)) {
                throw new IllegalStateException("MementoEntry should only contain other MementoEntries, Byte Arrays, Char Arrays, and ResponseSideEffects");
            }
            MementoEntry mementoEntry = (MementoEntry)object;
            array = mementoEntry.toByteArray(charEnc);
            outputStream.write(array, 0, array.length);
        }
        return outputStream.toByteArray();
    }

    public int hashCode() {
        int hc = 0;
        if (this.isExternallyCacheable()) {
            for (int i = 0; i < this.contents.length; ++i) {
                Object object = this.contents[i];
                if (object instanceof byte[]) {
                    hc += object.hashCode();
                    continue;
                }
                if (object instanceof char[]) {
                    hc += object.hashCode();
                    continue;
                }
                if (object instanceof String || object instanceof ResponseSideEffect || !(object instanceof MementoEntry)) continue;
                MementoEntry mementoEntry = (MementoEntry)object;
                hc += mementoEntry.hashCode();
            }
        }
        return hc;
    }

    private String prettyPrintAttributeTable(CacheProxyRequest.Attribute[] attrs) {
        StringBuffer sb = new StringBuffer();
        if (null != attrs) {
            for (int i = 0; i < attrs.length; ++i) {
                CacheProxyRequest.Attribute attr = attrs[i];
                sb.append(System.getProperty("line.separator"));
                sb.append(attr);
            }
        } else {
            sb.append("null");
        }
        return sb.toString();
    }
}

