/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.network.internal;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.net.internal.InetSocketAddressUtil;
import io.opentelemetry.instrumentation.api.instrumenter.network.NetworkAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.AddressAndPortExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.NetworkAttributes;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.SemanticAttributes;
import jakarta.annotation.Nullable;
import java.net.InetSocketAddress;
import java.util.Locale;

public final class InternalNetworkAttributesExtractor<REQUEST, RESPONSE> {
    private final NetworkAttributesGetter<REQUEST, RESPONSE> getter;
    private final AddressAndPortExtractor<REQUEST> logicalPeerAddressAndPortExtractor;
    private final boolean captureProtocolAttributes;
    private final boolean captureLocalSocketAttributes;
    private final boolean captureOldPeerDomainAttribute;
    private final boolean emitStableUrlAttributes;
    private final boolean emitOldHttpAttributes;

    public InternalNetworkAttributesExtractor(NetworkAttributesGetter<REQUEST, RESPONSE> getter, AddressAndPortExtractor<REQUEST> logicalPeerAddressAndPortExtractor, boolean captureProtocolAttributes, boolean captureLocalSocketAttributes, boolean captureOldPeerDomainAttribute, boolean emitStableUrlAttributes, boolean emitOldHttpAttributes) {
        this.getter = getter;
        this.logicalPeerAddressAndPortExtractor = logicalPeerAddressAndPortExtractor;
        this.captureProtocolAttributes = captureProtocolAttributes;
        this.captureLocalSocketAttributes = captureLocalSocketAttributes;
        this.captureOldPeerDomainAttribute = captureOldPeerDomainAttribute;
        this.emitStableUrlAttributes = emitStableUrlAttributes;
        this.emitOldHttpAttributes = emitOldHttpAttributes;
    }

    public void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response) {
        String peerAddress;
        String localAddress;
        String protocolName = InternalNetworkAttributesExtractor.lowercase(this.getter.getNetworkProtocolName(request, response));
        String protocolVersion = InternalNetworkAttributesExtractor.lowercase(this.getter.getNetworkProtocolVersion(request, response));
        if (this.emitStableUrlAttributes && this.captureProtocolAttributes) {
            String transport = InternalNetworkAttributesExtractor.lowercase(this.getter.getNetworkTransport(request, response));
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NETWORK_TRANSPORT, transport);
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NETWORK_TYPE, InternalNetworkAttributesExtractor.lowercase(this.getter.getNetworkType(request, response)));
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NETWORK_PROTOCOL_NAME, protocolName);
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NETWORK_PROTOCOL_VERSION, protocolVersion);
        }
        if (this.emitOldHttpAttributes) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_PROTOCOL_NAME, protocolName);
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_PROTOCOL_VERSION, protocolVersion);
        }
        if ((localAddress = this.getter.getNetworkLocalAddress(request, response)) != null) {
            Integer localPort;
            if (this.emitStableUrlAttributes && this.captureLocalSocketAttributes) {
                AttributesExtractorUtil.internalSet(attributes, NetworkAttributes.NETWORK_LOCAL_ADDRESS, localAddress);
            }
            if (this.emitOldHttpAttributes) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_HOST_ADDR, localAddress);
            }
            if ((localPort = this.getter.getNetworkLocalPort(request, response)) != null && localPort > 0) {
                if (this.emitStableUrlAttributes && this.captureLocalSocketAttributes) {
                    AttributesExtractorUtil.internalSet(attributes, NetworkAttributes.NETWORK_LOCAL_PORT, Long.valueOf(localPort.intValue()));
                }
                if (this.emitOldHttpAttributes) {
                    AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_HOST_PORT, Long.valueOf(localPort.intValue()));
                }
            }
        }
        if ((peerAddress = this.getter.getNetworkPeerAddress(request, response)) != null) {
            InetSocketAddress peerSocketAddress;
            Integer peerPort;
            if (this.emitStableUrlAttributes) {
                AttributesExtractorUtil.internalSet(attributes, NetworkAttributes.NETWORK_PEER_ADDRESS, peerAddress);
            }
            if (this.emitOldHttpAttributes) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_PEER_ADDR, peerAddress);
            }
            if ((peerPort = this.getter.getNetworkPeerPort(request, response)) != null && peerPort > 0) {
                if (this.emitStableUrlAttributes) {
                    AttributesExtractorUtil.internalSet(attributes, NetworkAttributes.NETWORK_PEER_PORT, Long.valueOf(peerPort.intValue()));
                }
                if (this.emitOldHttpAttributes) {
                    AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_PEER_PORT, Long.valueOf(peerPort.intValue()));
                }
            }
            if (this.emitOldHttpAttributes && this.captureOldPeerDomainAttribute && (peerSocketAddress = this.getter.getNetworkPeerInetSocketAddress(request, response)) != null) {
                String peerSocketDomain = InetSocketAddressUtil.getDomainName(peerSocketAddress);
                String logicalPeerAddress = this.logicalPeerAddressAndPortExtractor.extract(request).address;
                if (peerSocketDomain != null && !peerSocketDomain.equals(logicalPeerAddress)) {
                    AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_PEER_NAME, peerSocketDomain);
                }
            }
        }
    }

    @Nullable
    private static String lowercase(@Nullable String str) {
        return str == null ? null : str.toLowerCase(Locale.ROOT);
    }
}

