/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.opentracing.internal.jaxrs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jaxrs20.providers.api.JaxRsProviderRegister;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.opentracing.internal.OpentracingClientFilter;
import io.openliberty.opentracing.internal.OpentracingContainerFilter;
import io.openliberty.opentracing.internal.OpentracingFilterHelperProvider;
import io.openliberty.opentracing.internal.OpentracingFilterProvider;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, service={JaxRsProviderRegister.class, OpentracingFilterProvider.class})
public class OpentracingJaxRsProviderRegister
implements JaxRsProviderRegister,
OpentracingFilterProvider {
    private static final TraceComponent tc = Tr.register(OpentracingJaxRsProviderRegister.class, null, null);
    @Reference
    protected OpentracingFilterHelperProvider helper;
    private OpentracingContainerFilter containerFilter;
    private OpentracingClientFilter clientFilter;
    static final long serialVersionUID = 7018520397839381470L;

    protected void activate(ComponentContext context) {
        this.containerFilter = new OpentracingContainerFilter();
        this.clientFilter = new OpentracingClientFilter();
    }

    protected void deactivate(ComponentContext context) {
        this.containerFilter = null;
        this.clientFilter = null;
    }

    @Trivial
    public OpentracingContainerFilter getContainerFilter() {
        return this.containerFilter;
    }

    @Trivial
    public OpentracingClientFilter getClientFilter() {
        return this.clientFilter;
    }

    @Trivial
    public void installProvider(boolean clientSide, List<Object> providers, Set<String> features) {
        String methodName = "installProvider";
        if (clientSide) {
            OpentracingClientFilter useClientFilter = this.getClientFilter();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Client Filter", useClientFilter});
            }
            if (useClientFilter != null) {
                providers.add(useClientFilter);
            }
        } else {
            OpentracingContainerFilter useContainerFilter = this.getContainerFilter();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Container Filter", useContainerFilter});
            }
            if (useContainerFilter != null) {
                providers.add(useContainerFilter);
            }
        }
    }
}

