/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.kerberos.auth.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class LRUCache {
    private static final TraceComponent tc = Tr.register(LRUCache.class, (String)"Kerberos", (String)"com.ibm.ws.security.kerberos.auth.internal.resources.KerberosMessages");
    private final Map<KerberosPrincipal, Subject> cache = Collections.synchronizedMap(new LinkedHashMap<KerberosPrincipal, Subject>(16, 0.75f, true){
        private static final long serialVersionUID = -2909022937597369536L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > LRUCache.this.MAX_ENTRIES;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.kerberos.auth.internal.LRUCache$1", 1.class, (String)"Kerberos", (String)"com.ibm.ws.security.kerberos.auth.internal.resources.KerberosMessages");
        }
    });
    private final int MAX_ENTRIES;
    static final long serialVersionUID = -3878574265013818731L;

    public LRUCache(int size) {
        this.MAX_ENTRIES = size;
        if (size < 1) {
            throw new IllegalArgumentException("Size < 1: " + size);
        }
    }

    public void clear() {
        this.cache.clear();
    }

    public void put(KerberosPrincipal key, Subject value) {
        this.cache.put(key, value);
    }

    public Subject get(KerberosPrincipal principal) {
        return this.cache.computeIfPresent(principal, (p, sub) -> {
            Set<KerberosTicket> kerbTickets;
            Iterator<KerberosTicket> iterator;
            Set<GSSCredential> gssCreds = sub.getPrivateCredentials(GSSCredential.class);
            Iterator<GSSCredential> iterator2 = gssCreds.iterator();
            if (iterator2.hasNext()) {
                GSSCredential gssCred = iterator2.next();
                int remainingLifetime = -1;
                try {
                    remainingLifetime = gssCred.getRemainingLifetime();
                }
                catch (GSSException gSSException) {
                    // empty catch block
                }
                if (remainingLifetime <= 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("no match because remaining lifetime is: " + remainingLifetime), (Object[])new Object[0]);
                    }
                    return null;
                }
            }
            if ((iterator = (kerbTickets = sub.getPrivateCredentials(KerberosTicket.class)).iterator()).hasNext()) {
                boolean shouldRefresh;
                KerberosTicket kerbTicket = iterator.next();
                if (kerbTicket.isDestroyed()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Found destroyed kerberos ticket. Removing from cache", (Object[])new Object[0]);
                    }
                    return null;
                }
                Instant now = Instant.now();
                Instant endTime = kerbTicket.getEndTime().toInstant();
                boolean bl = shouldRefresh = kerbTicket.isRenewable() && now.isAfter(endTime.minus(10L, ChronoUnit.MINUTES));
                if (!kerbTicket.isCurrent() || shouldRefresh) {
                    if (!kerbTicket.isRenewable()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"no match because ticket is not current and not renewable", (Object[])new Object[0]);
                        }
                        return null;
                    }
                    if (!shouldRefresh) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"no match because ticket is renewable but past the renewTill time", (Object[])new Object[0]);
                        }
                        return null;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"found match for non-current ticket, but ticket is renewable. Attempting to renew now", (Object[])new Object[0]);
                    }
                    try {
                        kerbTicket.refresh();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Successfully renewed ticket", (Object[])new Object[0]);
                        }
                    }
                    catch (RefreshFailedException e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("unable to refresh kerberos ticket due to: " + e), (Object[])new Object[0]);
                        }
                        return null;
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found cached subject for principal: " + principal), (Object[])new Object[0]);
            }
            return sub;
        });
    }

    public Object remove(KerberosPrincipal key) {
        return this.cache.remove(key);
    }
}

