/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util.rofl;

import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.yoko.util.rofl.Rofl;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class RoflHelper {
    private static final Logger logger = Logger.getLogger(RoflHelper.class.getName());
    private final int slotId;

    public RoflHelper(int slotId) {
        this.slotId = slotId;
    }

    public void findAndSave(ServerRequestInfo requestInfo) {
        Rofl.RemoteOrb.KNOWN_REMOTE_ORBS.stream().map(remoteOrb -> {
            try {
                return requestInfo.get_request_service_context(remoteOrb.serviceContextId.intValue());
            }
            catch (BAD_PARAM e) {
                if (e.minor == 1330446362) {
                    return null;
                }
                throw e;
            }
        }).filter(Objects::nonNull).findFirst().ifPresent(sc -> {
            Any any = ORB.init().create_any();
            ServiceContextHelper.insert((Any)any, (ServiceContext)sc);
            try {
                requestInfo.set_slot(this.slotId, any);
            }
            catch (InvalidSlot e) {
                throw (INTERNAL)new INTERNAL(e.getMessage()).initCause((Throwable)e);
            }
        });
    }

    public Rofl loadAndCreate(ServerRequestInfo requestInfo) {
        try {
            return Optional.of(requestInfo.get_slot(this.slotId)).filter(any -> any.type().kind() == ServiceContextHelper.type().kind()).map(ServiceContextHelper::extract).map(RoflHelper::createFromServiceContext).orElse(Rofl.NONE);
        }
        catch (InvalidSlot e) {
            throw (INTERNAL)new INTERNAL(e.getMessage()).initCause((Throwable)e);
        }
    }

    private static Rofl createFromServiceContext(ServiceContext serviceContext) {
        return Rofl.RemoteOrb.of(serviceContext).map(ro -> ro.createRofl(serviceContext)).orElseGet(() -> {
            logger.warning("Failed to find ROFL for service context id:" + serviceContext.context_id);
            return Rofl.RemoteOrb.BAD.createRofl(serviceContext);
        });
    }

    public static Rofl createFromTaggedComponent(ClientRequestInfo ri) {
        return Rofl.RemoteOrb.KNOWN_REMOTE_ORBS.stream().map(remoteOrb -> {
            try {
                TaggedComponent tc = ri.get_effective_component(remoteOrb.tagComponentId.intValue());
                return remoteOrb.createRofl(tc);
            }
            catch (BAD_PARAM e) {
                if (e.minor == 1330446364) {
                    return null;
                }
                throw e;
            }
        }).filter(Objects::nonNull).findFirst().orElse(Rofl.NONE);
    }
}

