/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.list;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.list.Link;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

public class LinkedList {
    private static TraceComponent tc = SibTr.register(LinkedList.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private final Link _dummyHead = new Link();
    private final Link _dummyTail = new Link();
    private long _nextPositionToIssue = 0L;

    public LinkedList() {
        this._dummyHead._setAsHead(this, this._dummyTail);
        this._dummyTail._setAsTail(this, this._dummyHead);
    }

    final String _debugString() {
        StringBuffer buf = new StringBuffer();
        Link link = this._dummyHead;
        link._shortDebugString(buf);
        int limit = 10;
        for (link = link._getNextLink(); link != null && 0 < limit--; link = link._getNextLink()) {
            buf.append(",");
            link._shortDebugString(buf);
        }
        return buf.toString();
    }

    public final synchronized void append(Link link) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"append");
        }
        Link prev = this._dummyTail._getPreviousLink();
        link._link(prev, this._dummyTail, this._nextPositionToIssue++, this);
        prev._setNextLink(link);
        this._dummyTail._setPreviousLink(link);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"append", (Object)this._debugString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AbstractItem findFirstMatching(Filter filter) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatching", (Object)filter);
        }
        AbstractItem found = null;
        Link link = this.getHead();
        while (link != null && found == null) {
            found = ((AbstractItemLink)link).matches(filter);
            if (found != null) continue;
            LinkedList linkedList = this;
            synchronized (linkedList) {
                if (link.isPhysicallyUnlinked()) {
                    link = this.getHead();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Current link is PhysicallyUnlinked so returning to beginning of list.");
                    }
                } else {
                    link = link.getNextLogicalLink();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatching", (Object)found);
        }
        return found;
    }

    public final Link getDummyHead() {
        return this._dummyHead;
    }

    public final Link getHead() {
        return this.getNextLink(null);
    }

    public final synchronized Link getNextLink(Link link) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNextLink", (Object)link);
        }
        Link nextLink = null;
        if (link == null) {
            nextLink = this._dummyHead.getNextPhysicalLink();
        } else if (link.isPhysicallyUnlinked()) {
            nextLink = this._dummyHead.getNextPhysicalLink();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Current link is PhysicallyUnlinked so returning to beginning of list.");
            }
        } else {
            nextLink = link.getNextPhysicalLink();
        }
        while (nextLink != null && nextLink.isLogicallyUnlinked()) {
            nextLink = nextLink.getNextPhysicalLink();
        }
        if (nextLink == this._dummyTail) {
            nextLink = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getNextLink", (Object)nextLink);
        }
        return nextLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AbstractItem removeFirstMatching(Filter filter, PersistentTransaction transaction) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatching", (Object)new Object[]{filter, transaction});
        }
        AbstractItem found = null;
        Link link = this.getHead();
        while (link != null && found == null) {
            found = ((AbstractItemLink)link).removeIfMatches(filter, transaction);
            if (found != null) continue;
            LinkedList linkedList = this;
            synchronized (linkedList) {
                if (link.isPhysicallyUnlinked()) {
                    link = this.getHead();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Current link is PhysicallyUnlinked so returning to beginning of list.");
                    }
                } else {
                    link = link.getNextLogicalLink();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatching", (Object)found);
        }
        return found;
    }

    public final void xmlWriteOn(FormattedWriter writer, String tagName) throws IOException {
        Link link = this.getHead();
        if (link != null) {
            writer.newLine();
            writer.startTag(tagName);
            writer.indent();
            while (link != null) {
                writer.newLine();
                link.xmlWriteOn(writer);
                link = link.getNextPhysicalLink();
            }
            writer.outdent();
            writer.newLine();
            writer.endTag(tagName);
        }
    }

    public int countLinks() {
        int count = 0;
        for (Link look = this._dummyHead.getNextLogicalLink(); look != null && this._dummyTail != look; look = look._getNextLink()) {
            ++count;
        }
        return count;
    }
}

