/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.LogRecord;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.DataInputStream;
import java.io.IOException;

class PaddingLogRecord
extends LogRecord {
    private static final Class cclass = PaddingLogRecord.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerTransactions");
    private static final long serialVersionUID = 4725890292906828188L;
    protected static final int overhead = 8;
    int totalSize;

    protected PaddingLogRecord(int totalSize) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", "TotalSize=" + totalSize);
        }
        this.totalSize = totalSize;
        this.buffers = this.getBuffers();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected PaddingLogRecord(DataInputStream dataInputStream) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{dataInputStream});
        }
        try {
            this.totalSize = dataInputStream.readInt();
            byte[] padBuffer = new byte[this.totalSize];
            dataInputStream.read(padBuffer);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "<init>", exception, "1:98:1.9");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "<init>", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    @Override
    protected int getBytesLeft() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getSerializedByteCount");
        }
        int bytesLeft = this.bufferCursor == 0 ? this.totalSize - this.bufferByteCursor : this.totalSize - 8 - this.bufferByteCursor;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getBytesLeft", "return=" + bytesLeft);
        }
        return bytesLeft;
    }

    @Override
    protected int fillBuffer(byte[] buffer, int offset, int length) throws ObjectManagerException {
        int lengthToCopy;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "fillBuffer");
        }
        if (this.buffers == null) {
            this.buffers = this.getBuffers();
        }
        if (this.bufferCursor == 0) {
            lengthToCopy = Math.min(this.buffers[this.bufferCursor].getCount() - this.bufferByteCursor, length);
            System.arraycopy(this.buffers[this.bufferCursor].getBuffer(), this.bufferByteCursor, buffer, offset, lengthToCopy);
            offset += lengthToCopy;
            this.bufferByteCursor += lengthToCopy;
            if ((length -= lengthToCopy) > 0) {
                ++this.bufferCursor;
                this.bufferByteCursor = 0;
            }
        }
        if (length > 0) {
            lengthToCopy = Math.min(this.totalSize - 8 - this.bufferByteCursor, length);
            offset += lengthToCopy;
            this.bufferByteCursor += lengthToCopy;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "fillBuffer", "return=" + offset);
        }
        return offset;
    }

    @Override
    protected ObjectManagerByteArrayOutputStream[] getBuffers() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getBuffers");
        }
        ObjectManagerByteArrayOutputStream[] buffers = new ObjectManagerByteArrayOutputStream[]{new ObjectManagerByteArrayOutputStream(8)};
        buffers[0].writeInt(11);
        buffers[0].writeInt(this.totalSize - 8);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getBuffers", new Object[]{buffers});
        }
        return buffers;
    }

    @Override
    public void performRecovery(ObjectManagerState objectManagerState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "performRecovery", new Object[]{objectManagerState});
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "performRecovery");
        }
    }
}

