/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorization.jacc.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.jacc.PolicyConfigurationManager;
import com.ibm.ws.security.authorization.jacc.common.PolicyProxy;
import com.ibm.ws.security.authorization.jacc.ejb.EJBSecurityPropagator;
import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContextException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ApplicationStateListener.class, PolicyConfigurationManager.class})
public class PolicyConfigurationManagerImpl
implements ApplicationStateListener,
PolicyConfigurationManager {
    private static final TraceComponent tc = Tr.register(PolicyConfigurationManagerImpl.class, (String)"Security.Authorization", (String)"com.ibm.ws.security.authorization.jacc.internal.resources.JaccAuthorizationMessages");
    private final Map<String, List<PolicyConfiguration>> pcConfigsMap = new ConcurrentHashMap<String, List<PolicyConfiguration>>();
    private final Map<String, List<String>> pcModulesMap = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, List<String>> pcEjbMap = new ConcurrentHashMap<String, List<String>>();
    private final List<String> pcRunningList = new CopyOnWriteArrayList<String>();
    private PolicyConfigurationFactory pcf = null;
    private PolicyProxy policyProxy = null;
    private EJBSecurityPropagator esp = null;
    static final long serialVersionUID = -4531379711438913345L;

    @Override
    public void setEJBSecurityPropagator(EJBSecurityPropagator esp) {
        this.esp = esp;
    }

    @Override
    public void initialize(PolicyProxy policyProxy, PolicyConfigurationFactory pcf) {
        this.policyProxy = policyProxy;
        this.pcf = pcf;
        this.pcConfigsMap.clear();
        this.pcModulesMap.clear();
        this.pcRunningList.clear();
    }

    @Override
    public void linkConfiguration(String appName, PolicyConfiguration pc) throws PolicyContextException {
        List<PolicyConfiguration> pcs = this.pcConfigsMap.get(appName);
        if (pcs != null) {
            pc.linkConfiguration(pcs.get(0));
        } else {
            pcs = new ArrayList<PolicyConfiguration>();
            this.pcConfigsMap.put(appName, pcs);
        }
        pcs.add(pc);
    }

    @Override
    public void addModule(String appName, String contextId) {
        List<String> ctxIds = this.pcModulesMap.get(appName);
        if (ctxIds == null) {
            ctxIds = new ArrayList<String>();
            this.pcModulesMap.put(appName, ctxIds);
        }
        if (!ctxIds.contains(contextId)) {
            ctxIds.add(contextId);
        }
        if (this.isApplicationRunning(appName)) {
            this.processEJBs(appName);
            this.commitModules(appName);
        }
    }

    @Override
    public boolean containModule(String appName, String contextId) {
        List<String> ctxIds = this.pcModulesMap.get(appName);
        return ctxIds != null && ctxIds.contains(contextId);
    }

    @Override
    public void removeModule(String appName, String contextId) {
        int index;
        List<String> ctxIds = this.pcModulesMap.get(appName);
        if (ctxIds != null && (index = ctxIds.indexOf(contextId)) >= 0) {
            ctxIds.remove(index);
            if (ctxIds.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Removing application : " + appName), (Object[])new Object[0]);
                }
                this.pcModulesMap.remove(appName);
            }
        }
    }

    @Override
    public void addEJB(String appName, String contextId) {
        List<String> ctxIds = this.pcEjbMap.get(appName);
        if (ctxIds == null) {
            ctxIds = new ArrayList<String>();
            this.pcEjbMap.put(appName, ctxIds);
        }
        if (!ctxIds.contains(contextId)) {
            ctxIds.add(contextId);
        }
        this.addModule(appName, contextId);
    }

    @Override
    public boolean isApplicationRunning(String appName) {
        return this.pcRunningList.contains(appName);
    }

    protected void processEJBs(String appName) {
        List<String> ctxIds = this.pcEjbMap.get(appName);
        if (ctxIds != null) {
            for (String contextId : ctxIds) {
                if (this.esp != null) {
                    this.esp.processEJBRoles(this.pcf, contextId, this);
                    continue;
                }
                Tr.error((TraceComponent)tc, (String)"JACC_NO_EJB_PLUGIN", (Object[])new Object[0]);
            }
            this.pcEjbMap.remove(appName);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void commitModules(String appName) {
        List<PolicyConfiguration> pcs = this.pcConfigsMap.get(appName);
        if (pcs != null) {
            for (PolicyConfiguration pc : pcs) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Comitting PolicyConfigurations : " + pc), (Object[])new Object[0]);
                }
                try {
                    pc.commit();
                }
                catch (PolicyContextException policyContextException) {
                    void pce;
                    FFDCFilter.processException((Throwable)policyContextException, (String)"com.ibm.ws.security.authorization.jacc.common.PolicyConfigurationManagerImpl", (String)"161", (Object)this, (Object[])new Object[]{appName});
                    String ctxId = null;
                    try {
                        ctxId = pc.getContextID();
                    }
                    catch (PolicyContextException policyContextException2) {
                        FFDCFilter.processException((Throwable)policyContextException2, (String)"com.ibm.ws.security.authorization.jacc.common.PolicyConfigurationManagerImpl", (String)"165", (Object)this, (Object[])new Object[]{appName});
                        ctxId = "<<UNKNOWN>>";
                    }
                    Tr.error((TraceComponent)tc, (String)"JACC_GET_POLICYCONFIGURATION_FAILURE", (Object[])new Object[]{ctxId, pce});
                }
            }
            this.policyProxy.refresh();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeModules(String appName) {
        List<String> ctxIds = this.pcModulesMap.get(appName);
        if (ctxIds != null) {
            for (String ctxId : ctxIds) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("contextID : " + ctxId), (Object[])new Object[0]);
                }
                PolicyConfiguration pc = null;
                try {
                    pc = this.pcf.getPolicyConfiguration(ctxId, false);
                    if (pc == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Deleting PolicyConfigurations : " + pc), (Object[])new Object[0]);
                    }
                    pc.delete();
                }
                catch (PolicyContextException policyContextException) {
                    void pce;
                    FFDCFilter.processException((Throwable)policyContextException, (String)"com.ibm.ws.security.authorization.jacc.common.PolicyConfigurationManagerImpl", (String)"189", (Object)this, (Object[])new Object[]{appName});
                    Tr.error((TraceComponent)tc, (String)"JACC_GET_POLICYCONFIGURATION_FAILURE", (Object[])new Object[]{ctxId, pce});
                }
            }
            this.policyProxy.refresh();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"refresh is invoked after deleting PolicyConfigurations", (Object[])new Object[0]);
            }
            this.pcModulesMap.remove(appName);
            this.pcConfigsMap.remove(appName);
        }
    }

    public void applicationStarting(ApplicationInfo appInfo) {
    }

    public void applicationStarted(ApplicationInfo appInfo) {
        String appName = appInfo.getDeploymentName();
        if (appName != null) {
            this.processEJBs(appName);
            this.commitModules(appName);
            this.pcRunningList.add(appName);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("commit all modules and refresh is invoked after the application is started. AppName : " + appName), (Object[])new Object[0]);
            }
        }
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        String appName = appInfo.getDeploymentName();
        if (appName != null) {
            this.removeModules(appName);
            this.pcRunningList.remove(appName);
        }
    }
}

