/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract.platform;

import wlp.lib.extract.platform.Platform;

public abstract class AbstractPlatformPolicyFactory {
    private Object m_platformPolicy = null;

    protected Object getPlatformPolicy() {
        if (this.m_platformPolicy == null) {
            if (Platform.isWindows()) {
                this.m_platformPolicy = this.createWindowsPolicy();
            } else if (Platform.isLinux()) {
                this.m_platformPolicy = this.createLinuxPolicy();
            } else if (Platform.isSolaris()) {
                this.m_platformPolicy = this.createSolarisPolicy();
            } else if (Platform.isAIX()) {
                this.m_platformPolicy = this.createAIXPolicy();
            } else if (Platform.isHPUX()) {
                this.m_platformPolicy = this.createHPUXPolicy();
            } else if (Platform.isZOS()) {
                this.m_platformPolicy = this.createZOSPolicy();
            } else if (Platform.isOS400()) {
                this.m_platformPolicy = this.createOS400Policy();
            } else if (Platform.isMACOS()) {
                this.m_platformPolicy = this.createMACOSPolicy();
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return this.m_platformPolicy;
    }

    protected Object createWindowsPolicy() {
        throw new UnsupportedOperationException();
    }

    protected Object createLinuxPolicy() {
        throw new UnsupportedOperationException();
    }

    protected Object createSolarisPolicy() {
        return this.createLinuxPolicy();
    }

    protected Object createAIXPolicy() {
        return this.createLinuxPolicy();
    }

    protected Object createHPUXPolicy() {
        return this.createLinuxPolicy();
    }

    protected Object createZOSPolicy() {
        return this.createLinuxPolicy();
    }

    protected Object createOS400Policy() {
        return this.createLinuxPolicy();
    }

    protected Object createMACOSPolicy() {
        return this.createLinuxPolicy();
    }
}

