/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.netty;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.richclient.buffer.impl.RichByteBufferImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;

public class WsBufferToNettyEncoder
extends MessageToByteEncoder<WsByteBuffer> {
    private static final TraceComponent tc = SibTr.register(WsBufferToNettyEncoder.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");

    public void encode(ChannelHandlerContext ctx, WsByteBuffer msg, ByteBuf out) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"encode", (Object)ctx.channel());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"encode", (Object)(ctx.channel().remoteAddress() + " encoding message [ " + msg.toString() + " ] from WSByteBuffer to Netty ByteBuf"));
        }
        com.ibm.wsspi.bytebuffer.WsByteBuffer wrappedBuffer = (com.ibm.wsspi.bytebuffer.WsByteBuffer)((RichByteBufferImpl)msg).getUnderlyingBuffer();
        out.writeBytes(wrappedBuffer.getWrappedByteBuffer());
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"encode", (Object)ctx.channel());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"exceptionCaught", (Object)new Object[]{cause, ctx.channel()});
        }
        super.exceptionCaught(ctx, cause);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"exceptionCaught", (Object)new Object[]{cause, ctx.channel()});
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/netty/jfapchannel/WsBufferToNettyEncoder.java, SIB.comms, WASX.SIB, uu1215.01 1.1");
        }
    }
}

