/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.JSRemoteConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.processor.utils.linkedlist.Entry;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class AORequestedTick
extends Entry
implements AlarmListener {
    private static final TraceNLS nls_mt = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSJUMessages");
    private static TraceComponent tc = SibTr.register(AORequestedTick.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private final JSRemoteConsumerPoint parent;
    public final long tick;
    public final Long objTick;
    public final long timeout;
    public final long requestTime;
    private Alarm expiryHandle;
    private boolean satisfied;
    private SIMPMessage msg;
    private boolean expired;

    public AORequestedTick(JSRemoteConsumerPoint parent, long tick, Long objTick, long expiryTimeout, MPAlarmManager am) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AORequestedTick", (Object)new Object[]{parent, tick, objTick, expiryTimeout, am});
        }
        this.parent = parent;
        this.tick = tick;
        this.objTick = objTick;
        this.timeout = expiryTimeout;
        this.requestTime = System.currentTimeMillis();
        this.expiryHandle = expiryTimeout != -1L && expiryTimeout > 0L ? am.create(expiryTimeout, this) : null;
        this.satisfied = false;
        this.expired = false;
        this.msg = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AORequestedTick", (Object)this);
        }
    }

    public void alarm(Object thandle) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)thandle);
        }
        this.parent.expiryAlarm(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    public boolean expire(boolean cancelTimer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"expire", (Object)new Boolean(cancelTimer));
        }
        if (this.expiryHandle != null && cancelTimer) {
            this.expiryHandle.cancel();
        }
        this.expiryHandle = null;
        if (!this.satisfied) {
            this.expired = true;
            if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
                SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage("REMOTE_REQUEST_EXPIRED_CWSJU0033", new Object[]{this.tick}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"expire", (Object)new Boolean(this.expired));
        }
        return this.expired;
    }

    public boolean satisfy(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"satisfy");
        }
        if (this.expiryHandle != null) {
            this.expiryHandle.cancel();
        }
        if (!this.expired) {
            this.satisfied = true;
            this.msg = msg;
            if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
                SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage("REMOTE_REQUEST_SATISFIED_CWSJU0032", new Object[]{this.tick, msg}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"satisfy", (Object)new Boolean(this.satisfied));
        }
        return this.satisfied;
    }

    public final SIMPMessage getMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessage");
            SibTr.exit((TraceComponent)tc, (String)"getMessage", (Object)this.msg);
        }
        return this.msg;
    }
}

