/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DirectToFieldChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class VersionLockingPolicy
implements OptimisticLockingPolicy,
Serializable {
    protected DatabaseField writeLockField;
    protected boolean isCascaded;
    protected int lockValueStored;
    protected ClassDescriptor descriptor;
    protected transient Expression cachedExpression;
    public static final int IN_CACHE = 1;
    public static final int IN_OBJECT = 2;
    protected AbstractDirectMapping lockMapping;
    protected OptimisticLockingPolicy.LockOnChange lockOnChangeMode;

    public VersionLockingPolicy() {
        this.storeInCache();
    }

    public VersionLockingPolicy(String fieldName) {
        this(new DatabaseField(fieldName));
    }

    public VersionLockingPolicy(DatabaseField field) {
        this();
        this.setWriteLockField(field);
    }

    @Override
    public void addLockFieldsToUpdateRow(AbstractRecord databaseRow, AbstractSession session) {
        if (this.isStoredInCache()) {
            databaseRow.put(this.getWriteLockField(), (Object)null);
        }
    }

    @Override
    public void addLockValuesToTranslationRow(ObjectLevelModifyQuery query) {
        Object value = this.isStoredInCache() ? query.getSession().getIdentityMapAccessorInstance().getWriteLockValue(query.getPrimaryKey(), query.getObject().getClass(), this.getDescriptor()) : this.lockValueFromObject(query.getObject());
        if (value == null) {
            if (query.isDeleteObjectQuery()) {
                throw OptimisticLockException.noVersionNumberWhenDeleting(query.getObject(), query);
            }
            throw OptimisticLockException.noVersionNumberWhenUpdating(query.getObject(), query);
        }
        if (query.isUpdateObjectQuery()) {
            query.setShouldValidateUpdateCallCacheUse(true);
        }
        query.getTranslationRow().put(this.writeLockField, value);
    }

    @Override
    public Expression buildDeleteExpression(DatabaseTable table, Expression mainExpression, AbstractRecord row) {
        return this.buildUpdateExpression(table, mainExpression, row, null);
    }

    protected Expression buildExpression() {
        ExpressionBuilder builder = new ExpressionBuilder();
        return builder.getField(this.getWriteLockField()).equal(builder.getParameter(this.getWriteLockField()));
    }

    @Override
    public Expression buildUpdateExpression(DatabaseTable table, Expression mainExpression, AbstractRecord row, AbstractRecord row2) {
        if (this.cachedExpression == null) {
            this.cachedExpression = this.buildExpression();
        }
        if (this.getWriteLockField().getTableName().equals(table.getName())) {
            return mainExpression.and(this.cachedExpression);
        }
        return mainExpression;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean supportsWriteLockValuesComparison() {
        return true;
    }

    @Override
    public int compareWriteLockValues(Object value1, Object value2) {
        long longValue1 = ((Number)value1).longValue();
        long longValue2 = ((Number)value2).longValue();
        return Long.compare(longValue1, longValue2);
    }

    protected <T> Class<T> getDefaultLockingFieldType() {
        return ClassConstants.LONG;
    }

    @Override
    public <T> T getBaseValue() {
        return (T)Long.valueOf(0L);
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected <T> T getInitialWriteValue(AbstractSession session) {
        return (T)Long.valueOf(1L);
    }

    @Override
    public OptimisticLockingPolicy.LockOnChange getLockOnChangeMode() {
        return this.lockOnChangeMode;
    }

    public <T> T getNewLockValue(ModifyQuery query) {
        Class objectClass = query.getDescriptor().getJavaClass();
        Number value = this.isStoredInCache() ? (Number)((Number)query.getSession().getIdentityMapAccessorInstance().getWriteLockValue(((WriteObjectQuery)query).getPrimaryKey(), objectClass, this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(((ObjectLevelModifyQuery)query).getObject()));
        if (value == null) {
            throw OptimisticLockException.noVersionNumberWhenUpdating(((ObjectLevelModifyQuery)query).getObject(), (ObjectLevelModifyQuery)query);
        }
        Number newWriteLockValue = this.incrementWriteLockValue(value);
        return (T)newWriteLockValue;
    }

    protected List<DatabaseField> getUnmappedFields() {
        ArrayList<DatabaseField> fields = new ArrayList<DatabaseField>(1);
        if (this.isStoredInCache()) {
            fields.add(this.getWriteLockField());
        }
        return fields;
    }

    @Override
    public <T> T getValueToPutInCache(AbstractRecord row, AbstractSession session) {
        if (this.isStoredInCache()) {
            return (T)row.get(this.getWriteLockField());
        }
        return null;
    }

    @Override
    public int getVersionDifference(Object currentValue, Object domainObject, Object primaryKeys, AbstractSession session) {
        Number writeLockFieldValue;
        Number newWriteLockFieldValue = (Number)currentValue;
        if (newWriteLockFieldValue == null) {
            newWriteLockFieldValue = 0L;
        }
        if ((writeLockFieldValue = this.isStoredInCache() ? (Number)((Number)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKeys, domainObject.getClass(), this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(domainObject))) == null) {
            writeLockFieldValue = 0L;
        }
        return (int)(newWriteLockFieldValue.longValue() - writeLockFieldValue.longValue());
    }

    @Override
    public DatabaseField getWriteLockField() {
        return this.writeLockField;
    }

    public String getWriteLockFieldName() {
        return this.getWriteLockField().getQualifiedName();
    }

    @Override
    public Expression getWriteLockUpdateExpression(ExpressionBuilder builder, AbstractSession session) {
        return ExpressionMath.add(builder.getField(this.writeLockField.getName()), 1);
    }

    @Override
    public <T> T getWriteLockValue(Object domainObject, Object primaryKey, AbstractSession session) {
        Number writeLockFieldValue;
        if (this.isStoredInCache()) {
            if (primaryKey == null) {
                return null;
            }
            writeLockFieldValue = (Number)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor());
        } else {
            writeLockFieldValue = (Number)this.lockValueFromObject(domainObject);
        }
        return (T)writeLockFieldValue;
    }

    protected Number incrementWriteLockValue(Number numberValue) {
        return numberValue.longValue() + 1L;
    }

    @Override
    public void initialize(AbstractSession session) {
        DatabaseMapping mapping = this.descriptor.getObjectBuilder().getMappingForField(this.getWriteLockField());
        if (mapping == null) {
            if (this.isStoredInObject()) {
                if (this.descriptor.getObjectBuilder().getReadOnlyMappingsForField(this.getWriteLockField()) != null) {
                    mapping = this.descriptor.getObjectBuilder().getReadOnlyMappingsForField(this.getWriteLockField()).get(0);
                    session.getIntegrityChecker().handleError(DescriptorException.mappingCanNotBeReadOnly(mapping));
                } else {
                    session.getIntegrityChecker().handleError(OptimisticLockException.mustHaveMappingWhenStoredInObject(this.descriptor.getJavaClass()));
                }
            } else {
                return;
            }
        }
        if (this.isStoredInCache()) {
            session.getIntegrityChecker().handleError(DescriptorException.mustBeReadOnlyMappingWhenStoredInCache(mapping));
        }
        if (mapping.isDirectToFieldMapping() && this.descriptor.getObjectBuilder().getReadOnlyMappingsForField(this.getWriteLockField()) == null) {
            this.lockMapping = (AbstractDirectMapping)mapping;
        }
        if (!this.descriptor.getTables().isEmpty() && !this.getWriteLockField().getTable().equals(this.descriptor.getTables().get(0))) {
            this.descriptor.setHasMultipleTableConstraintDependecy(true);
        }
    }

    @Override
    public void initializeProperties() {
        DatabaseField dbField = this.getWriteLockField();
        dbField = this.descriptor.buildField(dbField);
        this.setWriteLockField(dbField);
        if (this.isStoredInCache() && dbField.getType() == null) {
            dbField.setType(this.getDefaultLockingFieldType());
        }
        for (DatabaseField lockField : this.getUnmappedFields()) {
            this.descriptor.getFields().add(lockField);
        }
    }

    @Override
    public boolean isCascaded() {
        return this.isCascaded;
    }

    @Override
    public boolean isNewerVersion(Object currentValue, Object domainObject, Object primaryKey, AbstractSession session) {
        Number newWriteLockFieldValue = (Number)currentValue;
        Number writeLockFieldValue = this.isStoredInCache() ? (Number)((Number)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(domainObject));
        return this.isNewerVersion(newWriteLockFieldValue, writeLockFieldValue);
    }

    @Override
    public boolean isNewerVersion(AbstractRecord databaseRow, Object domainObject, Object primaryKey, AbstractSession session) {
        Number newWriteLockFieldValue = (Number)databaseRow.get(this.getWriteLockField());
        Number writeLockFieldValue = this.isStoredInCache() ? (Number)((Number)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(domainObject));
        return this.isNewerVersion(newWriteLockFieldValue, writeLockFieldValue);
    }

    public boolean isNewerVersion(Object firstLockFieldValue, Object secondWriteLockFieldValue) {
        Number firstValue = (Number)firstLockFieldValue;
        Number secondValue = (Number)secondWriteLockFieldValue;
        if (firstValue == null) {
            return false;
        }
        if (secondValue == null) {
            return true;
        }
        return firstValue.longValue() > secondValue.longValue();
    }

    @Override
    public boolean isStoredInCache() {
        return this.lockValueStored == 1;
    }

    public boolean isStoredInObject() {
        return this.lockValueStored == 2;
    }

    protected Object lockValueFromObject(Object domainObject) {
        if (this.lockMapping != null) {
            return this.lockMapping.getAttributeValueFromObject(domainObject);
        }
        return this.descriptor.getObjectBuilder().getBaseValueForField(this.writeLockField, domainObject);
    }

    public <T> T getVersion(Object entity) {
        return (T)this.lockValueFromObject(entity);
    }

    public AbstractDirectMapping getVersionMapping() {
        if (this.lockMapping != null) {
            return this.lockMapping;
        }
        return (AbstractDirectMapping)this.descriptor.getObjectBuilder().getBaseMappingForField(this.writeLockField);
    }

    @Override
    public void mergeIntoParentCache(UnitOfWorkImpl uow, Object primaryKey, Object object) {
        if (this.isStoredInCache()) {
            Object parentValue = uow.getParentIdentityMapSession(this.descriptor, false, false).getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, object.getClass(), this.getDescriptor());
            uow.getIdentityMapAccessor().updateWriteLockValue(primaryKey, object.getClass(), parentValue);
        }
    }

    @Override
    public void mergeIntoParentCache(CacheKey unitOfWorkCacheKey, CacheKey parentSessionCacheKey) {
        if (this.isStoredInCache() && unitOfWorkCacheKey != null && parentSessionCacheKey != null) {
            unitOfWorkCacheKey.setWriteLockValue(parentSessionCacheKey.getWriteLockValue());
        }
    }

    @Override
    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setIsStoredInCache(boolean isStoredInCache) {
        if (isStoredInCache) {
            this.storeInCache();
        } else {
            this.storeInObject();
        }
    }

    public void setIsCascaded(boolean isCascaded) {
        this.isCascaded = isCascaded;
    }

    @Override
    public void setupWriteFieldsForInsert(ObjectLevelModifyQuery query) {
        Object lockValue = this.getInitialWriteValue(query.getSession());
        ObjectChangeSet objectChangeSet = query.getObjectChangeSet();
        if (objectChangeSet != null) {
            objectChangeSet.setInitialWriteLockValue(lockValue);
        }
        this.updateWriteLockValueForWrite(query, lockValue);
    }

    protected void updateWriteLockValueForWrite(ObjectLevelModifyQuery query, Object lockValue) {
        query.getModifyRow().put(this.writeLockField, lockValue);
        this.updateObjectWithWriteValue(query, lockValue);
    }

    @Override
    public boolean shouldUpdateVersionOnOwnedMappingChange() {
        return this.lockOnChangeMode == OptimisticLockingPolicy.LockOnChange.OWNING;
    }

    @Override
    public boolean shouldUpdateVersionOnMappingChange() {
        return this.lockOnChangeMode == OptimisticLockingPolicy.LockOnChange.ALL;
    }

    public void updateObjectWithWriteValue(ObjectLevelModifyQuery query, Object lockValue) {
        AbstractSession session = query.getSession();
        Object object = query.getObject();
        ObjectChangeSet objectChangeSet = query.getObjectChangeSet();
        if (objectChangeSet == null && session.isUnitOfWork() && ((UnitOfWorkImpl)session).getUnitOfWorkChangeSet() != null) {
            objectChangeSet = (ObjectChangeSet)((UnitOfWorkImpl)session).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object);
        }
        if (this.lockMapping != null) {
            Object convertedLockValue = this.lockMapping.getObjectValue(lockValue, session);
            if (objectChangeSet != null && (!objectChangeSet.isNew() || query.getDescriptor().shouldUseFullChangeSetsForNewObjects())) {
                Object oldValue = this.lockMapping.getAttributeValueFromObject(object);
                this.lockMapping.setAttributeValueInObject(object, convertedLockValue);
                objectChangeSet.setWriteLockValue(lockValue);
                DirectToFieldChangeRecord changeRecord = new DirectToFieldChangeRecord(objectChangeSet);
                changeRecord.setAttribute(this.lockMapping.getAttributeName());
                changeRecord.setMapping(this.lockMapping);
                changeRecord.setNewValue(convertedLockValue);
                changeRecord.setOldValue(oldValue);
                objectChangeSet.addChange(changeRecord);
            } else {
                this.lockMapping.setAttributeValueInObject(object, convertedLockValue);
            }
        } else {
            ObjectBuilder objectBuilder = this.descriptor.getObjectBuilder();
            AbstractRecord record = objectBuilder.createRecord(1, session);
            record.put(this.writeLockField, lockValue);
            if (objectChangeSet != null) {
                objectChangeSet.setWriteLockValue(lockValue);
            }
            objectBuilder.assignReturnRow(object, session, record, objectChangeSet);
        }
    }

    @Override
    public void setLockOnChangeMode(OptimisticLockingPolicy.LockOnChange lockOnChangeMode) {
        this.lockOnChangeMode = lockOnChangeMode;
    }

    public void setWriteLockField(DatabaseField writeLockField) {
        this.writeLockField = writeLockField;
    }

    public void setWriteLockFieldName(String writeLockFieldName) {
        this.setWriteLockField(new DatabaseField(writeLockFieldName));
    }

    public void storeInCache() {
        this.lockValueStored = 1;
    }

    public void storeInObject() {
        this.lockValueStored = 2;
    }

    @Override
    public void updateRowAndObjectForUpdate(ObjectLevelModifyQuery query, Object domainObject) {
        Object lockValue = this.getNewLockValue(query);
        if (this.isStoredInCache()) {
            query.getSession().getIdentityMapAccessor().updateWriteLockValue(query.getPrimaryKey(), domainObject.getClass(), lockValue);
        }
        this.updateWriteLockValueForWrite(query, lockValue);
    }

    public void writeLockValueIntoRow(ObjectLevelModifyQuery query, Object domainObject) {
        Object lockValue = this.getWriteLockValue(domainObject, query.getPrimaryKey(), query.getSession());
        query.getModifyRow().put(this.writeLockField, lockValue);
        if (this.isStoredInCache()) {
            query.getSession().getIdentityMapAccessor().updateWriteLockValue(query.getPrimaryKey(), domainObject.getClass(), lockValue);
        }
    }

    @Override
    public void validateDelete(int rowCount, Object object, DeleteObjectQuery query) {
        if (rowCount <= 0) {
            Object cacheVersion;
            Object queryVersion;
            Object primaryKey = query.getPrimaryKey();
            AbstractSession session = query.getSession().getParentIdentityMapSession(query, true, true);
            CacheKey cacheKey = session.getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, query.getReferenceClass(), query.getDescriptor(), false);
            if (cacheKey != null && cacheKey.getObject() != null && query.getObjectChangeSet() != null && this.compareWriteLockValues(queryVersion = query.getObjectChangeSet().getInitialWriteLockValue(), cacheVersion = this.getWriteLockValue(cacheKey.getObject(), primaryKey, session)) != 0) {
                cacheKey.setInvalidationState(-1);
            }
            throw OptimisticLockException.objectChangedSinceLastReadWhenDeleting(object, query);
        }
    }

    @Override
    public void validateUpdate(int rowCount, Object object, WriteObjectQuery query) {
        if (rowCount <= 0) {
            Object cacheVersion;
            Object queryVersion;
            Object primaryKey = query.getPrimaryKey();
            AbstractSession session = query.getSession().getParentIdentityMapSession(query, true, true);
            CacheKey cacheKey = session.getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, query.getReferenceClass(), query.getDescriptor(), false);
            if (cacheKey != null && cacheKey.getObject() != null && query.getObjectChangeSet() != null && this.compareWriteLockValues(queryVersion = query.getObjectChangeSet().getInitialWriteLockValue(), cacheVersion = this.getWriteLockValue(cacheKey.getObject(), primaryKey, session)) >= 0) {
                cacheKey.setInvalidationState(-1);
            }
            throw OptimisticLockException.objectChangedSinceLastReadWhenUpdating(object, query);
        }
    }
}

