/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.pipeline;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.netty.NettyHeaderUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.http.channel.values.ContentEncodingValues;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ResponseCompressionHandler {
    private static final TraceComponent tc = Tr.register(ResponseCompressionHandler.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private final HttpChannelConfig config;
    private final HttpResponse response;
    private final HttpHeaders headers;
    private long currentContentLength = -1L;
    private String acceptEncodingHeader;
    private Map<String, Float> acceptableEncodings;
    private final Set<String> unacceptableEncodings;
    private String preferredEncoding;
    private boolean starEncodingParsed = Boolean.FALSE;
    private final long contentLengthMinimum = 2048L;
    static final long serialVersionUID = 772799472192902576L;

    public ResponseCompressionHandler(HttpChannelConfig config, HttpResponse response, String acceptEncodingHeader) {
        Objects.requireNonNull(config);
        this.config = config;
        Objects.requireNonNull(response);
        this.response = response;
        this.headers = response.headers();
        Objects.requireNonNull(acceptEncodingHeader);
        this.acceptEncodingHeader = acceptEncodingHeader;
        this.acceptableEncodings = new HashMap<String, Float>();
        this.unacceptableEncodings = new HashSet<String>();
        this.preferredEncoding = config.getPreferredCompressionAlgorithm();
    }

    public void process() {
        if (this.isAutoCompression()) {
            if ("zlib".equals(this.preferredEncoding)) {
                this.preferredEncoding = "deflate";
            }
            if (!"identity".equals(this.preferredEncoding)) {
                this.headers.set(HttpHeaderKeys.HDR_CONTENT_ENCODING.getName(), (Object)this.preferredEncoding);
                this.headers.remove(HttpHeaderKeys.HDR_CONTENT_LENGTH.getName());
            } else {
                this.headers.remove(HttpHeaderKeys.HDR_CONTENT_ENCODING.getName());
                this.preferredEncoding = null;
            }
        } else {
            this.preferredEncoding = null;
        }
    }

    @ManualTrace
    private boolean isAutoCompression() {
        boolean doCompression = Boolean.FALSE;
        if (this.config.useAutoCompression()) {
            NettyHeaderUtils.setVary(this.headers, HttpHeaderKeys.HDR_ACCEPT_ENCODING.getName());
            this.parseAcceptEncodingHeader();
            if (this.headers.contains(HttpHeaderKeys.HDR_CONTENT_ENCODING.getName()) && !ContentEncodingValues.IDENTITY.getName().equalsIgnoreCase(this.headers.get(HttpHeaderKeys.HDR_CONTENT_ENCODING.toString()))) {
                doCompression = Boolean.FALSE;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Response already contains Content-Encoding: [" + this.headers.get(HttpHeaderKeys.HDR_CONTENT_ENCODING.toString()) + "]"), (Object[])new Object[0]);
                }
            } else if (!this.isCompressionCompliant()) {
                doCompression = Boolean.FALSE;
            } else {
                this.preferredEncoding = this.headers.get(HttpHeaderKeys.HDR_$WSZIP.getName());
                if (Objects.nonNull(this.preferredEncoding)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Header requests compression: [" + this.preferredEncoding + "]"), (Object[])new Object[0]);
                    }
                    this.headers.remove(HttpHeaderKeys.HDR_$WSZIP.getName());
                    if (this.isEncodingSupported(this.preferredEncoding) && this.isCompressionAllowed() && !this.unacceptableEncodings.contains(this.preferredEncoding)) {
                        doCompression = Boolean.TRUE;
                    }
                }
                if (this.config.useAutoCompression() && !doCompression) {
                    String serverPreferredEncoding = this.config.getPreferredCompressionAlgorithm().toLowerCase(Locale.ENGLISH);
                    if (!"none".equalsIgnoreCase(serverPreferredEncoding) && (this.acceptableEncodings.containsKey(serverPreferredEncoding) || this.starEncodingParsed && !this.unacceptableEncodings.contains(serverPreferredEncoding))) {
                        this.preferredEncoding = serverPreferredEncoding;
                        if (this.isEncodingSupported(this.preferredEncoding) && this.isCompressionAllowed()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Setting server preferred encoding", (Object[])new Object[0]);
                            }
                            doCompression = Boolean.TRUE;
                        }
                    }
                    if (!doCompression) {
                        float gZipQV = 0.0f;
                        boolean checkedGZipCompliance = Boolean.FALSE;
                        if (this.acceptableEncodings.containsKey(ContentEncodingValues.GZIP.getName())) {
                            gZipQV = this.acceptableEncodings.get(ContentEncodingValues.GZIP.getName()).floatValue();
                        } else {
                            checkedGZipCompliance = Boolean.TRUE;
                        }
                        for (String encoding : this.acceptableEncodings.keySet()) {
                            if (this.acceptableEncodings.get(encoding).floatValue() == gZipQV && !checkedGZipCompliance) {
                                this.preferredEncoding = ContentEncodingValues.GZIP.getName();
                                checkedGZipCompliance = true;
                                if (this.isEncodingSupported(this.preferredEncoding) && this.isCompressionAllowed()) {
                                    doCompression = Boolean.TRUE;
                                    break;
                                }
                            }
                            this.preferredEncoding = encoding;
                            if (!this.isEncodingSupported(this.preferredEncoding) || !this.isCompressionAllowed()) continue;
                            doCompression = true;
                            break;
                        }
                        if (this.starEncodingParsed) {
                            if (!this.unacceptableEncodings.contains("gzip")) {
                                this.preferredEncoding = ContentEncodingValues.GZIP.getName();
                                doCompression = Boolean.TRUE;
                            } else if (!this.unacceptableEncodings.contains("deflate")) {
                                this.preferredEncoding = ContentEncodingValues.DEFLATE.getName();
                                doCompression = Boolean.TRUE;
                            }
                        }
                    }
                }
            }
            if (!doCompression) {
                this.preferredEncoding = ContentEncodingValues.IDENTITY.getName();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("Outgoing Encoding: [" + this.preferredEncoding + "]"));
        }
        return doCompression;
    }

    @ManualTrace
    private boolean isCompressionAllowed() {
        String method = "isCompressionAllowed";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)method, (Object[])new Object[0]);
        }
        boolean isAllowed = Boolean.FALSE;
        if (Objects.isNull(this.acceptEncodingHeader)) {
            isAllowed = Boolean.TRUE;
        } else if (this.acceptableEncodings.containsKey(this.preferredEncoding)) {
            isAllowed = this.acceptableEncodings.get(this.preferredEncoding).floatValue() > 0.0f;
        } else if (ContentEncodingValues.GZIP.getName().equals(this.preferredEncoding)) {
            if (this.acceptableEncodings.containsKey(ContentEncodingValues.XGZIP.getName())) {
                isAllowed = this.acceptableEncodings.get(ContentEncodingValues.XGZIP.getName()).floatValue() > 0.0f;
            }
        } else {
            isAllowed = ContentEncodingValues.IDENTITY.getName().equals(this.preferredEncoding) ? true : this.starEncodingParsed;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)method, (Object)isAllowed);
        }
        return isAllowed;
    }

    @ManualTrace
    private void parseAcceptEncodingHeader() {
        String method = "parseAcceptEncodingHeader";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)method, (Object[])new Object[0]);
        }
        if (Objects.isNull(this.acceptEncodingHeader)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)method, (Object)("parsing [" + this.acceptEncodingHeader));
            }
            return;
        }
        this.acceptEncodingHeader = NettyHeaderUtils.stripWhiteSpaces(this.acceptEncodingHeader).toLowerCase();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)method, (Object[])new Object[]{"parsing [" + this.acceptEncodingHeader + "]"});
        }
        for (String coding : this.acceptEncodingHeader.split(",")) {
            float qualityValue;
            String[] codingParts;
            block17: {
                if (coding.endsWith(";")) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)method, (Object[])new Object[]{"Encoding token was malformed with semicolon delimiter but no quality value. Skipping [" + coding + "]"});
                    continue;
                }
                codingParts = coding.split(";");
                if (codingParts.length < 1 || codingParts.length > 2) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)method, (Object[])new Object[]{"Encoding token was malformed with multiple semicolon delimeters. Skipping [" + coding + "]"});
                    continue;
                }
                if (codingParts.length == 2) {
                    int indexOfQValue = codingParts[1].indexOf("q=");
                    if (indexOfQValue != 0) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)method, (Object[])new Object[]{"Encoding token was malformed with a bad quality value location. Skipping [" + coding + "]"});
                        continue;
                    }
                    String qualityValueAsString = codingParts[1].substring(indexOfQValue + 2);
                    Matcher matcher = this.config.getCompressionQValueRegex().matcher(qualityValueAsString);
                    if (!matcher.matches()) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Encoding token was malformed with a bad quality value. Must be normalized between 0 and 1 with no more than three digits. Skipping [" + coding + "]"), (Object[])new Object[0]);
                        continue;
                    }
                    try {
                        qualityValue = Float.parseFloat(qualityValueAsString);
                        if (qualityValue < 0.0f) {
                            qualityValue = 0.0f;
                        }
                        break block17;
                    }
                    catch (NumberFormatException numberFormatException) {
                        FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.http.netty.pipeline.ResponseCompressionHandler", (String)"370", (Object)this, (Object[])new Object[0]);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Encoding token was malformed with a malformed quality value number. Skipping [" + coding + "]"), (Object[])new Object[0]);
                        continue;
                    }
                }
                qualityValue = 1.0f;
            }
            String encodingName = codingParts[0];
            if (qualityValue == 0.0f) {
                this.unacceptableEncodings.add(encodingName);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)method, (Object[])new Object[]{"Parsed a non accepted content-encoding: [" + encodingName + "]"});
                continue;
            }
            if ("*".equals(encodingName)) {
                boolean bl = this.starEncodingParsed = qualityValue > 0.0f;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)method, (Object[])new Object[]{"Parsed Wildcard - * with value: " + this.starEncodingParsed});
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)method, (Object[])new Object[]{"Parsed Encoding - name: [" + encodingName + "] value: [" + qualityValue + "]"});
            }
            this.acceptableEncodings.put(encodingName, Float.valueOf(qualityValue));
        }
        this.acceptableEncodings = this.sortAcceptableEncodings(this.acceptableEncodings);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)method);
        }
    }

    private Map<String, Float> sortAcceptableEncodings(Map<String, Float> encodings) {
        Map sortedEncodings = encodings.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        return sortedEncodings;
    }

    private boolean isEncodingSupported(String encoding) {
        boolean result = Boolean.TRUE;
        switch (encoding.toLowerCase()) {
            case "gzip": {
                break;
            }
            case "x-gzip": {
                break;
            }
            case "zlib": {
                break;
            }
            case "deflate": {
                break;
            }
            case "identity": {
                break;
            }
            default: {
                result = Boolean.FALSE;
            }
        }
        return result;
    }

    private long getCurrentContentLength() {
        return this.currentContentLength;
    }

    public void setCurrentContentLength(long length) {
        this.currentContentLength = length;
    }

    private boolean isCompressionCompliant() {
        String method = "isCompressionCompliant";
        boolean isCompliant = Boolean.TRUE;
        CharSequence mimeTypeChars = HttpUtil.getMimeType((HttpMessage)this.response);
        String mimeType = null;
        String mimeTypeWildcard = null;
        if (Objects.nonNull(mimeTypeChars)) {
            mimeType = mimeTypeChars.toString();
            mimeTypeWildcard = mimeType.split("/")[0] + "/" + "*";
        }
        if (this.getCurrentContentLength() >= 0L && this.getCurrentContentLength() < this.contentLengthMinimum) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)method, (Object[])new Object[]{"Response content length is less than 2048 bytes, do not attempt to compress"});
            }
            isCompliant = Boolean.FALSE;
        } else if (Objects.isNull(mimeTypeChars)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)method, (Object[])new Object[]{"No content type defined for this response, do not attempt to compress"});
            }
            isCompliant = Boolean.FALSE;
        } else if (this.config.getExcludedCompressionContentTypes().contains(mimeType) || this.config.getExcludedCompressionContentTypes().contains(mimeTypeWildcard)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)method, (Object[])new Object[]{"The Content-Type: " + mimeType + " is not configured as a compressable content type"});
            }
            isCompliant = Boolean.FALSE;
        } else if (!this.config.getCompressionContentTypes().contains(mimeType) && !this.config.getCompressionContentTypes().contains(mimeTypeWildcard)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)method, (Object[])new Object[]{"The Content-Type: " + mimeType + "is not configured as a compressable content type"});
            }
            isCompliant = Boolean.FALSE;
        }
        return isCompliant;
    }

    public String getEncoding() {
        return this.preferredEncoding;
    }
}

