/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorization.jacc.ejb.impl;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ejbcontainer.security.jacc.EJBJaccService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.jacc.JaccService;
import com.ibm.ws.security.authorization.jacc.MethodInfo;
import com.ibm.ws.security.authorization.jacc.RoleInfo;
import com.ibm.ws.security.authorization.jacc.common.PolicyContextHandlerImpl;
import com.ibm.ws.security.authorization.jacc.common.PolicyProxy;
import com.ibm.ws.security.authorization.jacc.ejb.EJBSecurityPropagator;
import com.ibm.ws.security.authorization.jacc.ejb.impl.EJBSecurityPropagatorImpl;
import com.ibm.ws.security.authorization.jacc.ejb.impl.JaccUtil;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ejb.EnterpriseBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import javax.xml.rpc.handler.MessageContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={EJBJaccService.class}, name="com.ibm.ws.security.authorization.jacc.ejb.service", configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class EJBJaccServiceImpl
implements EJBJaccService {
    private static final String JACC_EJB_METHOD_ARGUMENT = "RequestMethodArgumentsRequired";
    private static final TraceComponent tc = Tr.register(EJBJaccServiceImpl.class, (String)"Security.Authorization", (String)"com.ibm.ws.security.authorization.jacc.ejb.resources.JaccEjbAuthorizationMessages");
    private static PolicyContextHandlerImpl pch = PolicyContextHandlerImpl.getInstance();
    protected static final String KEY_JACC_SERVICE = "jaccService";
    private static final HandlerProcessor handlerProcessor;
    private static boolean isEENineOrHigher;
    private final EJBSecurityPropagator esp = new EJBSecurityPropagatorImpl();
    private final AtomicServiceReference<JaccService> jaccServiceRef = new AtomicServiceReference("jaccService");
    static final long serialVersionUID = 7314620041040560334L;

    @Reference(service=JaccService.class, policy=ReferencePolicy.DYNAMIC, name="jaccService")
    protected void setJaccService(ServiceReference<JaccService> reference) {
        this.jaccServiceRef.setReference(reference);
    }

    protected void unsetJaccService(ServiceReference<JaccService> reference) {
        this.jaccServiceRef.unsetReference(reference);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.jaccServiceRef.activate(cc);
        JaccService jaccService = (JaccService)this.jaccServiceRef.getService();
        if (jaccService != null) {
            jaccService.getPolicyConfigurationManager().setEJBSecurityPropagator(this.esp);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.jaccServiceRef.deactivate(cc);
    }

    public void propagateEJBRoles(BeanMetaData bmd) {
        this.propagateEJBRoles(this.esp, bmd.j2eeName.getApplication(), bmd.j2eeName.getModule(), bmd.enterpriseBeanName, bmd.ivRoleLinkMap, JaccUtil.convertMethodInfoList(JaccUtil.mergeMethodInfos(bmd)));
    }

    protected void propagateEJBRoles(EJBSecurityPropagator esp, String applicationName, String moduleName, String beanName, Map<String, String> roleLinkMap, Map<RoleInfo, List<MethodInfo>> methodMap) {
        JaccService jaccService = (JaccService)this.jaccServiceRef.getService();
        if (jaccService != null) {
            esp.propagateEJBRoles(jaccService.getContextId(applicationName, moduleName), applicationName, beanName, roleLinkMap, methodMap, jaccService.getPolicyConfigurationManager());
        }
    }

    public boolean isAuthorized(String applicationName, String moduleName, String beanName, String methodName, String methodInterface, String methodSignature, List<Object> methodParameters, EnterpriseBean bean, Subject subject) {
        JaccService jaccService = (JaccService)this.jaccServiceRef.getService();
        if (jaccService != null) {
            String[] methodSignatureArray = this.convertMethodSignature(methodSignature);
            EJBMethodPermission ejbPerm = new EJBMethodPermission(beanName, methodName, methodInterface, methodSignatureArray);
            return this.checkResourceConstraints(jaccService.getContextId(applicationName, moduleName), methodParameters, bean, (Permission)ejbPerm, subject, jaccService.getPolicyProxy());
        }
        return false;
    }

    public boolean isSubjectInRole(String applicationName, String moduleName, String beanName, String methodName, List<Object> methodParameters, String role, EnterpriseBean bean, Subject subject) {
        JaccService jaccService = (JaccService)this.jaccServiceRef.getService();
        if (jaccService != null) {
            EJBRoleRefPermission ejbPerm = new EJBRoleRefPermission(beanName, role);
            return this.checkResourceConstraints(jaccService.getContextId(applicationName, moduleName), methodParameters, bean, (Permission)ejbPerm, subject, jaccService.getPolicyProxy());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkResourceConstraints(String contextId, List<Object> methodParameters, EnterpriseBean bean, Permission ejbPerm, Subject subject, PolicyProxy policyProxy) {
        boolean result = false;
        Object[] ma = null;
        if (methodParameters != null && methodParameters.size() > 0) {
            ma = methodParameters.toArray(new Object[methodParameters.size()]);
        }
        try {
            result = this.checkMethodConstraints(contextId, ma, bean, ejbPerm, subject, policyProxy);
        }
        catch (PrivilegedActionException privilegedActionException) {
            void pae;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.authorization.jacc.ejb.impl.EJBJaccServiceImpl", (String)"218", (Object)this, (Object[])new Object[]{contextId, methodParameters, bean, ejbPerm, subject, policyProxy});
            Tr.error((TraceComponent)tc, (String)"JACC_EJB_IMPLIES_FAILURE", (Object[])new Object[]{contextId, pae.getException()});
        }
        return result;
    }

    private boolean checkMethodConstraints(final String contextId, final Object[] methodParameters, final EnterpriseBean bean, final Permission permission, final Subject subject, final PolicyProxy policyProxy) throws PrivilegedActionException {
        Boolean result = Boolean.FALSE;
        result = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
            static final long serialVersionUID = 569155807671080329L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public Boolean run() throws PolicyContextException {
                Object mc;
                block5: {
                    PolicyContext.setContextID((String)contextId);
                    mc = null;
                    if (!isEENineOrHigher) {
                        try {
                            InitialContext ic = new InitialContext();
                            mc = EJBJaccServiceImpl.this.getMessageContext(ic);
                        }
                        catch (NamingException ic) {
                            void e;
                            FFDCFilter.processException((Throwable)ic, (String)"com.ibm.ws.security.authorization.jacc.ejb.impl.EJBJaccServiceImpl$1", (String)"245", (Object)this, (Object[])new Object[0]);
                            if (!tc.isDebugEnabled()) break block5;
                            Tr.debug((TraceComponent)tc, (String)"NamingException is caught. Ignoring.", (Object[])new Object[]{e});
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Registering JACC context handlers and setting JACC handler data", (Object[])new Object[0]);
                }
                handlerProcessor.setPolicyContextData(subject, bean, methodParameters, mc, policyProxy);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Calling JACC implies. subject : " + subject), (Object[])new Object[0]);
                }
                return policyProxy.implies(contextId, subject, permission);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authorization.jacc.ejb.impl.EJBJaccServiceImpl$1", 1.class, (String)"Security.Authorization", (String)"com.ibm.ws.security.authorization.jacc.ejb.resources.JaccEjbAuthorizationMessages");
            }
        });
        return result;
    }

    @FFDCIgnore(value={NamingException.class, IllegalStateException.class})
    Object getMessageContext(Context c) {
        MessageContext mc;
        block5: {
            mc = null;
            try {
                SessionContext sc = (SessionContext)c.lookup("java:comp/EJBContext");
                if (sc != null) {
                    mc = sc.getMessageContext();
                }
            }
            catch (NamingException ne) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"NamingException is caught. Safe to ignore.", (Object[])new Object[]{ne});
                }
            }
            catch (IllegalStateException ise) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"IllegalStateException is caught. Safe to ignore.", (Object[])new Object[]{ise});
            }
        }
        return mc;
    }

    public boolean areRequestMethodArgumentsRequired() {
        JaccService jaccService = (JaccService)this.jaccServiceRef.getService();
        if (jaccService != null) {
            String value = jaccService.getProviderServiceProperty(JACC_EJB_METHOD_ARGUMENT);
            return "true".equalsIgnoreCase(value);
        }
        return false;
    }

    public void resetPolicyContextHandlerInfo() {
        JaccService jaccService = (JaccService)this.jaccServiceRef.getService();
        if (jaccService != null) {
            jaccService.resetPolicyContextHandlerInfo();
        }
    }

    private String[] convertMethodSignature(String methodSignature) {
        String s;
        int index;
        ArrayList<String> methodSignatureList = new ArrayList<String>();
        if (methodSignature != null && methodSignature.length() > 0 && (index = methodSignature.indexOf(":")) != -1 && (s = methodSignature.substring(index + 1)) != null && s.length() > 0) {
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                methodSignatureList.add(st.nextToken());
            }
        }
        return methodSignatureList.toArray(new String[methodSignatureList.size()]);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        if (PolicyContext.class.getName().startsWith("javax")) {
            handlerProcessor = HandlerProcessor.JACC15;
        } else {
            boolean principalMapperSupported = false;
            try {
                principalMapperSupported = pch.supports("jakarta.security.jacc.PrincipalMapper");
            }
            catch (PolicyContextException policyContextException) {
                FFDCFilter.processException((Throwable)policyContextException, (String)"com.ibm.ws.security.authorization.jacc.ejb.impl.EJBJaccServiceImpl", (String)"121", null, (Object[])new Object[0]);
            }
            handlerProcessor = principalMapperSupported ? HandlerProcessor.AUTHORIZATION30 : HandlerProcessor.AUTHORIZATION20_21;
        }
        isEENineOrHigher = SessionContext.class.getCanonicalName().startsWith("jakarta.ejb");
    }

    static enum HandlerProcessor {
        JACC15(true, false),
        AUTHORIZATION20_21(false, false),
        AUTHORIZATION30(false, true);

        final boolean principalMapperSupported;
        final boolean javaxSupported;

        private HandlerProcessor(boolean javaxSupported, boolean principalMapperSupported) {
            this.principalMapperSupported = principalMapperSupported;
            this.javaxSupported = javaxSupported;
        }

        void setPolicyContextData(Subject subject, EnterpriseBean bean, Object[] methodParameters, Object messageContext, PolicyProxy policyProxy) throws PolicyContextException {
            HashMap<String, Object> handlerObjects = new HashMap<String, Object>();
            PolicyContext.registerHandler((String)"javax.security.auth.Subject.container", (PolicyContextHandler)pch, (boolean)true);
            handlerObjects.put("javax.security.auth.Subject.container", subject);
            if (this.principalMapperSupported) {
                PolicyContext.registerHandler((String)"jakarta.security.jacc.PrincipalMapper", (PolicyContextHandler)pch, (boolean)true);
                handlerObjects.put("jakarta.security.jacc.PrincipalMapper", policyProxy.getPrincipalMapper());
            } else {
                PolicyContext.registerHandler((String)"javax.ejb.arguments", (PolicyContextHandler)pch, (boolean)true);
                handlerObjects.put("javax.ejb.arguments", methodParameters);
            }
            if (this.javaxSupported) {
                PolicyContext.registerHandler((String)"javax.ejb.EnterpriseBean", (PolicyContextHandler)pch, (boolean)true);
                PolicyContext.registerHandler((String)"javax.xml.soap.SOAPMessage", (PolicyContextHandler)pch, (boolean)true);
                handlerObjects.put("javax.ejb.EnterpriseBean", bean);
                if (messageContext != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"javax.xml.soap.SOAPMessage is set: ", (Object[])new Object[]{messageContext});
                    }
                    handlerObjects.put("javax.xml.soap.SOAPMessage", messageContext);
                }
            }
            PolicyContext.registerHandler((String)"jakarta.ejb.EnterpriseBean", (PolicyContextHandler)pch, (boolean)true);
            PolicyContext.registerHandler((String)"jakarta.ejb.arguments", (PolicyContextHandler)pch, (boolean)true);
            PolicyContext.registerHandler((String)"jakarta.xml.soap.SOAPMessage", (PolicyContextHandler)pch, (boolean)true);
            handlerObjects.put("jakarta.ejb.EnterpriseBean", bean);
            handlerObjects.put("jakarta.ejb.arguments", methodParameters);
            PolicyContext.setHandlerData(handlerObjects);
        }
    }
}

