/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection.jdk8;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class IndirectMap<K, V>
extends org.eclipse.persistence.indirection.IndirectMap<K, V> {
    public IndirectMap() {
    }

    public IndirectMap(int initialCapacity) {
        super(initialCapacity);
    }

    public IndirectMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public IndirectMap(Map<? extends K, ? extends V> m) {
        super(m);
    }

    @Override
    public synchronized V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        if (this.hasTrackedPropertyChangeListener()) {
            V newValue;
            Object oldValue = this.get(key);
            V v = newValue = oldValue == null ? value : remappingFunction.apply(oldValue, value);
            if (newValue == null) {
                this.remove(key);
            } else {
                this.put(key, newValue);
            }
            return newValue;
        }
        return this.getDelegate().merge(key, value, remappingFunction);
    }

    @Override
    public synchronized V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (this.hasTrackedPropertyChangeListener()) {
            Object oldValue = this.get(key);
            V newValue = remappingFunction.apply(key, oldValue);
            if (oldValue != null) {
                if (newValue != null) {
                    this.put(key, newValue);
                    return newValue;
                }
                this.remove(key);
            } else if (newValue != null) {
                this.put(key, newValue);
                return newValue;
            }
            return null;
        }
        return this.getDelegate().compute(key, remappingFunction);
    }

    @Override
    public synchronized V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (this.hasTrackedPropertyChangeListener()) {
            if (this.get(key) != null) {
                Object oldValue = this.get(key);
                V newValue = remappingFunction.apply(key, oldValue);
                if (newValue != null) {
                    this.put(key, newValue);
                    return newValue;
                }
                this.remove(key);
            }
            return null;
        }
        return this.getDelegate().computeIfPresent(key, remappingFunction);
    }

    @Override
    public synchronized V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        if (this.hasTrackedPropertyChangeListener()) {
            Object oldValue = this.get(key);
            if (oldValue == null) {
                V newValue = mappingFunction.apply(key);
                if (newValue != null) {
                    this.put(key, newValue);
                }
                return newValue;
            }
            return oldValue;
        }
        return this.getDelegate().computeIfAbsent(key, mappingFunction);
    }

    @Override
    public synchronized V replace(K key, V value) {
        if (this.hasTrackedPropertyChangeListener()) {
            Hashtable del = this.getDelegate();
            if (del.containsKey(key)) {
                return this.put(key, value);
            }
            return null;
        }
        return this.getDelegate().replace(key, value);
    }

    @Override
    public synchronized boolean replace(K key, V oldValue, V newValue) {
        if (this.hasTrackedPropertyChangeListener()) {
            Hashtable del = this.getDelegate();
            if (del.containsKey(key) && Objects.equals(del.get(key), oldValue)) {
                this.put(key, newValue);
                return true;
            }
            return false;
        }
        return this.getDelegate().replace(key, oldValue, newValue);
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        if (this.hasTrackedPropertyChangeListener()) {
            Hashtable del = this.getDelegate();
            if (del.containsKey(key) && Objects.equals(del.get(key), value)) {
                del.remove(key);
                this.raiseRemoveChangeEvent(key, value);
                return true;
            }
            return false;
        }
        return this.getDelegate().remove(key, value);
    }

    @Override
    public synchronized V putIfAbsent(K key, V value) {
        if (this.hasTrackedPropertyChangeListener()) {
            Object current = this.getDelegate().get(key);
            if (current == null) {
                Object v = this.getDelegate().put(key, value);
                this.raiseAddChangeEvent(key, value);
                return v;
            }
            return current;
        }
        return this.getDelegate().putIfAbsent(key, value);
    }

    @Override
    public synchronized void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        if (this.hasTrackedPropertyChangeListener()) {
            this.getDelegate().entrySet().stream().forEach((? super T entry) -> {
                K key = entry.getKey();
                V oldValue = entry.getValue();
                entry.setValue(function.apply((K)key, (V)entry.getValue()));
                this.raiseRemoveChangeEvent(key, oldValue);
                this.raiseAddChangeEvent(key, entry.getValue());
            });
            return;
        }
        this.getDelegate().replaceAll(function);
    }

    @Override
    public synchronized void forEach(BiConsumer<? super K, ? super V> action) {
        this.getDelegate().forEach(action);
    }

    @Override
    public synchronized V getOrDefault(Object key, V defaultValue) {
        return this.getDelegate().getOrDefault(key, defaultValue);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new Set<Map.Entry<K, V>>(){
            Set<Map.Entry<K, V>> delegateSet;
            {
                this.delegateSet = IndirectMap.this.getDelegate().entrySet();
            }

            @Override
            public int size() {
                return this.delegateSet.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegateSet.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return this.delegateSet.contains(o);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<Map.Entry<K, V>> delegateIterator;
                    Map.Entry<K, V> currentObject;
                    {
                        this.delegateIterator = delegateSet.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    @Override
                    public void remove() {
                        this.delegateIterator.remove();
                        if (this.currentObject != null) {
                            IndirectMap.this.raiseRemoveChangeEvent(this.currentObject.getKey(), this.currentObject.getValue());
                        }
                    }

                    @Override
                    public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
                        this.delegateIterator.forEachRemaining(action);
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return this.delegateSet.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return this.delegateSet.toArray(a);
            }

            @Override
            public boolean add(Map.Entry<K, V> o) {
                return this.delegateSet.add(o);
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                return IndirectMap.this.remove(((Map.Entry)o).getKey()) != null;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return this.delegateSet.containsAll(c);
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
                return this.delegateSet.addAll(c);
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                boolean result = false;
                Iterator objects = this.delegateSet.iterator();
                while (objects.hasNext()) {
                    Map.Entry object = objects.next();
                    if (c.contains(object)) continue;
                    objects.remove();
                    IndirectMap.this.raiseRemoveChangeEvent(object.getKey(), object.getValue());
                    result = true;
                }
                return result;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                boolean result = false;
                for (Object object : c) {
                    Object removed;
                    if (!(object instanceof Map.Entry) || (removed = IndirectMap.this.remove(((Map.Entry)object).getKey())) == null) continue;
                    result = true;
                }
                return result;
            }

            @Override
            public void clear() {
                IndirectMap.this.clear();
            }

            @Override
            public boolean equals(Object o) {
                return this.delegateSet.equals(o);
            }

            @Override
            public int hashCode() {
                return this.delegateSet.hashCode();
            }

            @Override
            public boolean removeIf(Predicate<? super Map.Entry<K, V>> filter) {
                boolean hasChanged = false;
                Iterator objects = this.iterator();
                while (objects.hasNext()) {
                    if (!filter.test(objects.next())) continue;
                    objects.remove();
                    hasChanged |= true;
                }
                return hasChanged;
            }

            @Override
            public Stream<Map.Entry<K, V>> stream() {
                return this.delegateSet.stream();
            }

            @Override
            public Stream<Map.Entry<K, V>> parallelStream() {
                return this.delegateSet.parallelStream();
            }

            @Override
            public void forEach(Consumer<? super Map.Entry<K, V>> action) {
                this.delegateSet.forEach(action);
            }

            @Override
            public Spliterator<Map.Entry<K, V>> spliterator() {
                return this.delegateSet.spliterator();
            }
        };
    }

    @Override
    public Set<K> keySet() {
        return new Set<K>(){
            Set<K> delegateSet;
            {
                this.delegateSet = IndirectMap.this.getDelegate().keySet();
            }

            @Override
            public int size() {
                return this.delegateSet.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegateSet.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return this.delegateSet.contains(o);
            }

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    Iterator<K> delegateIterator;
                    K currentObject;
                    {
                        this.delegateIterator = delegateSet.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    @Override
                    public K next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    @Override
                    public void remove() {
                        IndirectMap.this.raiseRemoveChangeEvent(this.currentObject, IndirectMap.this.getDelegate().get(this.currentObject));
                        this.delegateIterator.remove();
                    }

                    @Override
                    public void forEachRemaining(Consumer<? super K> action) {
                        this.delegateIterator.forEachRemaining(action);
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return this.delegateSet.toArray();
            }

            @Override
            public Object[] toArray(Object[] a) {
                return this.delegateSet.toArray(a);
            }

            @Override
            public boolean add(K o) {
                return this.delegateSet.add(o);
            }

            @Override
            public boolean remove(Object o) {
                return IndirectMap.this.remove(o) != null;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return this.delegateSet.containsAll(c);
            }

            @Override
            public boolean addAll(Collection<? extends K> c) {
                return this.delegateSet.addAll(c);
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                boolean result = false;
                Iterator objects = this.delegateSet.iterator();
                while (objects.hasNext()) {
                    Object object = objects.next();
                    if (c.contains(object)) continue;
                    objects.remove();
                    IndirectMap.this.raiseRemoveChangeEvent(object, IndirectMap.this.getDelegate().get(object));
                    result = true;
                }
                return result;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                boolean result = false;
                Iterator<?> cs = c.iterator();
                while (cs.hasNext()) {
                    if (IndirectMap.this.remove(cs.next()) == null) continue;
                    result = true;
                }
                return result;
            }

            @Override
            public void clear() {
                IndirectMap.this.clear();
            }

            @Override
            public boolean equals(Object o) {
                return this.delegateSet.equals(o);
            }

            @Override
            public int hashCode() {
                return this.delegateSet.hashCode();
            }

            @Override
            public boolean removeIf(Predicate<? super K> filter) {
                boolean hasChanged = false;
                Iterator objects = this.iterator();
                while (objects.hasNext()) {
                    if (!filter.test(objects.next())) continue;
                    objects.remove();
                    hasChanged |= true;
                }
                return hasChanged;
            }

            @Override
            public Stream<K> stream() {
                return this.delegateSet.stream();
            }

            @Override
            public Stream<K> parallelStream() {
                return this.delegateSet.parallelStream();
            }

            @Override
            public void forEach(Consumer<? super K> action) {
                this.delegateSet.forEach(action);
            }

            @Override
            public Spliterator<K> spliterator() {
                return this.delegateSet.spliterator();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new Collection<V>(){
            protected Collection<V> delegateCollection;
            {
                this.delegateCollection = IndirectMap.this.getDelegate().values();
            }

            @Override
            public int size() {
                return this.delegateCollection.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegateCollection.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return this.delegateCollection.contains(o);
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    Iterator<V> delegateIterator;
                    V currentObject;
                    {
                        this.delegateIterator = delegateCollection.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    @Override
                    public V next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    @Override
                    public void remove() {
                        for (Map.Entry entry : IndirectMap.this.getDelegate().entrySet()) {
                            if (!entry.getValue().equals(this.currentObject)) continue;
                            IndirectMap.this.raiseRemoveChangeEvent(entry.getKey(), entry.getValue());
                        }
                        this.delegateIterator.remove();
                    }

                    @Override
                    public void forEachRemaining(Consumer<? super V> action) {
                        this.delegateIterator.forEachRemaining(action);
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return this.delegateCollection.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return this.delegateCollection.toArray(a);
            }

            @Override
            public boolean add(V o) {
                return this.delegateCollection.add(o);
            }

            @Override
            public boolean remove(Object o) {
                Iterator entryIt = IndirectMap.this.getDelegate().entrySet().iterator();
                while (entryIt.hasNext()) {
                    Map.Entry entry = entryIt.next();
                    if (!entry.getValue().equals(o)) continue;
                    IndirectMap.this.raiseRemoveChangeEvent(entry.getKey(), entry.getValue());
                    entryIt.remove();
                    return true;
                }
                return false;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return this.delegateCollection.containsAll(c);
            }

            @Override
            public boolean addAll(Collection<? extends V> c) {
                return this.delegateCollection.addAll(c);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                boolean result = false;
                Iterator<?> iterator = c.iterator();
                while (iterator.hasNext()) {
                    if (!this.remove(iterator.next())) continue;
                    result = true;
                }
                return result;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                boolean result = false;
                Iterator iterator = IndirectMap.this.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (c.contains(entry.getValue())) continue;
                    iterator.remove();
                    result = true;
                }
                return result;
            }

            @Override
            public void clear() {
                IndirectMap.this.clear();
            }

            @Override
            public boolean equals(Object o) {
                return this.delegateCollection.equals(o);
            }

            @Override
            public int hashCode() {
                return this.delegateCollection.hashCode();
            }

            @Override
            public void forEach(Consumer<? super V> action) {
                this.delegateCollection.forEach(action);
            }

            @Override
            public boolean removeIf(Predicate<? super V> filter) {
                boolean hasChanged = false;
                Iterator objects = this.iterator();
                while (objects.hasNext()) {
                    if (!filter.test(objects.next())) continue;
                    objects.remove();
                    hasChanged |= true;
                }
                return hasChanged;
            }

            @Override
            public Spliterator<V> spliterator() {
                return this.delegateCollection.spliterator();
            }

            @Override
            public Stream<V> stream() {
                return this.delegateCollection.stream();
            }

            @Override
            public Stream<V> parallelStream() {
                return this.delegateCollection.parallelStream();
            }
        };
    }
}

