/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;

public class ClassTypeExpression
extends DataExpression {
    protected DatabaseField field;
    protected DatabaseField aliasedField;

    public ClassTypeExpression(Expression base) {
        this.baseExpression = base;
    }

    public ClassTypeExpression() {
    }

    @Override
    public String descriptionOfNodeType() {
        return "Class For Inheritance";
    }

    @Override
    public Expression rebuildOn(Expression newBase) {
        Expression newLocalBase = this.getBaseExpression().rebuildOn(newBase);
        Expression result = newLocalBase.type();
        result.setSelectIfOrderedBy(this.selectIfOrderedBy());
        return result;
    }

    public Object typeValueFromObject(Object object, AbstractSession session) {
        ClassDescriptor objectDescriptor = session.getClassDescriptor(object);
        if (!objectDescriptor.hasInheritance() || objectDescriptor.getInheritancePolicy().shouldUseClassNameAsIndicator() || objectDescriptor.getInheritancePolicy().hasClassExtractor()) {
            return objectDescriptor.getJavaClassName();
        }
        return objectDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(objectDescriptor.getJavaClass());
    }

    @Override
    public void validateNode() {
        ClassDescriptor descriptor = this.getContainingDescriptor();
        if (descriptor == null) {
            throw QueryException.invalidTypeExpression(this.getBaseExpression());
        }
        if (!descriptor.hasInheritance() || !descriptor.getInheritancePolicy().hasClassIndicator()) {
            throw QueryException.invalidTypeExpression(descriptor.getJavaClassName());
        }
        super.validateNode();
    }

    @Override
    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        if (!this.getBaseExpression().isExpressionBuilder() && this.getBaseExpression().isQueryKeyExpression()) {
            object = this.getBaseExpression().valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
            if (object == null) {
                return null;
            }
            if (object instanceof Vector) {
                Vector<Object> comparisonVector = new Vector<Object>(((Vector)object).size() + 2);
                Enumeration valuesToIterate = ((Vector)object).elements();
                while (valuesToIterate.hasMoreElements()) {
                    Object vectorObject = valuesToIterate.nextElement();
                    if (vectorObject == null) {
                        comparisonVector.addElement(vectorObject);
                        continue;
                    }
                    Object valueOrValues = this.typeValueFromObject(vectorObject, session);
                    if (valueOrValues instanceof Vector) {
                        Enumeration nestedValuesToIterate = ((Vector)valueOrValues).elements();
                        while (nestedValuesToIterate.hasMoreElements()) {
                            comparisonVector.addElement(nestedValuesToIterate.nextElement());
                        }
                        continue;
                    }
                    comparisonVector.addElement(valueOrValues);
                }
                return comparisonVector;
            }
        }
        return this.typeValueFromObject(object, session);
    }

    @Override
    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write("TYPE");
        writer.write(this.tableAliasesDescription());
    }

    @Override
    public DatabaseField getField() {
        if (this.field == null) {
            ClassDescriptor descriptor = this.getContainingDescriptor();
            if (!descriptor.hasInheritance() || descriptor.getInheritancePolicy().hasClassExtractor()) {
                throw QueryException.invalidTypeExpression(descriptor.getJavaClassName());
            }
            this.field = descriptor.getInheritancePolicy().getClassIndicatorField();
        }
        return this.field;
    }

    @Override
    public Object getFieldValue(Object objectValue, AbstractSession session) {
        if (objectValue == null) {
            return null;
        }
        if (objectValue instanceof Collection) {
            Collection values = (Collection)objectValue;
            Vector fieldValues = new Vector(values.size());
            for (Object value : values) {
                if (!(value instanceof Expression)) {
                    value = this.getFieldValue(value, session);
                }
                fieldValues.add(value);
            }
            return fieldValues;
        }
        if (!(objectValue instanceof Class)) {
            throw QueryException.invalidTypeExpression(objectValue.getClass().toString());
        }
        ClassDescriptor descriptor = session.getDescriptor((Class)objectValue);
        if (descriptor == null) {
            throw QueryException.invalidTypeExpression(objectValue.getClass().toString());
        }
        if (descriptor.hasInheritance() && !descriptor.getInheritancePolicy().shouldUseClassNameAsIndicator()) {
            return descriptor.getInheritancePolicy().getClassIndicatorMapping().get(objectValue);
        }
        return ((Class)objectValue).getName();
    }

    @Override
    public ClassDescriptor getContainingDescriptor() {
        return ((ObjectExpression)this.getBaseExpression()).getDescriptor();
    }

    public ClassDescriptor getContainingDescriptor(ObjectLevelReadQuery query) {
        Class queryClass = null;
        if (this.getBaseExpression().isExpressionBuilder()) {
            queryClass = ((ExpressionBuilder)this.getBaseExpression()).getQueryClass();
            return query.getSession().getDescriptor(queryClass);
        }
        return this.getBaseExpression().getLeafDescriptor(query, query.getDescriptor(), query.getSession());
    }

    @Override
    public boolean isClassTypeExpression() {
        return true;
    }

    @Override
    public boolean isAttribute() {
        return true;
    }

    public Expression normalize(ExpressionNormalizer normalizer, Vector foreignKeyJoinPointer) {
        if (this.hasBeenNormalized()) {
            return this;
        }
        return super.normalize(normalizer);
    }

    protected void initializeAliasedField() {
        DatabaseField tempField = this.getField().clone();
        DatabaseTable aliasedTable = this.getAliasedTable();
        this.aliasedField = tempField;
        this.aliasedField.setTable(aliasedTable);
    }

    @Override
    public DatabaseField getAliasedField() {
        if (this.aliasedField == null) {
            this.initializeAliasedField();
        }
        return this.aliasedField;
    }

    protected DatabaseTable getAliasedTable() {
        DataExpression base = (DataExpression)this.getBaseExpression();
        DatabaseTable alias = base.aliasForTable(this.getField().getTable());
        if (alias == null) {
            return this.getField().getTable();
        }
        return alias;
    }

    @Override
    public Vector getFields() {
        Vector<DatabaseField> result = new Vector<DatabaseField>(1);
        DatabaseField field = this.getField();
        if (field != null) {
            result.addElement(field);
        }
        return result;
    }

    @Override
    public Expression twistedForBaseAndContext(Expression newBase, Expression context, Expression oldBase) {
        if (oldBase == null || this.baseExpression == oldBase) {
            Expression twistedBase = this.baseExpression.twistedForBaseAndContext(newBase, context, oldBase);
            return twistedBase.type();
        }
        return this;
    }
}

