/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils;

import com.ibm.ejs.ras.Traceable;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.sib.utils.SIBUuid12;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class Password
implements Traceable,
FFDCSelfIntrospectable,
Serializable {
    private static final long serialVersionUID = 20090820150226L;
    private static final byte[] SALT = new SIBUuid12().toByteArray();
    public static final Password NULL_PASSWORD = new Password((char[])null);
    public static final Password EMPTY_PASSWORD = new Password(new char[0]);
    private final char[] _password;
    private String _traceableString = null;

    @Deprecated
    public Password(String password) {
        this._password = (char[])(password != null ? password.toCharArray() : null);
    }

    public Password(char[] password) {
        if (password != null) {
            if (password.length != 0) {
                this._password = new char[password.length];
                System.arraycopy(password, 0, this._password, 0, password.length);
            } else {
                this._password = password;
            }
        } else {
            this._password = null;
        }
    }

    @Deprecated
    public String getPassword() {
        if (this._password != null) {
            return new String(this._password);
        }
        return null;
    }

    public char[] getPasswordChars() {
        if (this._password != null) {
            if (this._password.length != 0) {
                char[] result = new char[this._password.length];
                System.arraycopy(this._password, 0, result, 0, this._password.length);
                return result;
            }
            return this._password;
        }
        return null;
    }

    public String toString() {
        if (this._password != null) {
            return "*****";
        }
        return "null";
    }

    public String toTraceString() {
        if (this._traceableString == null) {
            if (this._password != null) {
                try {
                    MessageDigest digester = MessageDigest.getInstance("SHA-256");
                    digester.update(SALT);
                    for (char c : this._password) {
                        digester.update((byte)((c & 0xFF00) >> 8));
                        digester.update((byte)(c & 0xFF));
                    }
                    byte[] hash = digester.digest();
                    StringBuilder sb = new StringBuilder();
                    for (byte b : hash) {
                        int i = b & 0xF;
                        sb.append(Integer.toHexString(i));
                    }
                    this._traceableString = sb.toString();
                }
                catch (NoSuchAlgorithmException nsae) {
                    this._traceableString = this.toString();
                }
            } else {
                this._traceableString = "";
            }
        }
        return this._traceableString;
    }

    public String[] introspectSelf() {
        return new String[]{"_password = " + this.toString(), "_traceablePassword = " + this.toTraceString()};
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Password) {
            Password other = (Password)o;
            return Arrays.equals(this._password, other._password);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this._password);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        throw new IOException();
    }

    private void readObject(ObjectInputStream s) throws IOException {
        throw new IOException();
    }
}

