/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.io.Serializable;
import java.time.Instant;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.sessions.Session;

public class SessionLogEntry
implements Serializable {
    protected transient Session session;
    protected transient Thread thread;
    protected transient Accessor connection;
    protected String message;
    protected Throwable throwable;
    protected int level;
    protected String nameSpace;
    protected Object[] parameters;
    protected boolean shouldTranslate;
    protected String sourceClassName;
    protected String sourceMethodName;
    private Instant timeStamp = Instant.now();

    public SessionLogEntry(Session session) {
        this.thread = Thread.currentThread();
        this.session = session;
        this.message = "";
        this.level = 5;
    }

    public SessionLogEntry(Session session, Throwable throwable) {
        this(session);
        this.throwable = throwable;
        this.level = 7;
    }

    public SessionLogEntry(Session session, String message) {
        this(session);
        this.message = message;
    }

    public SessionLogEntry(Session session, String message, Accessor connection) {
        this(session, message);
        this.connection = connection;
    }

    public SessionLogEntry(int level, Session session, String message, Object[] params, Accessor connection, boolean shouldTranslate) {
        this(session, message, connection);
        this.level = level;
        this.parameters = params;
        this.shouldTranslate = shouldTranslate;
    }

    public SessionLogEntry(int level, String category, Session session, String message, Object[] params, Accessor connection, boolean shouldTranslate) {
        this(level, session, message, params, connection, shouldTranslate);
        this.nameSpace = category;
    }

    public SessionLogEntry(Session session, int level, String category, Throwable throwable) {
        this(session, throwable);
        this.level = level;
        this.nameSpace = category;
    }

    public Accessor getConnection() {
        return this.connection;
    }

    public Instant getTimeStamp() {
        return this.timeStamp;
    }

    public Throwable getException() {
        return this.throwable;
    }

    public String getMessage() {
        return this.message;
    }

    public Session getSession() {
        return this.session;
    }

    public Thread getThread() {
        return this.thread;
    }

    public int getLevel() {
        return this.level;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public String getSourceClassName() {
        return this.sourceClassName;
    }

    public String getSourceMethodName() {
        return this.sourceMethodName;
    }

    public boolean shouldTranslate() {
        return this.shouldTranslate;
    }

    public boolean hasException() {
        return this.getException() != null;
    }

    public boolean hasMessage() {
        return this.getMessage() != null && !this.getMessage().isEmpty();
    }

    public void setConnection(Accessor connection) {
        this.connection = connection;
    }

    public void setTimeStamp(Instant timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setException(Throwable throwable) {
        this.throwable = throwable;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public void setParameters(Object[] params) {
        this.parameters = params;
    }

    public void setShouldTranslate(boolean shouldTranslate) {
        this.shouldTranslate = shouldTranslate;
    }

    public void setSourceClassName(String sourceClassName) {
        this.sourceClassName = sourceClassName;
    }

    public void setSourceMethodName(String sourceMethodName) {
        this.sourceMethodName = sourceMethodName;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getMessage() + ")";
    }
}

