/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.indexes.DestinationIndex;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPMessageProcessorControllable;
import com.ibm.ws.sib.processor.runtime.impl.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.MessageProcessorControl;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import java.util.Map;

public abstract class MediatedMessageHandlerControl
extends AbstractControlAdapter {
    protected MessageProcessorControl mpControl;
    protected DestinationIndex index;
    protected DestinationManager destinationManager;
    protected BaseDestinationHandler baseDest;
    protected String name;
    protected SIBUuid12 uuid;
    protected MessageProcessor messageProcessor;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static TraceComponent tc = SibTr.register(MediatedMessageHandlerControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public MediatedMessageHandlerControl(MessageProcessor messageProcessor, BaseDestinationHandler destination) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MediatedMessageHandlerControl", (Object)new Object[]{messageProcessor, destination});
        }
        this.mpControl = (MessageProcessorControl)messageProcessor.getControlAdapter();
        this.destinationManager = messageProcessor.getDestinationManager();
        this.messageProcessor = messageProcessor;
        this.index = this.destinationManager.getDestinationIndex();
        this.baseDest = destination;
        this.name = this.baseDest.getName();
        this.uuid = this.baseDest.getUuid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MediatedMessageHandlerControl", (Object)this);
        }
    }

    public boolean isSystem() {
        return this.baseDest.isSystem();
    }

    public String getName() {
        return this.name;
    }

    public boolean isTemporary() {
        return this.baseDest.isTemporary();
    }

    public String getState() {
        return this.index.getState(this.baseDest).toString();
    }

    public SIMPIterator getBrowserIterator() {
        return null;
    }

    public SIMPIterator getConsumerIterator() {
        return null;
    }

    public SIMPIterator getProducerIterator() {
        return null;
    }

    public long getAlterationTime() {
        return this.baseDest.getAlterationTime();
    }

    public DestinationType getDestinationType() {
        return this.baseDest.getDestinationType();
    }

    public Map getDestinationContext() {
        return this.baseDest.getDefinition().getDestinationContext();
    }

    public boolean isSendAllowed() {
        return this.baseDest.isSendAllowed();
    }

    public boolean isReceiveAllowed() {
        return this.baseDest.isReceiveAllowed();
    }

    public boolean isReceiveExclusive() {
        return this.baseDest.isReceiveExclusive();
    }

    public int getDefaultPriority() {
        return this.baseDest.getDefaultPriority();
    }

    public String getExceptionDestination() {
        return this.baseDest.getExceptionDestination();
    }

    public int getMaxFailedDeliveries() {
        return this.baseDest.getMaxFailedDeliveries();
    }

    public boolean isOverrideOfQOSByProducerAllowed() {
        return this.baseDest.isOverrideOfQOSByProducerAllowed();
    }

    public Reliability getDefaultReliability() {
        return this.baseDest.getDefaultReliability();
    }

    public Reliability getMaxReliability() {
        return this.baseDest.getMaxReliability();
    }

    public SIMPMessageProcessorControllable getMessageProcessor() {
        return this.mpControl;
    }

    public boolean isLocal() {
        return this.baseDest.hasLocal();
    }

    public boolean isAlias() {
        return this.baseDest.isAlias();
    }

    public boolean isForeign() {
        return this.baseDest.isForeign();
    }

    public SIBUuid12 getUUID() {
        return this.uuid;
    }

    public String getDescription() {
        return this.baseDest.getDescription();
    }

    public String getId() {
        return this.uuid.toString();
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this.baseDest == null || !this.baseDest.isInStore()) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"MediateMessageHandlerControl.assertValidControllable", "1:372:1.15", this.uuid}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this.destinationManager = null;
        this.baseDest = null;
        this.index = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
    }

    protected void assertMessageHandlerNotCorrupt() throws SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertMessageHandlerNotCorrupt");
        }
        if (this.baseDest.isCorruptOrIndoubt()) {
            String nlsMsg = nls.getFormattedMessage("MESSAGE_HANDLER_CORRUPT_ERROR_CWSIP0201", null, null);
            SIMPException e = new SIMPException(nlsMsg);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertMessageHandlerNotCorrupt");
        }
    }
}

