/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.methods;

import java.util.concurrent.atomic.AtomicMarkableReference;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.utils.CloneUtils;
import org.apache.http.concurrent.Cancellable;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionReleaseTrigger;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.HeaderGroup;
import org.apache.http.params.HttpParams;

public abstract class AbstractExecutionAwareRequest
extends AbstractHttpMessage
implements HttpExecutionAware,
AbortableHttpRequest,
Cloneable,
HttpRequest {
    private final AtomicMarkableReference<Cancellable> cancellableRef = new AtomicMarkableReference<Object>(null, false);

    protected AbstractExecutionAwareRequest() {
    }

    @Deprecated
    public void setConnectionRequest(ClientConnectionRequest connRequest) {
        this.setCancellable((Cancellable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Deprecated
    public void setReleaseTrigger(ConnectionReleaseTrigger releaseTrigger) {
        this.setCancellable((Cancellable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void abort() {
        while (!this.cancellableRef.isMarked()) {
            Cancellable actualCancellable = (Cancellable)this.cancellableRef.getReference();
            if (!this.cancellableRef.compareAndSet(actualCancellable, actualCancellable, false, true) || actualCancellable == null) continue;
            actualCancellable.cancel();
        }
    }

    public boolean isAborted() {
        return this.cancellableRef.isMarked();
    }

    public void setCancellable(Cancellable cancellable) {
        Cancellable actualCancellable = (Cancellable)this.cancellableRef.getReference();
        if (!this.cancellableRef.compareAndSet(actualCancellable, cancellable, false, false)) {
            cancellable.cancel();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractExecutionAwareRequest clone = (AbstractExecutionAwareRequest)super.clone();
        clone.headergroup = (HeaderGroup)CloneUtils.cloneObject((Object)this.headergroup);
        clone.params = (HttpParams)CloneUtils.cloneObject((Object)this.params);
        return clone;
    }

    @Deprecated
    public void completed() {
        this.cancellableRef.set(null, false);
    }

    public void reset() {
        boolean marked;
        Cancellable actualCancellable;
        do {
            marked = this.cancellableRef.isMarked();
            actualCancellable = (Cancellable)this.cancellableRef.getReference();
            if (actualCancellable == null) continue;
            actualCancellable.cancel();
        } while (!this.cancellableRef.compareAndSet(actualCancellable, null, marked, false));
    }
}

