/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.handler.validator.cloudant;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cloudant.CloudantDatabaseService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.resource.ResourceConfig;
import com.ibm.wsspi.resource.ResourceConfigFactory;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import com.ibm.wsspi.validator.Validator;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, service={Validator.class}, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.root=/validation", "com.ibm.wsspi.rest.handler.config.pid=com.ibm.ws.cloudant.cloudantDatabase"})
public class CloudantDatabaseValidator
implements Validator {
    private static final TraceComponent tc = Tr.register(CloudantDatabaseValidator.class, (String)"rest.validation", null);
    @Reference
    private ResourceConfigFactory resourceConfigFactory;
    static final long serialVersionUID = -5980679049846751528L;

    public boolean isParameter(String name) {
        return "auth".equals(name) || "authAlias".equals(name);
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    @FFDCIgnore(value={NoSuchMethodException.class})
    public LinkedHashMap<String, ?> validate(Object instance, Map<String, Object> props, Locale locale) {
        LinkedHashMap<String, Object> result;
        boolean trace;
        block12: {
            String auth = (String)props.get("auth");
            String authAlias = (String)props.get("authAlias");
            trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"validate", (Object[])new Object[]{auth, authAlias});
            }
            result = new LinkedHashMap<String, Object>();
            try {
                int authType;
                ResourceConfig config = null;
                int n = "container".equals(auth) ? 0 : (authType = "application".equals(auth) ? 1 : -1);
                if (authType >= 0) {
                    config = this.resourceConfigFactory.createResourceConfig("com.cloudant.client.api.Database");
                    config.setResAuthType(authType);
                    if (authAlias != null && authType == 0) {
                        config.addLoginProperty("DefaultPrincipalMapping", authAlias);
                    }
                }
                Object database = ((ResourceFactory)instance).createResource(config);
                database.getClass().getMethod("info", new Class[0]).invoke(database, new Object[0]);
                URI dbURI = (URI)database.getClass().getMethod("getDBUri", new Class[0]).invoke(database, new Object[0]);
                result.put("uri", dbURI == null ? "null" : dbURI.toString());
                Object cloudantClient = ((CloudantDatabaseService)instance).getCloudantClient((ResourceInfo)config);
                if (cloudantClient == null) break block12;
                try {
                    String metaInfoVendorVarient;
                    Object metaInfo = cloudantClient.getClass().getMethod("metaInformation", new Class[0]).invoke(cloudantClient, new Object[0]);
                    result.put("serverVersion", metaInfo.getClass().getMethod("getVersion", new Class[0]).invoke(metaInfo, new Object[0]));
                    Object metaInfoVendor = metaInfo.getClass().getMethod("getVendor", new Class[0]).invoke(metaInfo, new Object[0]);
                    result.put("vendorName", metaInfoVendor.getClass().getMethod("getName", new Class[0]).invoke(metaInfoVendor, new Object[0]));
                    String metaInfoVendorVersion = (String)metaInfoVendor.getClass().getMethod("getVersion", new Class[0]).invoke(metaInfoVendor, new Object[0]);
                    if (metaInfoVendorVersion != null) {
                        result.put("vendorVersion", metaInfoVendorVersion);
                    }
                    if ((metaInfoVendorVarient = (String)metaInfoVendor.getClass().getMethod("getVariant", new Class[0]).invoke(metaInfoVendor, new Object[0])) != null) {
                        result.put("vendorVariant", metaInfoVendorVarient);
                    }
                }
                catch (NoSuchMethodException ex) {
                    try {
                        result.put("serverVersion", cloudantClient.getClass().getMethod("serverVersion", new Class[0]).invoke(cloudantClient, new Object[0]));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
            }
            catch (Throwable config) {
                void x;
                FFDCFilter.processException((Throwable)config, (String)"com.ibm.ws.rest.handler.validator.cloudant.CloudantDatabaseValidator", (String)"113", (Object)this, (Object[])new Object[]{instance, props, locale});
                result.put("failure", x);
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"validate", result);
        }
        return result;
    }
}

