/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins.jose4j;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.claims.UserClaims;
import com.ibm.ws.security.oauth20.util.ConfigUtils;
import com.ibm.ws.security.wim.VMMService;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import com.ibm.wsspi.security.registry.RegistryHelper;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.PersonAccount;
import com.ibm.wsspi.security.wim.model.PropertyControl;
import com.ibm.wsspi.security.wim.model.Root;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OidcUserClaims
extends UserClaims {
    private static final TraceComponent tc = Tr.register(OidcUserClaims.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    static final long serialVersionUID = 2661549095006601624L;

    public OidcUserClaims(UserClaims oauthClaims) {
        super(oauthClaims.asMap(), oauthClaims.getUserName(), oauthClaims.getGroupIdentifier());
    }

    /*
     * WARNING - void declaration
     */
    public void addExtraClaims(OidcServerConfig oidcServerConfig) {
        if (oidcServerConfig.isCustomClaimsEnabled()) {
            Map<String, Object> vmmInfoMap;
            block5: {
                Set extraCustomClaims = oidcServerConfig.getCustomClaims();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("extraCustomClaims length: " + extraCustomClaims.size()), (Object[])new Object[0]);
                }
                if (extraCustomClaims == null || extraCustomClaims.size() <= 0) {
                    return;
                }
                vmmInfoMap = new HashMap<String, Object>();
                try {
                    vmmInfoMap = this.getUserinfoFromRegistryMap(oidcServerConfig, extraCustomClaims, vmmInfoMap, false);
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.plugins.jose4j.OidcUserClaims", (String)"74", (Object)this, (Object[])new Object[]{oidcServerConfig});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)"extraCustomClaims get unexpected Exception", (Object[])new Object[]{e});
                }
            }
            this.claimsMap.putAll(vmmInfoMap);
        }
    }

    public Map<String, Object> getUserinfoFromRegistryMap(OidcServerConfig oidcServerConfig, Set<String> claims, Map<String, Object> inputMap, boolean isJson) throws Exception {
        Map<String, Object> result = inputMap;
        String userName = this.userName;
        VMMService vmmService = ConfigUtils.getVMMService();
        if (vmmService != null) {
            PropertyControl vmmServiceProps = new PropertyControl();
            Properties claimsToVMMProperties = new Properties();
            if (!claims.isEmpty()) {
                Properties claimsToVMMProps = oidcServerConfig.getClaimToUserRegistryMap();
                for (String claim : claims) {
                    String vmmProperty = claimsToVMMProps.getProperty(claim);
                    if (vmmProperty == null) {
                        vmmProperty = claim;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("claim: " + claim + "  is not mapped to a vmm property, using the claim name as the vmm property name"), (Object[])new Object[0]);
                        }
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("claim: " + claim + "  mapped to vmmProperty: " + vmmProperty), (Object[])new Object[0]);
                    }
                    claimsToVMMProperties.put(claim, vmmProperty);
                    vmmServiceProps.getProperties().add(vmmProperty);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("claimsToVMMProperties: " + claimsToVMMProperties), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("getting VMM properties: " + vmmServiceProps.getProperties()), (Object[])new Object[0]);
            }
            if (!vmmServiceProps.getProperties().isEmpty()) {
                IdentifierType id = new IdentifierType();
                String uniqueId = RegistryHelper.getUserRegistry(null).getUniqueUserId(userName);
                id.setUniqueName(uniqueId);
                Entity entity = new Entity();
                entity.setIdentifier(id);
                Root root = new Root();
                root.getEntities().add(entity);
                root.getControls().add(vmmServiceProps);
                root = vmmService.get(root);
                PersonAccount person = (PersonAccount)root.getEntities().get(0);
                for (Map.Entry<Object, Object> e : claimsToVMMProperties.entrySet()) {
                    String strValue;
                    String claim = (String)e.getKey();
                    String vmmProperty = (String)e.getValue();
                    Object value = person.get(vmmProperty);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("get for claim: " + claim + "  vmmProperty: " + vmmProperty + ", returned: " + value), (Object[])new Object[0]);
                    }
                    if ((strValue = this.vmmPropertyToString(value)) == null || strValue.isEmpty()) continue;
                    if (isJson && claim.equals("address")) {
                        JSONObject addressJSON = new JSONObject();
                        addressJSON.put((Object)"formatted", (Object)strValue);
                        result.put(claim, addressJSON);
                        continue;
                    }
                    result.put(claim, strValue);
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"VMM service not available - returning sub and groupIds claims", (Object[])new Object[0]);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject getUserinfoFromRegistry(OidcServerConfig oidcServerConfig, JSONObject inputJSON, HttpServletRequest request, HttpServletResponse response, HashSet<String> claims) throws IOException {
        JSONObject responseJSON = inputJSON;
        Map<String, Object> vmmInfoMap = new HashMap<String, Object>();
        try {
            vmmInfoMap = this.getUserinfoFromRegistryMap(oidcServerConfig, claims, vmmInfoMap, true);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.plugins.jose4j.OidcUserClaims", (String)"178", (Object)this, (Object[])new Object[]{oidcServerConfig, inputJSON, request, response, claims});
            response.sendError(500);
            Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_USERINFO_INTERNAL_ERROR", (Object[])new Object[]{e.getMessage(), request.getRequestURI()});
        }
        return this.mapToJson(vmmInfoMap, responseJSON);
    }

    public JSONObject mapToJson(Map<String, Object> map, JSONObject jsonObject) {
        Set<Map.Entry<String, Object>> entries = map.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            jsonObject.put((Object)entry.getKey(), entry.getValue());
        }
        return jsonObject;
    }

    public String vmmPropertyToString(Object value) {
        String result = null;
        if (value == null || value instanceof String) {
            result = (String)value;
        } else if (value instanceof List) {
            StringBuffer strBuff = null;
            for (Object element : (List)value) {
                String elem = element.toString();
                if (elem == null) continue;
                if (strBuff == null) {
                    strBuff = new StringBuffer();
                } else {
                    strBuff.append(" ");
                }
                strBuff.append(elem);
            }
            if (strBuff != null) {
                result = strBuff.toString();
            }
        } else {
            result = value.toString();
        }
        return result;
    }
}

