/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.responsetype;

import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.error.OAuthConfigurationException;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidResponseTypeException;
import com.ibm.oauth.core.internal.oauth20.config.OAuth20ConfigProvider;
import com.ibm.oauth.core.internal.oauth20.responsetype.OAuth20ResponseTypeHandler;
import com.ibm.oauth.core.internal.oauth20.responsetype.OAuth20ResponseTypeHandlerFactory;
import com.ibm.oauth.core.internal.oauth20.responsetype.impl.OAuth20ResponseTypeHandlerCodeImpl;
import com.ibm.oauth.core.internal.oauth20.responsetype.impl.OAuth20ResponseTypeHandlerTokenImpl;
import java.util.logging.Logger;

public class OAuth20ResponseTypeHandlerFactoryImpl
implements OAuth20ResponseTypeHandlerFactory {
    static final String CLASS = OAuth20ResponseTypeHandlerFactoryImpl.class.getName();
    static final Logger _log = Logger.getLogger(CLASS);
    OAuthComponentConfiguration _oldconfig = null;

    @Override
    public void init(OAuthComponentConfiguration oldconfig) {
        this._oldconfig = oldconfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized OAuth20ResponseTypeHandler getHandler(String responseType, OAuth20ConfigProvider config) throws OAuthException {
        String methodName = "getHandler";
        _log.entering(CLASS, methodName, new Object[]{responseType});
        OAuth20ResponseTypeHandler result = null;
        try {
            boolean found = false;
            boolean allowed = false;
            if (responseType != null) {
                if (responseType.equals("code")) {
                    found = true;
                    allowed = config.isGrantTypeAllowed("authorization_code");
                    result = new OAuth20ResponseTypeHandlerCodeImpl();
                } else if (responseType.equals("token")) {
                    found = true;
                    allowed = config.isGrantTypeAllowed("implicit");
                    result = new OAuth20ResponseTypeHandlerTokenImpl();
                }
            }
            if (!found) {
                throw new OAuth20InvalidResponseTypeException("security.oauth20.error.invalid.responsetype", responseType);
            }
            if (!allowed) {
                throw new OAuthConfigurationException("security.oauth.error.mismatch.responsetype.exception", "oauth20.grant.types.allowed", responseType, null);
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return result;
    }
}

