/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Headers;

public class ProducerRecordFactory {
    private static final String CLAZZ = ProducerRecordFactory.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLAZZ);

    public static <V> ProducerRecord<?, ?> getDelegateProducerRecord(String configuredTopic, String channelName, V value) {
        ProducerRecord delegateRecord;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLAZZ, "newDelegateProducerRecord", "Configured Topic: {0}, Channel Name: {1}, Value: {2}", new String[]{configuredTopic, channelName, value.toString()});
        }
        if (value instanceof ProducerRecord) {
            ProducerRecord userProducerRecord = (ProducerRecord)value;
            delegateRecord = ProducerRecordFactory.extractUserProducerRecord(configuredTopic, userProducerRecord);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLAZZ, "newDelegateProducerRecord", "User provider ProducerRecord. Topic: {0}, Value: {1}", new String[]{delegateRecord.topic(), delegateRecord.value().toString()});
            }
        } else {
            String topic = configuredTopic == null ? channelName : configuredTopic;
            delegateRecord = new ProducerRecord(topic, value);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLAZZ, "newDelegateProducerRecord", "Internal ProducerRecord. Topic: {0}, Value: {1}", new String[]{delegateRecord.topic(), delegateRecord.value().toString()});
            }
        }
        return delegateRecord;
    }

    public static <K, V> ProducerRecord<K, V> extractUserProducerRecord(String configuredTopic, ProducerRecord<K, V> userProducerRecord) {
        ProducerRecord delegateRecord;
        String topic;
        String userTopic = userProducerRecord.topic();
        String string = topic = configuredTopic == null ? userTopic : configuredTopic;
        if (topic.contentEquals(userTopic)) {
            delegateRecord = userProducerRecord;
        } else {
            Headers headers = userProducerRecord.headers();
            Object key = userProducerRecord.key();
            Integer partition = userProducerRecord.partition();
            Long timestamp = userProducerRecord.timestamp();
            Object userValue = userProducerRecord.value();
            delegateRecord = new ProducerRecord(topic, partition, timestamp, key, userValue, (Iterable)headers);
        }
        return delegateRecord;
    }
}

