/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.AnnotationLiteral;

public abstract class AbstractBean<T>
implements Bean<T> {
    protected final Class<T> type;

    public AbstractBean(Class<T> type) {
        this.type = type;
    }

    public Class<?> getBeanClass() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public String getName() {
        return this.type.getName();
    }

    public Set<Annotation> getQualifiers() {
        return new HashSet<AnnotationLiteral>(Arrays.asList(new AnnotationLiteral<Default>(){}, new AnnotationLiteral<Any>(){}));
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.type);
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public void destroy(T instance, CreationalContext<T> ctx) {
        ctx.release();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getName() + " with " + this.getQualifiers();
    }
}

