/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.client.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.backchannellogout.BackchannelLogoutHelper;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientConfig;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.kernel.service.utils.ServiceAndServiceReferencePair;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.security.openidconnect.client.web.OidcBackchannelLogoutServlet", service={}, property={"service.vendor=IBM"})
public class OidcBackchannelLogoutServlet
extends HttpServlet {
    private static TraceComponent tc = Tr.register(OidcBackchannelLogoutServlet.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.client.internal.resources.OidcClientMessages");
    private static final long serialVersionUID = 1L;
    private static final ConcurrentServiceReferenceSet<OidcClientConfig> oidcClientConfigRef = new ConcurrentServiceReferenceSet("oidcClientConfigService");

    @Reference(name="oidcClientConfigService", service=OidcClientConfig.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void setOidcClientConfigService(ServiceReference<OidcClientConfig> reference) {
        oidcClientConfigRef.addReference(reference);
    }

    protected void unsetOidcClientConfigService(ServiceReference<OidcClientConfig> reference) {
        oidcClientConfigRef.removeReference(reference);
    }

    public void activate(ComponentContext cc) {
        oidcClientConfigRef.activate(cc);
    }

    public void deactivate(ComponentContext cc) {
        oidcClientConfigRef.deactivate(cc);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestUri = request.getRequestURI();
        OidcClientConfig matchingConfig = this.getMatchingConfig(requestUri);
        BackchannelLogoutHelper logoutHelper = new BackchannelLogoutHelper(request, response, (ConvergedClientConfig)matchingConfig);
        logoutHelper.handleBackchannelLogoutRequest();
    }

    private OidcClientConfig getMatchingConfig(String requestUri) {
        Iterator servicesWithRefs = oidcClientConfigRef.getServicesWithReferences();
        while (servicesWithRefs.hasNext()) {
            ServiceAndServiceReferencePair configServiceAndRef = (ServiceAndServiceReferencePair)servicesWithRefs.next();
            OidcClientConfig config = (OidcClientConfig)configServiceAndRef.getService();
            String configId = config.getId();
            if (!requestUri.endsWith("/" + configId)) continue;
            return config;
        }
        return null;
    }
}

