/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.kerberos.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.kerberos.IBMKrb5Helper;
import com.ibm.ws.security.kerberos.Krb5HelperJdk;
import com.ibm.ws.security.kerberos.OtherKrb5Helper;
import com.ibm.ws.security.kerberos.auth.Krb5LoginModuleWrapper;
import com.ibm.ws.security.kerberos.internal.KerberosExtConfig;
import com.ibm.ws.security.s4u2proxy.KerberosExtService;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={KerberosExtService.class}, name="KerberosExtService", immediate=true, configurationPid={"com.ibm.ws.security.s4u2proxy.KerberosExtService"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class KerberosExtServiceImpl
implements KerberosExtService {
    private static final TraceComponent tc = Tr.register(KerberosExtServiceImpl.class, (String)"Kerberos", (String)"com.ibm.ws.security.kerberos.internal.resources.KerberosMessages");
    static final String KEY_KRB5_HELPER_JDK = "Krb5HelperJdk";
    private KerberosExtConfig kerberosExtConfig = null;
    private volatile Krb5HelperJdk krb5HelperJdk = null;
    private ServiceRegistration<Krb5HelperJdk> krb5HelperJdkReg;
    static final long serialVersionUID = -4191609480367164689L;

    @Reference(policy=ReferencePolicy.STATIC, target="(java.specification.version>=1.8)")
    protected void setProcess(LibertyProcess process) {
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) {
        this.kerberosExtConfig = new KerberosExtConfig(props);
        this.registerKrb5HelperJdk(cc);
    }

    @Modified
    protected void modified(Map<String, Object> props) {
        this.kerberosExtConfig = new KerberosExtConfig(props);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        if (this.krb5HelperJdkReg != null) {
            this.krb5HelperJdkReg.unregister();
        }
    }

    public GSSCredential getDelegateGSSCredUsingS4U2self(String upn, String targetServiceSpn, Oid gssNameType, int gssCredUsage, String delegateServiceSpn, Subject delegateServiceSubject) throws GSSException {
        if (this.krb5HelperJdk != null) {
            return this.krb5HelperJdk.getDelegateGSSCredUsingS4U2self(upn, targetServiceSpn, gssNameType, gssCredUsage, delegateServiceSpn, delegateServiceSubject);
        }
        return null;
    }

    public GSSCredential getDelegateGSSCredUsingS4U2proxy(String userPrincipalName, GSSContext delegateGSSContext, String delegateServiceSpn) throws GSSException {
        if (this.krb5HelperJdk != null) {
            return this.krb5HelperJdk.getDelegateGSSCredUsingS4U2proxy(userPrincipalName, delegateGSSContext, delegateServiceSpn);
        }
        return null;
    }

    public Subject doKerberosLogin(String delegateSpn, String krb5Keytab) throws LoginException {
        if (this.krb5HelperJdk != null) {
            return this.krb5HelperJdk.doKerberosLogin(null, delegateSpn, krb5Keytab);
        }
        return null;
    }

    public boolean isS4U2selfEnable() {
        return this.kerberosExtConfig != null ? this.kerberosExtConfig.isS4U2selfEnable() : false;
    }

    public boolean isS4U2proxyEnable() {
        return this.kerberosExtConfig != null ? this.kerberosExtConfig.isS4U2proxyEnable() : false;
    }

    private void registerKrb5HelperJdk(ComponentContext cc) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        if (Krb5LoginModuleWrapper.IBM_KRB5_LOGIN_MODULE_AVAILABLE) {
            this.krb5HelperJdk = new IBMKrb5Helper();
            ((Dictionary)props).put("name", "IBMKrb5Helper");
        } else {
            this.krb5HelperJdk = new OtherKrb5Helper();
            ((Dictionary)props).put("name", "OtherKrb5Helper");
        }
        BundleContext bc = cc.getBundleContext();
        this.krb5HelperJdkReg = bc.registerService(Krb5HelperJdk.class, (Object)this.krb5HelperJdk, props);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Register the OSGI service  " + ((Dictionary)props).get("name")), (Object[])new Object[0]);
        }
    }
}

