/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.server.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.util.ConfigUtils;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.ws.webcontainer.security.oauth20.OAuth20Service;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServer;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OidcServerImpl
implements OidcServer {
    private static TraceComponent tc = Tr.register(OidcServerImpl.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    public static final String REGEX_COMPONENT_ID = "/([\\w-]+)/";
    public static final String REGEX_REGISTRATION = "registration(/\\S*)?";
    public static final String apwPattern = "app-passwords|app-passwords/.*";
    public static final String atokPattern = "app-tokens|app-tokens/.*";
    public static final String usersTokMgmtPattern = "usersTokenManagement|usersTokenManagement/.*";
    public static final String persTokMgmtPattern = "personalTokenManagement|personalTokenManagement/.*";
    public static final String clientMgmtPattern = "clientManagement|clientManagement/.*";
    private static final Pattern PATH_RE = Pattern.compile("^/([\\w-]+)/(authorize|token|introspect|revoke|.well-known/openid-configuration|userinfo|registration(/\\S*)?|check_session_iframe|end_session|coverage_map|proxy|app-passwords|app-passwords/.*|app-tokens|app-tokens/.*|usersTokenManagement|usersTokenManagement/.*|personalTokenManagement|personalTokenManagement/.*|clientManagement|clientManagement/.*)$");
    public static final String CFG_KEY_ID = "id";
    public static final String CFG_KEY_OIDC_SERVER_CONFIG = "oidcServerConfig";
    private final ConcurrentServiceReferenceMap<String, OidcServerConfig> oidcServerConfigRef = new ConcurrentServiceReferenceMap("oidcServerConfig");
    private boolean bOidcUpdated = false;
    HashMap<String, OidcServerConfig> oidcMap = new HashMap();
    ConfigUtils configUtils = new ConfigUtils();
    protected static final String KEY_ID = "id";
    protected static final String KEY_oauth20Provider = "oauth20Provider";
    protected static final ConcurrentServiceReferenceMap<String, OAuth20Provider> oauth20ProviderRef = new ConcurrentServiceReferenceMap("oauth20Provider");
    static final long serialVersionUID = 7211094829080578136L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOauth20Provider(ServiceReference<OAuth20Provider> ref) {
        String id = (String)ref.getProperty("id");
        ConcurrentServiceReferenceMap<String, OAuth20Provider> concurrentServiceReferenceMap = oauth20ProviderRef;
        synchronized (concurrentServiceReferenceMap) {
            oauth20ProviderRef.putReference((Object)id, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" setOAuth20Provider id:" + id), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedOauth20Provider(ServiceReference<OAuth20Provider> ref) {
        String id = (String)ref.getProperty("id");
        ConcurrentServiceReferenceMap<String, OAuth20Provider> concurrentServiceReferenceMap = oauth20ProviderRef;
        synchronized (concurrentServiceReferenceMap) {
            oauth20ProviderRef.putReference((Object)id, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" updateOAuth20Provider id:" + id), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetOauth20Provider(ServiceReference<OAuth20Provider> ref) {
        String id = (String)ref.getProperty("id");
        ConcurrentServiceReferenceMap<String, OAuth20Provider> concurrentServiceReferenceMap = oauth20ProviderRef;
        synchronized (concurrentServiceReferenceMap) {
            oauth20ProviderRef.removeReference((Object)id, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" unsetOAuth20Provider id:" + id), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOidcServerConfig(ServiceReference<OidcServerConfig> ref) {
        ConcurrentServiceReferenceMap<String, OidcServerConfig> concurrentServiceReferenceMap = this.oidcServerConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            this.oidcServerConfigRef.putReference((Object)((String)ref.getProperty("id")), ref);
            this.bOidcUpdated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetOidcServerConfig(ServiceReference<OidcServerConfig> ref) {
        ConcurrentServiceReferenceMap<String, OidcServerConfig> concurrentServiceReferenceMap = this.oidcServerConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            this.oidcServerConfigRef.removeReference((Object)((String)ref.getProperty("id")), ref);
            this.bOidcUpdated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void activate(ComponentContext cc) {
        ConcurrentServiceReferenceMap<String, OidcServerConfig> concurrentServiceReferenceMap = this.oidcServerConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            this.oidcServerConfigRef.activate(cc);
            this.bOidcUpdated = true;
        }
        concurrentServiceReferenceMap = oauth20ProviderRef;
        synchronized (concurrentServiceReferenceMap) {
            oauth20ProviderRef.activate(cc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"activate", (Object[])new Object[0]);
        }
    }

    protected synchronized void modify(Map<String, Object> properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void deactivate(ComponentContext cc) {
        ConcurrentServiceReferenceMap<String, OidcServerConfig> concurrentServiceReferenceMap = this.oidcServerConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            this.oidcServerConfigRef.deactivate(cc);
            this.bOidcUpdated = true;
        }
        concurrentServiceReferenceMap = oauth20ProviderRef;
        synchronized (concurrentServiceReferenceMap) {
            oauth20ProviderRef.deactivate(cc);
        }
    }

    public ProviderAuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res, AtomicServiceReference<OAuth20Service> oauthServiceRef) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOIDCSpecificURI(HttpServletRequest req, boolean protectedOrAll) {
        String oidcProviderName;
        OidcServerConfig oidcServerConfig;
        Matcher matcher;
        String contextPath = req.getContextPath();
        String uri = req.getRequestURI();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("contextPath=" + contextPath + " uri=" + uri), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("check " + (protectedOrAll ? "Protected-Endpoints" : "All-endpoints")), (Object[])new Object[0]);
        }
        if (contextPath != null && contextPath.equals("/oidc") && (matcher = this.endpointRequest(req)) != null && (oidcServerConfig = this.getOidcServerConfig(oidcProviderName = this.getProviderNameFromUrl(matcher))) != null) {
            Matcher matcherEndpoint;
            if (protectedOrAll) {
                matcherEndpoint = oidcServerConfig.getProtectedEndpointsPattern().matcher(uri);
                if (matcherEndpoint.matches()) {
                    return true;
                }
            } else {
                matcherEndpoint = oidcServerConfig.getEndpointsPattern().matcher(uri);
                if (matcherEndpoint.matches()) {
                    Matcher matcherNonEndpoint = oidcServerConfig.getNonEndpointsPattern().matcher(uri);
                    return !matcherNonEndpoint.matches();
                }
            }
        }
        if (!protectedOrAll) {
            ConcurrentServiceReferenceMap<String, OAuth20Provider> concurrentServiceReferenceMap = oauth20ProviderRef;
            synchronized (concurrentServiceReferenceMap) {
                Iterator oauth20Providers = oauth20ProviderRef.getServices();
                while (oauth20Providers.hasNext()) {
                    OAuth20Provider provider = (OAuth20Provider)oauth20Providers.next();
                    if (!provider.isMiscUri(req)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OidcServerConfig getOidcServerConfig(String oidcProviderName) {
        ConcurrentServiceReferenceMap<String, OidcServerConfig> concurrentServiceReferenceMap = this.oidcServerConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            if (this.bOidcUpdated) {
                this.oidcMap = this.configUtils.checkDuplicateOAuthProvider(this.oidcServerConfigRef);
                this.bOidcUpdated = false;
            }
        }
        OidcServerConfig oidcServerConfig = this.oidcMap.get(oidcProviderName);
        return oidcServerConfig;
    }

    protected String getProviderNameFromUrl(Matcher m) {
        String componentId = m.group(1);
        return componentId;
    }

    private Matcher endpointRequest(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("path=" + path), (Object[])new Object[0]);
        }
        if (path == null || path.isEmpty()) {
            return null;
        }
        Matcher m = PATH_RE.matcher(path);
        if (m.matches()) {
            return m;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowDefaultSsoCookieName() {
        ConcurrentServiceReferenceMap<String, OidcServerConfig> concurrentServiceReferenceMap = this.oidcServerConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            if (this.bOidcUpdated) {
                this.oidcMap = this.configUtils.checkDuplicateOAuthProvider(this.oidcServerConfigRef);
                this.bOidcUpdated = false;
            }
        }
        boolean allow = false;
        if (this.oidcMap.entrySet() != null) {
            Iterator<Map.Entry<String, OidcServerConfig>> it = this.oidcMap.entrySet().iterator();
            while (it.hasNext()) {
                OidcServerConfig cfg = it.next().getValue();
                if (cfg.allowDefaultSsoCookieName()) {
                    allow = true;
                    continue;
                }
                allow = false;
                break;
            }
        }
        return allow;
    }
}

