/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.openidconnect.backchannellogout;

import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.api.oauth20.token.OAuth20TokenCache;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.ProvidersService;
import com.ibm.ws.security.oauth20.api.OAuth20EnhancedTokenCache;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClientValidator;
import com.ibm.ws.security.oauth20.plugins.jose4j.JWTData;
import com.ibm.ws.security.oauth20.plugins.jose4j.JwsSigner;
import com.ibm.ws.security.oauth20.util.CacheUtil;
import com.ibm.ws.security.oauth20.util.HashUtils;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import com.ibm.ws.security.openidconnect.backchannellogout.BackchannelLogoutException;
import com.ibm.ws.security.openidconnect.server.internal.JwtUtils;
import com.ibm.ws.security.openidconnect.token.JWT;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import io.openliberty.security.common.jwt.JwtParsingUtils;
import io.openliberty.security.openidconnect.backchannellogout.IdTokenDifferentIssuerException;
import io.openliberty.security.openidconnect.backchannellogout.LogoutTokenBuilderException;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.JwtContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LogoutTokenBuilder {
    private static TraceComponent tc = Tr.register(LogoutTokenBuilder.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    public static final String EVENTS_MEMBER_NAME = "http://schemas.openid.net/event/backchannel-logout";
    private final HttpServletRequest request;
    private final OidcServerConfig oidcServerConfig;
    private final OAuth20Provider oauth20provider;
    private final OAuth20EnhancedTokenCache tokenCache;
    static final long serialVersionUID = -7989731134130991072L;

    public LogoutTokenBuilder(HttpServletRequest request, OidcServerConfig oidcServerConfig) {
        this.request = request;
        this.oidcServerConfig = oidcServerConfig;
        this.oauth20provider = this.getOAuth20Provider(oidcServerConfig);
        this.tokenCache = this.oauth20provider.getTokenCache();
    }

    OAuth20Provider getOAuth20Provider(OidcServerConfig oidcServerConfig) {
        String oauthProviderName = oidcServerConfig.getOauthProviderName();
        return ProvidersService.getOAuth20Provider((String)oauthProviderName);
    }

    public Map<OidcBaseClient, Set<String>> buildLogoutTokensFromUserName(String user) {
        return this.buildLogoutTokensForUser(user);
    }

    /*
     * WARNING - void declaration
     */
    public Map<OidcBaseClient, Set<String>> buildLogoutTokensFromIdTokenString(String idTokenString) throws LogoutTokenBuilderException {
        this.validateIdTokenSignature(idTokenString);
        JwtClaims idTokenClaims = this.getClaimsFromIdTokenString(idTokenString);
        try {
            return this.buildLogoutTokensForUser(idTokenClaims.getSubject());
        }
        catch (MalformedClaimException malformedClaimException) {
            void e;
            FFDCFilter.processException((Throwable)malformedClaimException, (String)"io.openliberty.security.openidconnect.backchannellogout.LogoutTokenBuilder", (String)"84", (Object)this, (Object[])new Object[]{idTokenString});
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"LOGOUT_TOKEN_ERROR_GETTING_CLAIMS_FROM_ID_TOKEN", (Object[])new Object[]{e});
            throw new LogoutTokenBuilderException(errorMsg, (Exception)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    void validateIdTokenSignature(String idTokenString) throws LogoutTokenBuilderException {
        try {
            String oauthProviderName = this.oidcServerConfig.getOauthProviderName();
            OAuth20Provider oauthProvider = ProvidersService.getOAuth20Provider((String)oauthProviderName);
            JWT jwt = JwtUtils.createJwt(idTokenString, oauthProvider, this.oidcServerConfig);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("JWT : " + jwt), (Object[])new Object[0]);
            }
            jwt.verifySignatureOnly();
        }
        catch (Exception oauthProviderName) {
            void e;
            FFDCFilter.processException((Throwable)oauthProviderName, (String)"io.openliberty.security.openidconnect.backchannellogout.LogoutTokenBuilder", (String)"99", (Object)this, (Object[])new Object[]{idTokenString});
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"LOGOUT_TOKEN_ERROR_GETTING_CLAIMS_FROM_ID_TOKEN", (Object[])new Object[]{e});
            throw new LogoutTokenBuilderException(errorMsg, (Exception)e);
        }
    }

    @FFDCIgnore(value={Exception.class})
    JwtClaims getClaimsFromIdTokenString(String idTokenString) throws LogoutTokenBuilderException {
        try {
            JwtContext jwtContext = JwtParsingUtils.parseJwtWithoutValidation((String)idTokenString);
            JwtClaims claims = jwtContext.getJwtClaims();
            this.verifyIdTokenContainsRequiredClaims(claims);
            this.verifyIssuer(claims);
            return claims;
        }
        catch (Exception e) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"LOGOUT_TOKEN_ERROR_GETTING_CLAIMS_FROM_ID_TOKEN", (Object[])new Object[]{e});
            throw new LogoutTokenBuilderException(errorMsg, e);
        }
    }

    void verifyIdTokenContainsRequiredClaims(JwtClaims claims) throws Exception {
        List aud;
        String sub;
        ArrayList<String> missingClaims = new ArrayList<String>();
        String iss = claims.getIssuer();
        if (iss == null || iss.isEmpty()) {
            missingClaims.add("iss");
        }
        if ((sub = claims.getSubject()) == null || sub.isEmpty()) {
            missingClaims.add("sub");
        }
        if ((aud = claims.getAudience()) == null || aud.isEmpty()) {
            missingClaims.add("aud");
        }
        if (!missingClaims.isEmpty()) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"ID_TOKEN_MISSING_REQUIRED_CLAIMS", (Object[])new Object[]{missingClaims});
            throw new BackchannelLogoutException(errorMsg);
        }
    }

    void verifyIssuer(JwtClaims idTokenClaims) throws MalformedClaimException, IdTokenDifferentIssuerException {
        String issuerClaim = idTokenClaims.getIssuer();
        String expectedIssuer = this.oidcServerConfig.getIssuerIdentifier();
        if (expectedIssuer != null && !expectedIssuer.isEmpty()) {
            if (!expectedIssuer.equals(issuerClaim)) {
                String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"ID_TOKEN_ISSUER_NOT_THIS_OP", (Object[])new Object[]{issuerClaim, expectedIssuer, this.oidcServerConfig.getProviderId()});
                throw new IdTokenDifferentIssuerException(errorMsg);
            }
        } else {
            String otherExpectedIssuer;
            expectedIssuer = this.getIssuerFromRequest();
            if (!expectedIssuer.equals(issuerClaim) && !(otherExpectedIssuer = expectedIssuer.replace("/oidc/providers/", "/oidc/endpoint/")).equals(issuerClaim)) {
                String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"ID_TOKEN_ISSUER_NOT_THIS_OP", (Object[])new Object[]{issuerClaim, expectedIssuer, this.oidcServerConfig.getProviderId()});
                throw new IdTokenDifferentIssuerException(errorMsg);
            }
        }
    }

    Map<OidcBaseClient, Set<String>> buildLogoutTokensForUser(String user) {
        Collection<OAuth20Token> allCachedUserTokens = this.getAllCachedUserTokens(user);
        Map<OidcBaseClient, List<OAuth20Token>> clientsToLogOut = this.getClientsToLogOut(allCachedUserTokens);
        Map<OidcBaseClient, Set<String>> logoutTokens = this.buildLogoutTokensForClients(clientsToLogOut);
        this.removeUserTokensFromCache(allCachedUserTokens, clientsToLogOut);
        return logoutTokens;
    }

    Collection<OAuth20Token> getAllCachedUserTokens(String user) {
        return this.tokenCache.getAllUserTokens(user);
    }

    void removeUserTokensFromCache(Collection<OAuth20Token> allCachedUserTokens, Map<OidcBaseClient, List<OAuth20Token>> clientsToLogOut) {
        this.removeUserIdTokensFromCache(clientsToLogOut);
        this.removeUserAccessTokensFromCache(allCachedUserTokens, clientsToLogOut);
    }

    void removeUserIdTokensFromCache(Map<OidcBaseClient, List<OAuth20Token>> clientsToLogOut) {
        for (Map.Entry<OidcBaseClient, List<OAuth20Token>> clientEntry : clientsToLogOut.entrySet()) {
            for (OAuth20Token cachedIdToken : clientEntry.getValue()) {
                this.tokenCache.remove(cachedIdToken.getId());
                this.removeRefreshTokenAssociatedWithOAuthTokenFromCache(cachedIdToken);
            }
        }
    }

    void removeUserAccessTokensFromCache(Collection<OAuth20Token> allCachedUserTokens, Map<OidcBaseClient, List<OAuth20Token>> clientsToCachedIdTokens) {
        if (clientsToCachedIdTokens.isEmpty()) {
            return;
        }
        HashSet<String> clientIdsBeingLoggedOut = new HashSet<String>();
        for (OidcBaseClient client : clientsToCachedIdTokens.keySet()) {
            clientIdsBeingLoggedOut.add(client.getClientId());
        }
        for (OAuth20Token token : allCachedUserTokens) {
            String clientIdForAccessToken;
            if (!this.isAccessTokenCreatedForUser(token) || !clientIdsBeingLoggedOut.contains(clientIdForAccessToken = token.getClientId())) continue;
            this.removeAccessTokenAndAssociatedRefreshTokenFromCache(token);
        }
    }

    boolean isAccessTokenCreatedForUser(OAuth20Token token) {
        if (!"access_token".equals(token.getType())) {
            return false;
        }
        String grantType = token.getGrantType();
        return grantType == null || !grantType.equals("app_password") && !grantType.equals("app_token");
    }

    void removeAccessTokenAndAssociatedRefreshTokenFromCache(OAuth20Token accessToken) {
        String tokenString;
        String tokenLookupStr = tokenString = accessToken.getTokenString();
        if (OidcOAuth20Util.isJwtToken((String)tokenString)) {
            tokenLookupStr = HashUtils.digest((String)tokenString);
        }
        this.tokenCache.remove(tokenLookupStr);
        this.removeRefreshTokenAssociatedWithOAuthTokenFromCache(accessToken);
    }

    void removeRefreshTokenAssociatedWithOAuthTokenFromCache(OAuth20Token cachedToken) {
        CacheUtil cu = new CacheUtil((OAuth20TokenCache)this.tokenCache);
        OAuth20Token refreshToken = cu.getRefreshToken(cachedToken);
        if (refreshToken != null && !this.refreshTokenHasOfflineAccessScope(refreshToken)) {
            this.tokenCache.remove(refreshToken.getTokenString());
        }
    }

    boolean refreshTokenHasOfflineAccessScope(OAuth20Token refreshToken) {
        String[] scopes = refreshToken.getScope();
        if (scopes == null) {
            return false;
        }
        for (String scope : scopes) {
            if (!"offline_access".equals(scope)) continue;
            return true;
        }
        return false;
    }

    Map<OidcBaseClient, List<OAuth20Token>> getClientsToLogOut(Collection<OAuth20Token> allCachedUserTokens) {
        if (allCachedUserTokens == null || allCachedUserTokens.isEmpty()) {
            return new HashMap<OidcBaseClient, List<OAuth20Token>>();
        }
        return this.getClientToCachedIdTokensMap(allCachedUserTokens);
    }

    Map<OidcBaseClient, List<OAuth20Token>> getClientToCachedIdTokensMap(Collection<OAuth20Token> allCachedUserTokens) {
        HashMap<OidcBaseClient, List<OAuth20Token>> cachedIdTokensMap = new HashMap<OidcBaseClient, List<OAuth20Token>>();
        OidcOAuth20ClientProvider clientProvider = this.oauth20provider.getClientProvider();
        HashMap<String, OidcBaseClient> fetchedClients = new HashMap<String, OidcBaseClient>();
        for (OAuth20Token cachedToken : allCachedUserTokens) {
            OidcBaseClient client;
            if (!"id_token".equals(cachedToken.getType()) || (client = this.getClient(fetchedClients, clientProvider, cachedToken)) == null || !this.isValidClientForBackchannelLogout(client)) continue;
            this.addCachedIdTokenToMap(cachedIdTokensMap, client, cachedToken);
        }
        return cachedIdTokensMap;
    }

    @FFDCIgnore(value={OidcServerException.class})
    boolean isValidClientForBackchannelLogout(OidcBaseClient client) {
        String logoutUri = client.getBackchannelLogoutUri();
        if (logoutUri == null) {
            return false;
        }
        try {
            OidcBaseClientValidator.validateBackchannelLogoutUri((OidcBaseClient)client, (String)logoutUri);
        }
        catch (OidcServerException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The {0} OAuth client cannot be used for back-channel logout because its back-channel logout URI ({1}) is not valid: {2}", (Object[])new Object[]{client.getClientId(), logoutUri, e.getErrorDescription()});
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    OidcBaseClient getClient(Map<String, OidcBaseClient> fetchedClients, OidcOAuth20ClientProvider clientProvider, OAuth20Token cachedToken) {
        String cachedTokenClientId = cachedToken.getClientId();
        OidcBaseClient client = fetchedClients.get(cachedTokenClientId);
        if (client == null) {
            try {
                client = clientProvider.get(cachedTokenClientId);
                fetchedClients.put(cachedTokenClientId, client);
            }
            catch (OidcServerException oidcServerException) {
                void e;
                FFDCFilter.processException((Throwable)oidcServerException, (String)"io.openliberty.security.openidconnect.backchannellogout.LogoutTokenBuilder", (String)"311", (Object)this, (Object[])new Object[]{fetchedClients, clientProvider, cachedToken});
                Tr.error((TraceComponent)tc, (String)"ERROR_RETRIEVING_CLIENT_TO_BUILD_LOGOUT_TOKENS", (Object[])new Object[]{this.oidcServerConfig.getProviderId(), cachedTokenClientId, e});
            }
        }
        return client;
    }

    void addCachedIdTokenToMap(Map<OidcBaseClient, List<OAuth20Token>> cachedIdTokensMap, OidcBaseClient client, OAuth20Token cachedToken) {
        List<OAuth20Token> cachedIdTokens = new ArrayList<OAuth20Token>();
        if (cachedIdTokensMap.containsKey(client)) {
            cachedIdTokens = cachedIdTokensMap.get(client);
        }
        cachedIdTokens.add(cachedToken);
        cachedIdTokensMap.put(client, cachedIdTokens);
    }

    Map<OidcBaseClient, Set<String>> buildLogoutTokensForClients(Map<OidcBaseClient, List<OAuth20Token>> clientsToLogOut) {
        HashMap<OidcBaseClient, Set<String>> clientsAndLogoutTokens = new HashMap<OidcBaseClient, Set<String>>();
        if (clientsToLogOut == null || clientsToLogOut.isEmpty()) {
            return clientsAndLogoutTokens;
        }
        for (Map.Entry<OidcBaseClient, List<OAuth20Token>> clientAndIdTokens : clientsToLogOut.entrySet()) {
            OidcBaseClient client = clientAndIdTokens.getKey();
            Set<String> logoutTokens = this.buildLogoutTokensForClient(client, clientAndIdTokens.getValue());
            if (logoutTokens == null || logoutTokens.isEmpty()) continue;
            clientsAndLogoutTokens.put(client, logoutTokens);
        }
        return clientsAndLogoutTokens;
    }

    @FFDCIgnore(value={LogoutTokenBuilderException.class})
    Set<String> buildLogoutTokensForClient(OidcBaseClient client, List<OAuth20Token> cachedIdTokens) {
        HashSet<String> logoutTokens = new HashSet<String>();
        for (OAuth20Token cachedIdToken : cachedIdTokens) {
            try {
                String logoutToken = this.createLogoutTokenForClientFromCachedIdToken(client, cachedIdToken);
                logoutTokens.add(logoutToken);
            }
            catch (LogoutTokenBuilderException e) {
                if (e.getCause() instanceof IdTokenDifferentIssuerException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Will not create a logout token for cached ID token " + cachedIdToken + " because the issuer of the token is different"), (Object[])new Object[0]);
                    continue;
                }
                Tr.error((TraceComponent)tc, (String)"ERROR_BUILDING_LOGOUT_TOKEN_BASED_ON_ID_TOKEN", (Object[])new Object[]{client.getClientId(), e});
            }
        }
        return logoutTokens;
    }

    String createLogoutTokenForClientFromCachedIdToken(OidcBaseClient client, OAuth20Token cachedIdToken) throws LogoutTokenBuilderException {
        JwtClaims cachedIdTokenClaims = this.getClaimsFromIdTokenString(cachedIdToken.getTokenString());
        return this.createLogoutTokenForClient(client, cachedIdTokenClaims);
    }

    /*
     * WARNING - void declaration
     */
    String createLogoutTokenForClient(OidcBaseClient client, JwtClaims idTokenClaims) throws LogoutTokenBuilderException {
        try {
            JwtClaims logoutTokenClaims = this.populateLogoutTokenClaimsFromIdToken(client, idTokenClaims);
            String sharedKey = client.getClientSecret();
            JWTData jwtData = new JWTData(sharedKey, this.oidcServerConfig, "Json Web Token");
            jwtData.setTypHeader("logout+jwt");
            return JwsSigner.getSignedJwt((JwtClaims)logoutTokenClaims, (OidcServerConfig)this.oidcServerConfig, (JWTData)jwtData);
        }
        catch (Exception logoutTokenClaims) {
            void e;
            FFDCFilter.processException((Throwable)logoutTokenClaims, (String)"io.openliberty.security.openidconnect.backchannellogout.LogoutTokenBuilder", (String)"378", (Object)this, (Object[])new Object[]{client, idTokenClaims});
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"ERROR_BUILDING_LOGOUT_TOKEN_BASED_ON_ID_TOKEN_CLAIMS", (Object[])new Object[]{idTokenClaims, client.getClientId(), e});
            throw new LogoutTokenBuilderException(errorMsg, (Exception)e);
        }
    }

    JwtClaims populateLogoutTokenClaimsFromIdToken(OidcBaseClient client, JwtClaims idTokenClaims) throws MalformedClaimException, LogoutTokenBuilderException {
        JwtClaims logoutTokenClaims = this.populateLogoutTokenClaims(client, idTokenClaims);
        String subject = idTokenClaims.getSubject();
        if (subject == null || subject.isEmpty()) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"ID_TOKEN_MISSING_REQUIRED_CLAIMS", (Object[])new Object[]{"sub"});
            throw new LogoutTokenBuilderException(errorMsg);
        }
        logoutTokenClaims.setSubject(subject);
        String sid = idTokenClaims.getStringClaimValue("sid");
        if (sid != null && !sid.isEmpty()) {
            logoutTokenClaims.setClaim("sid", (Object)sid);
        }
        return logoutTokenClaims;
    }

    JwtClaims populateLogoutTokenClaims(OidcBaseClient client, JwtClaims idTokenClaims) throws MalformedClaimException, LogoutTokenBuilderException {
        JwtClaims logoutTokenClaims = new JwtClaims();
        String issuer = idTokenClaims.getIssuer();
        if (issuer == null || issuer.isEmpty()) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"ID_TOKEN_MISSING_REQUIRED_CLAIMS", (Object[])new Object[]{"iss"});
            throw new LogoutTokenBuilderException(errorMsg);
        }
        logoutTokenClaims.setIssuer(issuer);
        logoutTokenClaims.setAudience(client.getClientId());
        logoutTokenClaims.setIssuedAtToNow();
        logoutTokenClaims.setExpirationTimeMinutesInTheFuture(2.0f);
        logoutTokenClaims.setGeneratedJwtId();
        HashMap eventsClaim = new HashMap();
        eventsClaim.put(EVENTS_MEMBER_NAME, new HashMap());
        logoutTokenClaims.setClaim("events", eventsClaim);
        return logoutTokenClaims;
    }

    String getIssuerFromRequest() {
        String issuerIdentifier = this.request.getScheme() + "://" + this.request.getServerName();
        int port = this.request.getServerPort();
        if (port != 80 && port != 443) {
            issuerIdentifier = issuerIdentifier + ":" + port;
        }
        issuerIdentifier = issuerIdentifier + "/oidc/providers/" + this.oidcServerConfig.getProviderId();
        return issuerIdentifier;
    }
}

