/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.spi.expression.literal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.data.spi.expression.literal.NumericLiteral;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.math.BigDecimal;
import java.math.BigInteger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
final class NumericLiteralRecord<N extends Number>
extends Record
implements NumericLiteral<N> {
    private final N value;
    static final long serialVersionUID = -5174051422733194666L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    NumericLiteralRecord(N value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    @Override
    public String toString() {
        N n = this.value;
        if (n instanceof Long) {
            Long l = (Long)n;
            return l + "L";
        }
        n = this.value;
        if (n instanceof Integer) {
            Integer i = (Integer)n;
            return i.toString();
        }
        n = this.value;
        if (n instanceof Double) {
            Double d = (Double)n;
            return d + "D";
        }
        n = this.value;
        if (n instanceof Float) {
            Float f = (Float)n;
            return f + "F";
        }
        n = this.value;
        if (n instanceof BigDecimal) {
            BigDecimal b = (BigDecimal)n;
            return String.valueOf(b) + "BD";
        }
        n = this.value;
        if (n instanceof BigInteger) {
            BigInteger b = (BigInteger)n;
            return String.valueOf(b) + "BI";
        }
        return "{NumericLiteral " + this.value.getClass().getName() + " '" + String.valueOf(this.value) + "'}";
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NumericLiteralRecord.class, "value", "value"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NumericLiteralRecord.class, "value", "value"}, this, o);
    }

    @Override
    public N value() {
        return this.value;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"jakarta.data.spi.expression.literal.NumericLiteralRecord", NumericLiteralRecord.class, null, null);
    }
}

