/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.restrict;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.data.restrict.CompositeRestriction;
import jakarta.data.restrict.Restriction;
import java.util.List;
import java.util.Objects;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
record CompositeRestrictionRecord<T>(CompositeRestriction.Type type, List<Restriction<? super T>> restrictions, boolean isNegated) implements CompositeRestriction<T>
{
    private static final int SINGLE_RESTRICTION_LENGTH_ESTIMATE = 100;
    static final long serialVersionUID = 8362676469044318340L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    CompositeRestrictionRecord {
        Objects.requireNonNull(restrictions, "restrictions");
        if (restrictions.isEmpty()) {
            throw new IllegalArgumentException("restrictions");
        }
        restrictions.forEach(r -> Objects.requireNonNull(r, "restriction"));
    }

    CompositeRestrictionRecord(CompositeRestriction.Type type, List<Restriction<? super T>> restrictions) {
        this(type, restrictions, false);
    }

    @Override
    public CompositeRestriction<T> negate() {
        return new CompositeRestrictionRecord<T>(this.type, this.restrictions, !this.isNegated);
    }

    @Override
    public String toString() {
        String op = this.type.asQueryLanguage();
        int len = 6 + this.restrictions.size() * 100;
        StringBuilder builder = new StringBuilder(len);
        if (this.isNegated) {
            builder.append("NOT (");
        }
        boolean first = true;
        for (Restriction<? super T> restriction : this.restrictions) {
            if (first) {
                first = false;
            } else {
                builder.append(' ').append(op).append(' ');
            }
            builder.append('(').append(restriction).append(')');
        }
        if (this.isNegated) {
            builder.append(')');
        }
        return builder.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"jakarta.data.restrict.CompositeRestrictionRecord", CompositeRestrictionRecord.class, null, null);
    }
}

