/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.page;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.data.page.PageRequest;
import java.util.Optional;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
record Pagination(long page, int size, PageRequest.Mode mode, PageRequest.Cursor type, boolean requestTotal) implements PageRequest
{
    static final long serialVersionUID = -3881851535901893630L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    Pagination {
        if (page < 1L) {
            throw new IllegalArgumentException("pageNumber: " + page);
        }
        if (size < 1) {
            throw new IllegalArgumentException("maxPageSize: " + size);
        }
        if (mode != PageRequest.Mode.OFFSET && (type == null || type.size() == 0)) {
            throw new IllegalArgumentException("No key values were provided.");
        }
    }

    @Override
    public PageRequest afterCursor(PageRequest.Cursor cursor) {
        return new Pagination(this.page, this.size, PageRequest.Mode.CURSOR_NEXT, cursor, this.requestTotal);
    }

    @Override
    public PageRequest beforeCursor(PageRequest.Cursor cursor) {
        return new Pagination(this.page, this.size, PageRequest.Mode.CURSOR_PREVIOUS, cursor, this.requestTotal);
    }

    @Override
    public Optional<PageRequest.Cursor> cursor() {
        return this.type == null ? Optional.empty() : Optional.of(this.type);
    }

    @Override
    public PageRequest page(long pageNum) {
        return new Pagination(pageNum, this.size, this.mode, this.type, this.requestTotal);
    }

    @Override
    public Pagination size(int maxPageSize) {
        return new Pagination(this.page, maxPageSize, this.mode, this.type, this.requestTotal);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("PageRequest{page=").append(this.page).append(", size=").append(this.size).append(", mode=").append((Object)this.mode);
        if (this.type != null) {
            b.append(", cursor size=").append(this.type.size());
        }
        b.append("}");
        return b.toString();
    }

    @Override
    public PageRequest withoutTotal() {
        return new Pagination(this.page, this.size, this.mode, this.type, false);
    }

    @Override
    public PageRequest withTotal() {
        return new Pagination(this.page, this.size, this.mode, this.type, true);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"jakarta.data.page.Pagination", Pagination.class, null, null);
    }
}

