/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.constraint;

import jakarta.data.constraint.Constraint;
import jakarta.data.constraint.LikeRecord;
import jakarta.data.constraint.NotLikeRecord;
import jakarta.data.expression.TextExpression;
import jakarta.data.spi.expression.literal.StringLiteral;

public interface NotLike
extends Constraint<String> {
    public Character escape();

    public static NotLike literal(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        StringLiteral expression = StringLiteral.of(LikeRecord.escape(value));
        return new NotLikeRecord(expression, Character.valueOf('\\'));
    }

    public TextExpression<?> pattern();

    public static NotLike pattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        StringLiteral expression = StringLiteral.of(pattern);
        return new NotLikeRecord(expression, null);
    }

    public static NotLike pattern(String pattern, char charWildcard, char stringWildcard) {
        return NotLike.pattern(pattern, charWildcard, stringWildcard, '\\');
    }

    public static NotLike pattern(String pattern, char charWildcard, char stringWildcard, char escape) {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        StringLiteral expression = StringLiteral.of(LikeRecord.translate(pattern, charWildcard, stringWildcard, escape));
        return new NotLikeRecord(expression, Character.valueOf(escape));
    }

    public static NotLike pattern(TextExpression<?> pattern, char escape) {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        return new NotLikeRecord(pattern, Character.valueOf(escape));
    }

    public static NotLike prefix(String prefix) {
        if (prefix == null) {
            throw new NullPointerException();
        }
        StringLiteral expression = StringLiteral.of(LikeRecord.escape(prefix) + "%");
        return new NotLikeRecord(expression, Character.valueOf('\\'));
    }

    public static NotLike substring(String substring) {
        if (substring == null) {
            throw new NullPointerException("substring");
        }
        StringLiteral expression = StringLiteral.of("%" + LikeRecord.escape(substring) + "%");
        return new NotLikeRecord(expression, Character.valueOf('\\'));
    }

    public static NotLike suffix(String suffix) {
        if (suffix == null) {
            throw new NullPointerException("suffix");
        }
        StringLiteral expression = StringLiteral.of("%" + LikeRecord.escape(suffix));
        return new NotLikeRecord(expression, Character.valueOf('\\'));
    }
}

