/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.constraint;

import jakarta.data.constraint.Constraint;
import jakarta.data.constraint.NotInRecord;
import jakarta.data.expression.Expression;
import jakarta.data.spi.expression.literal.Literal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public interface NotIn<V>
extends Constraint<V> {
    public List<Expression<?, V>> expressions();

    @SafeVarargs
    public static <V> NotIn<V> expressions(Expression<?, V> ... expressions) {
        if (expressions == null) {
            throw new NullPointerException("expressions");
        }
        if (expressions.length == 0) {
            throw new IllegalArgumentException("expressions");
        }
        for (Expression<?, V> expression : expressions) {
            if (expression != null) continue;
            throw new NullPointerException();
        }
        return new NotInRecord<V>(List.of(expressions));
    }

    public static <V> NotIn<V> expressions(List<Expression<?, V>> expressions) {
        if (expressions == null) {
            throw new NullPointerException("expressions");
        }
        if (expressions.isEmpty()) {
            throw new IllegalArgumentException("expressions");
        }
        for (Expression<?, V> expression : expressions) {
            if (expression != null) continue;
            throw new NullPointerException();
        }
        return new NotInRecord<V>(List.copyOf(expressions));
    }

    public static <V> NotIn<V> values(Collection<V> values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException("values");
        }
        ArrayList<Literal<V>> expressions = new ArrayList<Literal<V>>(values.size());
        for (V value : values) {
            if (value == null) {
                throw new NullPointerException();
            }
            expressions.add(Literal.of(value));
        }
        return new NotInRecord(Collections.unmodifiableList(expressions));
    }

    @SafeVarargs
    public static <V> NotIn<V> values(V ... values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        if (values.length == 0) {
            throw new NullPointerException("values");
        }
        ArrayList<Literal<V>> expressions = new ArrayList<Literal<V>>(values.length);
        for (V value : values) {
            if (value == null) {
                throw new NullPointerException();
            }
            expressions.add(Literal.of(value));
        }
        return new NotInRecord(Collections.unmodifiableList(expressions));
    }
}

