/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.constraint;

import jakarta.data.constraint.Constraint;
import jakarta.data.constraint.LikeRecord;
import jakarta.data.expression.TextExpression;
import jakarta.data.spi.expression.literal.StringLiteral;

public interface Like
extends Constraint<String> {
    public Character escape();

    public static Like literal(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        StringLiteral expression = StringLiteral.of(LikeRecord.escape(value));
        return new LikeRecord(expression, Character.valueOf('\\'));
    }

    public TextExpression<?> pattern();

    public static Like pattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        StringLiteral expression = StringLiteral.of(pattern);
        return new LikeRecord(expression, null);
    }

    public static Like pattern(String pattern, char charWildcard, char stringWildcard) {
        return Like.pattern(pattern, charWildcard, stringWildcard, '\\');
    }

    public static Like pattern(String pattern, char charWildcard, char stringWildcard, char escape) {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        StringLiteral expression = StringLiteral.of(LikeRecord.translate(pattern, charWildcard, stringWildcard, escape));
        return new LikeRecord(expression, Character.valueOf(escape));
    }

    public static Like pattern(TextExpression<?> pattern, char escape) {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        return new LikeRecord(pattern, Character.valueOf(escape));
    }

    public static Like prefix(String prefix) {
        if (prefix == null) {
            throw new NullPointerException("prefix");
        }
        StringLiteral expression = StringLiteral.of(LikeRecord.escape(prefix) + "%");
        return new LikeRecord(expression, Character.valueOf('\\'));
    }

    public static Like substring(String substring) {
        if (substring == null) {
            throw new NullPointerException("substring");
        }
        StringLiteral expression = StringLiteral.of("%" + LikeRecord.escape(substring) + "%");
        return new LikeRecord(expression, Character.valueOf('\\'));
    }

    public static Like suffix(String suffix) {
        if (suffix == null) {
            throw new NullPointerException("suffix");
        }
        StringLiteral expression = StringLiteral.of("%" + LikeRecord.escape(suffix));
        return new LikeRecord(expression, Character.valueOf('\\'));
    }
}

