/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.rest.client.component.RestClientNotifier;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Configuration;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.ClientProxyImpl;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.FilterProviderInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.microprofile.client.DefaultResponseExceptionMapper;
import org.apache.cxf.microprofile.client.MicroProfileClientConfigurableImpl;
import org.apache.cxf.microprofile.client.MicroProfileClientProviderFactory;
import org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MicroProfileClientFactoryBean
extends JAXRSClientFactoryBean {
    private final Comparator<ProviderInfo<?>> comparator;
    private final List<Object> registeredProviders;
    private Configuration configuration;
    private ClassLoader proxyLoader;
    private boolean inheritHeaders;
    private ExecutorService executorService;
    static final long serialVersionUID = -1194634786511825006L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public MicroProfileClientFactoryBean(MicroProfileClientConfigurableImpl<RestClientBuilder> configuration, String baseUri, Class<?> aClass, ExecutorService executorService) {
        this.configuration = configuration.getConfiguration();
        this.comparator = MicroProfileClientProviderFactory.createComparator(this);
        this.executorService = executorService;
        super.setAddress(baseUri);
        super.setServiceClass(aClass);
        super.setProviderComparator(this.comparator);
        this.registeredProviders = new ArrayList<Object>();
        this.registeredProviders.addAll(this.processProviders());
        if (!configuration.isDefaultExceptionMapperDisabled()) {
            this.registeredProviders.add(new ProviderInfo((Object)new DefaultResponseExceptionMapper(), this.getBus(), false));
        }
        this.registeredProviders.add(new ProviderInfo(ProviderFactory.createJsonpProvider(), this.getBus(), false));
        super.setProviders(this.registeredProviders);
    }

    public void setClassLoader(ClassLoader loader) {
        super.setClassLoader(loader);
        this.proxyLoader = loader;
    }

    public void setInheritHeaders(boolean inheritHeaders) {
        super.setInheritHeaders(inheritHeaders);
        this.inheritHeaders = inheritHeaders;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    protected void initClient(AbstractClient client, Endpoint ep, boolean addHeaders) {
        super.initClient(client, ep, addHeaders);
        MicroProfileClientProviderFactory factory = MicroProfileClientProviderFactory.createInstance(this.getBus(), this.comparator);
        this.registeredProviders.add(new ProviderInfo(ProviderFactory.createJsonBindingProvider((Iterable)factory.getContextResolversActual()), this.getBus(), false));
        factory.setUserProviders(this.registeredProviders);
        ep.put((Object)MicroProfileClientProviderFactory.CLIENT_FACTORY_NAME, (Object)factory);
    }

    protected ClientProxyImpl createClientProxy(ClassResourceInfo cri, boolean isRoot, ClientState actualState, Object[] varValues) {
        MicroProfileClientProxyImpl clientProxy = actualState == null ? new MicroProfileClientProxyImpl(URI.create(this.getAddress()), this.proxyLoader, cri, isRoot, this.inheritHeaders, this.executorService, this.configuration, varValues) : new MicroProfileClientProxyImpl(actualState, this.proxyLoader, cri, isRoot, this.inheritHeaders, this.executorService, this.configuration, varValues);
        RestClientNotifier notifier = RestClientNotifier.getInstance();
        if (notifier != null) {
            notifier.newRestClientProxy(clientProxy);
        }
        return clientProxy;
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    private Set<Object> processProviders() {
        LinkedHashSet<Object> providers = new LinkedHashSet<Object>();
        for (Object provider : this.configuration.getInstances()) {
            Class providerCls = ClassHelper.getRealClass((Bus)this.bus, provider);
            if (provider instanceof ClientRequestFilter || provider instanceof ClientResponseFilter) {
                FilterProviderInfo filter = new FilterProviderInfo(providerCls, providerCls, provider, this.bus, this.configuration.getContracts(providerCls));
                providers.add(filter);
                continue;
            }
            providers.add(provider);
        }
        return providers;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.microprofile.client.MicroProfileClientFactoryBean", MicroProfileClientFactoryBean.class, null, null);
    }
}

