/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client;

import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import org.apache.cxf.microprofile.client.MicroProfileClientConfigurableImpl;
import org.apache.cxf.microprofile.client.MicroProfileClientFactoryBean;
import org.apache.cxf.microprofile.client.Validator;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.annotation.RegisterProvider;

public class CxfTypeSafeClientBuilder
implements RestClientBuilder,
Configurable<RestClientBuilder> {
    private String baseUri;
    private ExecutorService executorService;
    private final MicroProfileClientConfigurableImpl<RestClientBuilder> configImpl = new MicroProfileClientConfigurableImpl<CxfTypeSafeClientBuilder>(this);

    public RestClientBuilder baseUrl(URL url) {
        this.baseUri = Objects.requireNonNull(url).toExternalForm();
        return this;
    }

    public RestClientBuilder baseUri(URI uri) {
        this.baseUri = Objects.requireNonNull(uri).toString();
        return this;
    }

    public RestClientBuilder executorService(ExecutorService executor) {
        if (null == executor) {
            throw new IllegalArgumentException("executor must not be null");
        }
        this.executorService = executor;
        return this;
    }

    public <T> T build(Class<T> aClass) {
        if (this.baseUri == null) {
            throw new IllegalStateException("baseUrl not set");
        }
        Validator.checkValid(aClass);
        RegisterProvider[] providers = (RegisterProvider[])aClass.getAnnotationsByType(RegisterProvider.class);
        Configuration config = this.configImpl.getConfiguration();
        if (providers != null) {
            for (RegisterProvider provider : providers) {
                if (config.isRegistered(provider.value())) continue;
                if (provider.priority() == -1) {
                    this.register(provider.value());
                    continue;
                }
                this.register(provider.value(), provider.priority());
            }
        }
        MicroProfileClientFactoryBean bean = new MicroProfileClientFactoryBean(this.configImpl, this.baseUri, aClass, this.executorService);
        return (T)bean.create(aClass, new Object[0]);
    }

    public Configuration getConfiguration() {
        return this.configImpl.getConfiguration();
    }

    public RestClientBuilder property(String key, Object value) {
        this.configImpl.property(key, value);
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass) {
        this.configImpl.register(componentClass);
        return this;
    }

    public RestClientBuilder register(Object component) {
        this.configImpl.register(component);
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass, int priority) {
        this.configImpl.register(componentClass, priority);
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass, Class<?> ... contracts) {
        this.configImpl.register(componentClass, contracts);
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.configImpl.register(componentClass, contracts);
        return this;
    }

    public RestClientBuilder register(Object component, int priority) {
        this.configImpl.register(component, priority);
        return this;
    }

    public RestClientBuilder register(Object component, Class<?> ... contracts) {
        this.configImpl.register(component, contracts);
        return this;
    }

    public RestClientBuilder register(Object component, Map<Class<?>, Integer> contracts) {
        this.configImpl.register(component, contracts);
        return this;
    }
}

