/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.scim20.model.schemas;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.wim.scim20.model.schemas.SchemaAttribute;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonPropertyOrder(value={"name", "type", "subAttributes", "multiValued", "description", "required", "canonicalValues", "caseExact", "mutability", "returned", "uniqueness", "referenceTypes"})
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SchemaAttributeImpl
implements SchemaAttribute {
    @JsonProperty(value="canonicalValues")
    private List<String> canonicalValues;
    @JsonProperty(value="caseExact")
    private Boolean caseExact;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="multiValued")
    private Boolean multiValued;
    @JsonProperty(value="mutability")
    private String mutability;
    @JsonProperty(value="name")
    private String name;
    private SchemaAttributeImpl parent;
    @JsonProperty(value="referenceTypes")
    private List<String> referenceTypes;
    @JsonProperty(value="required")
    private Boolean required;
    @JsonProperty(value="returned")
    private String returned;
    private String schemaUrn;
    @JsonProperty(value="subAttributes")
    private List<SchemaAttribute> subAttributes;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="uniqueness")
    private String uniqueness;
    private String wimProperty;
    static final long serialVersionUID = -6056514878597088600L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SchemaAttributeImpl() {
    }

    public SchemaAttributeImpl(String name, String schemaUrn, String type, List<SchemaAttribute> subAttributes, Boolean multiValued, String description, Boolean required, List<String> canonicalValues, Boolean caseExact, String mutability, String returned, String uniqueness, List<String> referenceTypes) {
        this.name = name;
        this.schemaUrn = schemaUrn;
        this.type = type;
        this.subAttributes = subAttributes;
        this.multiValued = multiValued;
        this.description = description;
        this.required = required;
        this.canonicalValues = canonicalValues;
        this.caseExact = caseExact;
        this.mutability = mutability;
        this.returned = returned;
        this.uniqueness = uniqueness;
        this.referenceTypes = referenceTypes;
        if (this.subAttributes != null) {
            for (SchemaAttribute subAttr : subAttributes) {
                ((SchemaAttributeImpl)subAttr).parent = this;
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaAttributeImpl other = (SchemaAttributeImpl)obj;
        if (this.canonicalValues == null ? other.canonicalValues != null : !this.canonicalValues.equals(other.canonicalValues)) {
            return false;
        }
        if (this.caseExact == null ? other.caseExact != null : !this.caseExact.equals(other.caseExact)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.multiValued == null ? other.multiValued != null : !this.multiValued.equals(other.multiValued)) {
            return false;
        }
        if (this.mutability == null ? other.mutability != null : !this.mutability.equals(other.mutability)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.referenceTypes == null ? other.referenceTypes != null : !this.referenceTypes.equals(other.referenceTypes)) {
            return false;
        }
        if (this.required == null ? other.required != null : !this.required.equals(other.required)) {
            return false;
        }
        if (this.returned == null ? other.returned != null : !this.returned.equals(other.returned)) {
            return false;
        }
        if (this.schemaUrn == null ? other.schemaUrn != null : !this.schemaUrn.equals(other.schemaUrn)) {
            return false;
        }
        if (this.subAttributes == null ? other.subAttributes != null : !this.subAttributes.equals(other.subAttributes)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.uniqueness == null ? other.uniqueness != null : !this.uniqueness.equals(other.uniqueness)) {
            return false;
        }
        return !(this.wimProperty == null ? other.wimProperty != null : !this.wimProperty.equals(other.wimProperty));
    }

    public String getAnnotatedName() {
        if (this.parent != null) {
            return this.parent.getName() + "." + this.name;
        }
        return this.name;
    }

    @Override
    public List<String> getCanonicalValues() {
        return this.canonicalValues;
    }

    @Override
    public Boolean getCaseExact() {
        return this.caseExact;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Boolean getMultiValued() {
        return this.multiValued;
    }

    @Override
    public String getMutability() {
        return this.mutability;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getReferenceTypes() {
        return Collections.unmodifiableList(this.referenceTypes);
    }

    @Override
    public Boolean getRequired() {
        return this.required;
    }

    @Override
    public String getReturned() {
        return this.returned;
    }

    @Override
    public List<SchemaAttribute> getSubAttributes() {
        return this.subAttributes == null ? null : Collections.unmodifiableList(this.subAttributes);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getUniqueness() {
        return this.uniqueness;
    }

    public String getUrn() {
        return this.schemaUrn + ":" + this.getAnnotatedName();
    }

    public String getWimProperty() {
        return this.wimProperty;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.canonicalValues == null ? 0 : this.canonicalValues.hashCode());
        result = 31 * result + (this.caseExact == null ? 0 : this.caseExact.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.multiValued == null ? 0 : this.multiValued.hashCode());
        result = 31 * result + (this.mutability == null ? 0 : this.mutability.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.referenceTypes == null ? 0 : this.referenceTypes.hashCode());
        result = 31 * result + (this.required == null ? 0 : this.required.hashCode());
        result = 31 * result + (this.returned == null ? 0 : this.returned.hashCode());
        result = 31 * result + (this.schemaUrn == null ? 0 : this.schemaUrn.hashCode());
        result = 31 * result + (this.subAttributes == null ? 0 : this.subAttributes.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.uniqueness == null ? 0 : this.uniqueness.hashCode());
        result = 31 * result + (this.wimProperty == null ? 0 : this.wimProperty.hashCode());
        return result;
    }

    public void setCanonicalValues(List<String> canonicalValues) {
        this.canonicalValues = canonicalValues;
    }

    public void setCaseExact(Boolean caseExact) {
        this.caseExact = caseExact;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMultiValued(Boolean multiValued) {
        this.multiValued = multiValued;
    }

    public void setMutability(String mutability) {
        this.mutability = mutability;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReferenceTypes(List<String> referenceTypes) {
        this.referenceTypes = referenceTypes;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public void setReturned(String returned) {
        this.returned = returned;
    }

    public void setSubAttributes(List<SchemaAttribute> subAttributes) {
        this.subAttributes = subAttributes;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUniqueness(String uniqueness) {
        this.uniqueness = uniqueness;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SchemaAttributeImpl [");
        if (this.canonicalValues != null) {
            builder.append("canonicalValues=");
            builder.append(this.canonicalValues);
            builder.append(", ");
        }
        if (this.caseExact != null) {
            builder.append("caseExact=");
            builder.append(this.caseExact);
            builder.append(", ");
        }
        if (this.description != null) {
            builder.append("description=");
            builder.append(this.description);
            builder.append(", ");
        }
        if (this.multiValued != null) {
            builder.append("multiValued=");
            builder.append(this.multiValued);
            builder.append(", ");
        }
        if (this.mutability != null) {
            builder.append("mutability=");
            builder.append(this.mutability);
            builder.append(", ");
        }
        if (this.name != null) {
            builder.append("name=");
            builder.append(this.name);
            builder.append(", ");
        }
        if (this.parent != null) {
            builder.append("parent=");
            builder.append(this.parent);
            builder.append(", ");
        }
        if (this.referenceTypes != null) {
            builder.append("referenceTypes=");
            builder.append(this.referenceTypes);
            builder.append(", ");
        }
        if (this.required != null) {
            builder.append("required=");
            builder.append(this.required);
            builder.append(", ");
        }
        if (this.returned != null) {
            builder.append("returned=");
            builder.append(this.returned);
            builder.append(", ");
        }
        if (this.schemaUrn != null) {
            builder.append("schemaUrn=");
            builder.append(this.schemaUrn);
            builder.append(", ");
        }
        if (this.subAttributes != null) {
            builder.append("subAttributes=");
            builder.append(this.subAttributes);
            builder.append(", ");
        }
        if (this.type != null) {
            builder.append("type=");
            builder.append(this.type);
            builder.append(", ");
        }
        if (this.uniqueness != null) {
            builder.append("uniqueness=");
            builder.append(this.uniqueness);
            builder.append(", ");
        }
        if (this.wimProperty != null) {
            builder.append("wimProperty=");
            builder.append(this.wimProperty);
        }
        builder.append("]");
        return builder.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.wim.scim20.model.schemas.SchemaAttributeImpl", SchemaAttributeImpl.class, null, null);
    }
}

