/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.scim20;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.wim.scim20.model.ListResponse;
import com.ibm.websphere.security.wim.scim20.model.schemas.Schema;
import com.ibm.websphere.security.wim.scim20.model.schemas.SchemaAttribute;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.scim20.model.ListResponseImpl;
import com.ibm.ws.security.wim.scim20.model.schemas.SchemaAttributeImpl;
import com.ibm.ws.security.wim.scim20.model.schemas.SchemaImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SchemaHandler {
    private static Map<String, SchemaAttributeImpl> GROUP_ATTRIBUTE_MAP;
    private static Map<String, SchemaImpl> SCHEMA_MAP;
    private static Map<String, SchemaAttributeImpl> USER_ATTRIBUTE_MAP;
    static final long serialVersionUID = 6100103231291754065L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private static void addToAttributeMap(Map<String, SchemaAttributeImpl> map, SchemaAttributeImpl attribute) {
        String annotatedName = attribute.getAnnotatedName().toLowerCase();
        String urn = attribute.getUrn().toLowerCase();
        if (!map.containsKey(annotatedName)) {
            map.put(annotatedName, attribute);
        }
        map.put(urn, attribute);
    }

    private static void addToGroupAttributeMap(SchemaAttributeImpl attribute) {
        SchemaHandler.addToAttributeMap(GROUP_ATTRIBUTE_MAP, attribute);
    }

    private static void addToUserAttributeMap(SchemaAttributeImpl attribute) {
        SchemaHandler.addToAttributeMap(USER_ATTRIBUTE_MAP, attribute);
    }

    private static void configureCoreGroup() {
        ArrayList<SchemaAttribute> rootAttributes = new ArrayList<SchemaAttribute>();
        SchemaAttributeImpl displayName = new SchemaAttributeImpl("displayName", "urn:ietf:params:scim:schemas:core:2.0:Group", "string", null, false, "A human-readable name for the Group. REQUIRED.", true, null, false, "readWrite", "default", "none", null);
        rootAttributes.add(displayName);
        SchemaAttributeImpl members_value = new SchemaAttributeImpl("value", "urn:ietf:params:scim:schemas:core:2.0:Group", "string", null, false, "Identifier of the member of this Group.", false, null, false, "immutable", "default", "none", null);
        SchemaAttributeImpl members_ref = new SchemaAttributeImpl("$ref", "urn:ietf:params:scim:schemas:core:2.0:Group", "reference", null, false, "The URI corresponding to a SCIM resource that is a member of this Group.", false, null, false, "immutable", "default", "none", Arrays.asList("User", "Group"));
        SchemaAttributeImpl members_type = new SchemaAttributeImpl("type", "urn:ietf:params:scim:schemas:core:2.0:Group", "string", null, false, "A label indicating the type of resource, e.g., 'User' or 'Group'.", false, Arrays.asList("User", "Group"), false, "immutable", "default", "none", null);
        List<SchemaAttribute> subAttributes = Arrays.asList(members_value, members_ref, members_type);
        SchemaAttributeImpl members = new SchemaAttributeImpl("members", "urn:ietf:params:scim:schemas:core:2.0:Group", "complex", subAttributes, true, "description", false, null, false, "readWrite", "default", "none", null);
        rootAttributes.add(members);
        SchemaHandler.addToGroupAttributeMap(displayName);
        SchemaHandler.addToGroupAttributeMap(members);
        SchemaHandler.addToGroupAttributeMap(members_value);
        SchemaHandler.addToGroupAttributeMap(members_ref);
        SchemaHandler.addToGroupAttributeMap(members_type);
        SchemaImpl schema = new SchemaImpl();
        schema.setDescription("Group");
        schema.setId("urn:ietf:params:scim:schemas:core:2.0:Group");
        schema.setName("Group");
        schema.setAttributes(rootAttributes);
        SCHEMA_MAP.put("urn:ietf:params:scim:schemas:core:2.0:Group", schema);
    }

    private static void configureCoreUser() {
        ArrayList<SchemaAttribute> rootAttributes = new ArrayList<SchemaAttribute>();
        SchemaAttributeImpl userName = new SchemaAttributeImpl("userName", "urn:ietf:params:scim:schemas:core:2.0:User", "string", null, false, "description", true, null, false, "readWrite", "default", "server", null);
        rootAttributes.add(userName);
        SchemaAttributeImpl name_formatted = new SchemaAttributeImpl("formatted", "urn:ietf:params:scim:schemas:core:2.0:User", "string", null, false, "description", false, null, false, "readWrite", "default", "none", null);
        SchemaAttributeImpl name_familyName = new SchemaAttributeImpl("familyName", "urn:ietf:params:scim:schemas:core:2.0:User", "string", null, false, "description", false, null, false, "readWrite", "default", "none", null);
        SchemaAttributeImpl name_givenName = new SchemaAttributeImpl("givenName", "urn:ietf:params:scim:schemas:core:2.0:User", "string", null, false, "description", false, null, false, "readWrite", "default", "none", null);
        SchemaAttributeImpl name_middleName = new SchemaAttributeImpl("middleName", "urn:ietf:params:scim:schemas:core:2.0:User", "string", null, false, "description", false, null, false, "readWrite", "default", "none", null);
        SchemaAttributeImpl name_honorificPrefix = new SchemaAttributeImpl("honorificPrefix", "urn:ietf:params:scim:schemas:core:2.0:User", "string", null, false, "description", false, null, false, "readWrite", "default", "none", null);
        SchemaAttributeImpl name_honorificSuffix = new SchemaAttributeImpl("honorificSuffix", "urn:ietf:params:scim:schemas:core:2.0:User", "string", null, false, "description", false, null, false, "readWrite", "default", "none", null);
        List<SchemaAttribute> subAttributes = Arrays.asList(name_formatted, name_familyName, name_givenName, name_middleName, name_honorificPrefix, name_honorificSuffix);
        SchemaAttributeImpl name = new SchemaAttributeImpl("name", "urn:ietf:params:scim:schemas:core:2.0:User", "complex", subAttributes, false, "description", false, null, false, "readWrite", "default", "none", null);
        rootAttributes.add(name);
        SchemaHandler.addToUserAttributeMap(userName);
        SchemaHandler.addToUserAttributeMap(name);
        SchemaHandler.addToUserAttributeMap(name_formatted);
        SchemaHandler.addToUserAttributeMap(name_familyName);
        SchemaHandler.addToUserAttributeMap(name_givenName);
        SchemaHandler.addToUserAttributeMap(name_middleName);
        SchemaHandler.addToUserAttributeMap(name_honorificPrefix);
        SchemaHandler.addToUserAttributeMap(name_honorificSuffix);
        SchemaImpl schema = new SchemaImpl();
        schema.setDescription("User Account");
        schema.setId("urn:ietf:params:scim:schemas:core:2.0:User");
        schema.setName("User");
        schema.setAttributes(rootAttributes);
        SCHEMA_MAP.put("urn:ietf:params:scim:schemas:core:2.0:User", schema);
    }

    private static void configureEnterpriseUser() {
        ArrayList<SchemaAttribute> rootAttributes = new ArrayList<SchemaAttribute>();
        SchemaAttributeImpl employeeNumber = new SchemaAttributeImpl("employeeNumber", "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", "string", null, false, "Numeric or alphanumeric identifier assigned to a person, typically based on order of hire or association with an organization.", false, null, false, "readWrite", "default", "none", null);
        rootAttributes.add(employeeNumber);
        SchemaAttributeImpl costCenter = new SchemaAttributeImpl("costCenter", "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", "string", null, false, "Identifies the name of a cost center.", false, null, false, "readWrite", "default", "none", null);
        rootAttributes.add(costCenter);
        SchemaAttributeImpl organization = new SchemaAttributeImpl("organization", "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", "string", null, false, "Identifies the name of an organization.", false, null, false, "readWrite", "default", "none", null);
        rootAttributes.add(organization);
        SchemaAttributeImpl division = new SchemaAttributeImpl("division", "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", "string", null, false, "Identifies the name of a division.", false, null, false, "readWrite", "default", "none", null);
        rootAttributes.add(division);
        SchemaAttributeImpl department = new SchemaAttributeImpl("department", "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", "string", null, false, "Identifies the name of a department.", false, null, false, "readWrite", "default", "none", null);
        rootAttributes.add(department);
        SchemaAttributeImpl manager_value = new SchemaAttributeImpl("value", "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", "string", null, false, "The id of the SCIM resource representing the User's manager.  REQUIRED.", false, null, false, "immutable", "default", "none", null);
        SchemaAttributeImpl manager_ref = new SchemaAttributeImpl("$ref", "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", "reference", null, false, "The URI of the SCIM resource representing the User's manager.  REQUIRED.", false, null, false, "immutable", "default", "none", Arrays.asList("User", "Group"));
        SchemaAttributeImpl manager_displayName = new SchemaAttributeImpl("displayName", "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", "string", null, false, "The displayName of the User's manager. OPTIONAL and READ-ONLY.", false, Arrays.asList("User", "Group"), false, "immutable", "default", "none", null);
        List<SchemaAttribute> subAttributes = Arrays.asList(manager_value, manager_ref, manager_displayName);
        SchemaAttributeImpl manager = new SchemaAttributeImpl("manager", "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", "complex", subAttributes, false, "The User's manager. A complex type that optionally allows service providers to represent organizational hierarchy by referencing the 'id' attribute of another User.", false, null, false, "readWrite", "default", "none", null);
        rootAttributes.add(manager);
        SchemaHandler.addToUserAttributeMap(employeeNumber);
        SchemaHandler.addToUserAttributeMap(costCenter);
        SchemaHandler.addToUserAttributeMap(organization);
        SchemaHandler.addToUserAttributeMap(division);
        SchemaHandler.addToUserAttributeMap(department);
        SchemaHandler.addToUserAttributeMap(manager);
        SchemaHandler.addToUserAttributeMap(manager_value);
        SchemaHandler.addToUserAttributeMap(manager_ref);
        SchemaHandler.addToUserAttributeMap(manager_displayName);
        SchemaImpl schema = new SchemaImpl();
        schema.setDescription("Enterprise User");
        schema.setId("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User");
        schema.setName("EnterpriseUser");
        schema.setAttributes(rootAttributes);
        SCHEMA_MAP.put("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", schema);
    }

    public static SchemaAttributeImpl getGroupAttribute(String name) {
        return GROUP_ATTRIBUTE_MAP.get(name.toLowerCase());
    }

    public static Set<SchemaAttributeImpl> getGroupAttributeSetWithExclude(Set<String> exclude) {
        HashSet<SchemaAttributeImpl> attributes = new HashSet<SchemaAttributeImpl>(SchemaHandler.getGroupDefaultAttributeSet());
        for (String name : exclude) {
            SchemaAttributeImpl attribute = SchemaHandler.getGroupAttribute(name);
            if (attribute == null) continue;
            if (!"complex".equalsIgnoreCase(attribute.getType())) {
                attributes.remove(attribute);
                continue;
            }
            attributes.removeAll(attribute.getSubAttributes());
        }
        attributes.addAll(SchemaHandler.getGroupMinimumAttributeSet());
        return Collections.unmodifiableSet(attributes);
    }

    public static Set<SchemaAttributeImpl> getGroupAttributeSetWithInclude(Set<String> include) {
        HashSet<SchemaAttributeImpl> attributes = new HashSet<SchemaAttributeImpl>();
        for (String name : include) {
            SchemaAttributeImpl attribute = SchemaHandler.getGroupAttribute(name);
            if (attribute == null || "never".equalsIgnoreCase(attribute.getReturned())) continue;
            attributes.add(attribute);
        }
        attributes.addAll(SchemaHandler.getGroupMinimumAttributeSet());
        return Collections.unmodifiableSet(attributes);
    }

    static Set<SchemaAttributeImpl> getGroupDefaultAttributeSet() {
        HashSet<SchemaAttributeImpl> attributes = new HashSet<SchemaAttributeImpl>();
        for (SchemaAttributeImpl attribute : GROUP_ATTRIBUTE_MAP.values()) {
            if (!"default".equalsIgnoreCase(attribute.getReturned()) || "complex".equalsIgnoreCase(attribute.getType())) continue;
            attributes.add(attribute);
        }
        return Collections.unmodifiableSet(attributes);
    }

    static Set<SchemaAttributeImpl> getGroupMinimumAttributeSet() {
        HashSet<SchemaAttributeImpl> attributes = new HashSet<SchemaAttributeImpl>();
        for (SchemaAttributeImpl attribute : GROUP_ATTRIBUTE_MAP.values()) {
            if (!"always".equalsIgnoreCase(attribute.getReturned()) || "complex".equalsIgnoreCase(attribute.getType())) continue;
            attributes.add(attribute);
        }
        return Collections.unmodifiableSet(attributes);
    }

    public static Schema getSchema(String uri) {
        return SCHEMA_MAP.get(uri);
    }

    public static ListResponse<Schema> getSchemas() {
        ArrayList<SchemaImpl> schemas = new ArrayList<SchemaImpl>();
        for (SchemaImpl schema : SCHEMA_MAP.values()) {
            schemas.add(schema);
        }
        ListResponseImpl<Schema> response = new ListResponseImpl<Schema>();
        response.setTotalResults(SCHEMA_MAP.size());
        response.setItemsPerPage(10);
        response.setStartIndex(1);
        response.setResources(schemas);
        return response;
    }

    public static SchemaAttributeImpl getUserAttribute(String name) {
        return USER_ATTRIBUTE_MAP.get(name.toLowerCase());
    }

    public static Set<SchemaAttributeImpl> getUserAttributeSetWithExclude(Set<String> exclude) {
        HashSet<SchemaAttributeImpl> attributes = new HashSet<SchemaAttributeImpl>(SchemaHandler.getUserDefaultAttributeSet());
        for (String name : exclude) {
            SchemaAttributeImpl attribute = SchemaHandler.getUserAttribute(name);
            if (attribute == null) continue;
            if (!"complex".equalsIgnoreCase(attribute.getType())) {
                attributes.remove(attribute);
                continue;
            }
            attributes.removeAll(attribute.getSubAttributes());
        }
        attributes.addAll(SchemaHandler.getUserMinimumAttributeSet());
        return Collections.unmodifiableSet(attributes);
    }

    public static Set<SchemaAttributeImpl> getUserAttributeSetWithInclude(Set<String> include) {
        HashSet<SchemaAttributeImpl> attributes = new HashSet<SchemaAttributeImpl>();
        for (String name : include) {
            SchemaAttributeImpl attribute = SchemaHandler.getUserAttribute(name);
            if (attribute == null || "never".equalsIgnoreCase(attribute.getReturned())) continue;
            attributes.add(attribute);
        }
        attributes.addAll(SchemaHandler.getUserMinimumAttributeSet());
        return Collections.unmodifiableSet(attributes);
    }

    static Set<SchemaAttributeImpl> getUserDefaultAttributeSet() {
        HashSet<SchemaAttributeImpl> attributes = new HashSet<SchemaAttributeImpl>();
        for (SchemaAttributeImpl attribute : USER_ATTRIBUTE_MAP.values()) {
            if (!"default".equalsIgnoreCase(attribute.getReturned()) || "complex".equalsIgnoreCase(attribute.getType())) continue;
            attributes.add(attribute);
        }
        return Collections.unmodifiableSet(attributes);
    }

    static Set<SchemaAttributeImpl> getUserMinimumAttributeSet() {
        HashSet<SchemaAttributeImpl> attributes = new HashSet<SchemaAttributeImpl>();
        for (SchemaAttributeImpl attribute : USER_ATTRIBUTE_MAP.values()) {
            if (!"always".equalsIgnoreCase(attribute.getReturned()) || "complex".equalsIgnoreCase(attribute.getType())) continue;
            attributes.add(attribute);
        }
        return Collections.unmodifiableSet(attributes);
    }

    private static void configureWimUser() {
        ArrayList<SchemaAttribute> rootAttributes = new ArrayList<SchemaAttribute>();
        SchemaAttributeImpl identifier_uniqueId = new SchemaAttributeImpl("uniqueId", "urn:ietf:params:scim:schemas:extension:wim:2.0:User", "string", null, false, "", false, null, false, "immutable", "default", "none", null);
        SchemaAttributeImpl identifier_uniqueName = new SchemaAttributeImpl("uniqueName", "urn:ietf:params:scim:schemas:extension:wim:2.0:User", "string", null, false, "", false, null, false, "immutable", "default", "none", null);
        SchemaAttributeImpl identifier_externalId = new SchemaAttributeImpl("externalId", "urn:ietf:params:scim:schemas:extension:wim:2.0:User", "string", null, false, "", false, null, false, "immutable", "default", "none", null);
        SchemaAttributeImpl identifier_externalName = new SchemaAttributeImpl("externalName", "urn:ietf:params:scim:schemas:extension:wim:2.0:User", "string", null, false, "", false, null, false, "immutable", "default", "none", null);
        SchemaAttributeImpl identifier_repositoryId = new SchemaAttributeImpl("repositoryId", "urn:ietf:params:scim:schemas:extension:wim:2.0:User", "string", null, false, "", false, null, false, "immutable", "default", "none", null);
        List<SchemaAttribute> subAttributes = Arrays.asList(identifier_uniqueId, identifier_uniqueName, identifier_externalId, identifier_externalName, identifier_repositoryId);
        SchemaAttributeImpl identifier = new SchemaAttributeImpl("identifier", "urn:ietf:params:scim:schemas:extension:wim:2.0:User", "complex", subAttributes, false, "", false, null, false, "immutable", "default", "none", null);
        rootAttributes.add(identifier);
        SchemaAttributeImpl principalName = new SchemaAttributeImpl("principalName", "urn:ietf:params:scim:schemas:extension:wim:2.0:User", "string", null, false, "", false, null, false, "immutable", "default", "none", null);
        rootAttributes.add(principalName);
        SchemaAttributeImpl uid = new SchemaAttributeImpl("uid", "urn:ietf:params:scim:schemas:extension:wim:2.0:User", "string", null, false, "", false, null, false, "readWrite", "default", "none", null);
        rootAttributes.add(uid);
        SchemaAttributeImpl cn = new SchemaAttributeImpl("cn", "urn:ietf:params:scim:schemas:extension:wim:2.0:User", "string", null, false, "", false, null, false, "readWrite", "default", "none", null);
        rootAttributes.add(cn);
        SchemaAttributeImpl sn = new SchemaAttributeImpl("sn", "urn:ietf:params:scim:schemas:extension:wim:2.0:User", "string", null, false, "", false, null, false, "readWrite", "default", "none", null);
        rootAttributes.add(sn);
        SchemaAttributeImpl preferredLanguage = new SchemaAttributeImpl("preferredLanguage", "urn:ietf:params:scim:schemas:extension:wim:2.0:User", "string", null, false, "", false, null, false, "readWrite", "default", "none", null);
        rootAttributes.add(preferredLanguage);
        SchemaAttributeImpl displayName = new SchemaAttributeImpl("displayName", "urn:ietf:params:scim:schemas:extension:wim:2.0:User", "string", null, true, "", false, null, false, "readWrite", "default", "none", null);
        rootAttributes.add(displayName);
        SchemaAttributeImpl initials = new SchemaAttributeImpl("initials", "urn:ietf:params:scim:schemas:extension:wim:2.0:User", "string", null, true, "", false, null, false, "readWrite", "default", "none", null);
        rootAttributes.add(initials);
        SchemaAttributeImpl mail = new SchemaAttributeImpl("mail", "urn:ietf:params:scim:schemas:extension:wim:2.0:User", "string", null, false, "", false, null, false, "readWrite", "default", "none", null);
        rootAttributes.add(mail);
        SchemaHandler.addToUserAttributeMap(identifier);
        SchemaHandler.addToUserAttributeMap(identifier_uniqueId);
        SchemaHandler.addToUserAttributeMap(identifier_uniqueName);
        SchemaHandler.addToUserAttributeMap(identifier_externalId);
        SchemaHandler.addToUserAttributeMap(identifier_externalName);
        SchemaHandler.addToUserAttributeMap(identifier_repositoryId);
        SchemaHandler.addToUserAttributeMap(principalName);
        SchemaHandler.addToUserAttributeMap(uid);
        SchemaHandler.addToUserAttributeMap(cn);
        SchemaHandler.addToUserAttributeMap(sn);
        SchemaHandler.addToUserAttributeMap(preferredLanguage);
        SchemaHandler.addToUserAttributeMap(displayName);
        SchemaHandler.addToUserAttributeMap(initials);
        SchemaHandler.addToUserAttributeMap(mail);
        SchemaImpl schema = new SchemaImpl();
        schema.setDescription("WIM User Account Extension");
        schema.setId("urn:ietf:params:scim:schemas:extension:wim:2.0:User");
        schema.setName("WIM User");
        schema.setAttributes(rootAttributes);
        SCHEMA_MAP.put("urn:ietf:params:scim:schemas:extension:wim:2.0:User", schema);
    }

    public static void configureWimGroup() {
        ArrayList<SchemaAttribute> rootAttributes = new ArrayList<SchemaAttribute>();
        SchemaAttributeImpl identifier_uniqueId = new SchemaAttributeImpl("uniqueId", "urn:ietf:params:scim:schemas:extension:wim:2.0:Group", "string", null, false, "", false, null, false, "immutable", "default", "none", null);
        SchemaAttributeImpl identifier_uniqueName = new SchemaAttributeImpl("uniqueName", "urn:ietf:params:scim:schemas:extension:wim:2.0:Group", "string", null, false, "", false, null, false, "immutable", "default", "none", null);
        SchemaAttributeImpl identifier_externalId = new SchemaAttributeImpl("externalId", "urn:ietf:params:scim:schemas:extension:wim:2.0:Group", "string", null, false, "", false, null, false, "immutable", "default", "none", null);
        SchemaAttributeImpl identifier_externalName = new SchemaAttributeImpl("externalName", "urn:ietf:params:scim:schemas:extension:wim:2.0:Group", "string", null, false, "", false, null, false, "immutable", "default", "none", null);
        SchemaAttributeImpl identifier_repositoryId = new SchemaAttributeImpl("repositoryId", "urn:ietf:params:scim:schemas:extension:wim:2.0:Group", "string", null, false, "", false, null, false, "immutable", "default", "none", null);
        List<SchemaAttribute> subAttributes = Arrays.asList(identifier_uniqueId, identifier_uniqueName, identifier_externalId, identifier_externalName, identifier_repositoryId);
        SchemaAttributeImpl identifier = new SchemaAttributeImpl("identifier", "urn:ietf:params:scim:schemas:extension:wim:2.0:Group", "complex", subAttributes, false, "", false, null, false, "immutable", "default", "none", null);
        rootAttributes.add(identifier);
        SchemaHandler.addToGroupAttributeMap(identifier);
        SchemaHandler.addToGroupAttributeMap(identifier_uniqueId);
        SchemaHandler.addToGroupAttributeMap(identifier_uniqueName);
        SchemaHandler.addToGroupAttributeMap(identifier_externalId);
        SchemaHandler.addToGroupAttributeMap(identifier_externalName);
        SchemaHandler.addToGroupAttributeMap(identifier_repositoryId);
        SchemaImpl schema = new SchemaImpl();
        schema.setDescription("WIM Group Extension");
        schema.setId("urn:ietf:params:scim:schemas:extension:wim:2.0:Group");
        schema.setName("WIM Group");
        schema.setAttributes(rootAttributes);
        SCHEMA_MAP.put("urn:ietf:params:scim:schemas:extension:wim:2.0:Group", schema);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.wim.scim20.SchemaHandler", SchemaHandler.class, (String)"SCIM20", (String)"com.ibm.ws.security.wim.scim20.resources.SCIMUtilMessages");
        GROUP_ATTRIBUTE_MAP = new HashMap<String, SchemaAttributeImpl>();
        SCHEMA_MAP = new HashMap<String, SchemaImpl>();
        USER_ATTRIBUTE_MAP = new HashMap<String, SchemaAttributeImpl>();
        SchemaHandler.configureCoreUser();
        SchemaHandler.configureCoreGroup();
        SchemaHandler.configureEnterpriseUser();
        SchemaHandler.configureWimUser();
        SchemaHandler.configureWimGroup();
    }
}

