/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import jakarta.annotation.CheckForNull;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private static final byte ABSENT = -1;
    private static final int BYTE_MAX_SIZE = 128;
    private static final int SHORT_MAX_SIZE = 32768;
    private static final int BYTE_MASK = 255;
    private static final int SHORT_MASK = 65535;
    static final ImmutableMap<Object, Object> EMPTY = new RegularImmutableMap<Object, Object>(null, new Object[0], 0);
    @CheckForNull
    private final transient Object hashTable;
    @VisibleForTesting
    final transient @Nullable Object[] alternatingKeysAndValues;
    private final transient int size;
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;

    static <K, V> RegularImmutableMap<K, V> create(int n, @Nullable Object[] alternatingKeysAndValues) {
        return RegularImmutableMap.create(n, alternatingKeysAndValues, null);
    }

    static <K, V> RegularImmutableMap<K, V> create(int n, @Nullable Object[] alternatingKeysAndValues, @Nullable ImmutableMap.Builder<K, V> builder) {
        Object hashTable;
        if (n == 0) {
            RegularImmutableMap empty = (RegularImmutableMap)EMPTY;
            return empty;
        }
        if (n == 1) {
            CollectPreconditions.checkEntryNotNull(Objects.requireNonNull(alternatingKeysAndValues[0]), Objects.requireNonNull(alternatingKeysAndValues[1]));
            return new RegularImmutableMap<K, V>(null, alternatingKeysAndValues, 1);
        }
        Preconditions.checkPositionIndex(n, alternatingKeysAndValues.length >> 1);
        int tableSize = ImmutableSet.chooseTableSize(n);
        Object hashTablePlus = RegularImmutableMap.createHashTable(alternatingKeysAndValues, n, tableSize, 0);
        if (hashTablePlus instanceof Object[]) {
            Object[] hashTableAndSizeAndDuplicate = (Object[])hashTablePlus;
            ImmutableMap.Builder.DuplicateKey duplicateKey = (ImmutableMap.Builder.DuplicateKey)hashTableAndSizeAndDuplicate[2];
            if (builder == null) {
                throw duplicateKey.exception();
            }
            builder.duplicateKey = duplicateKey;
            hashTable = hashTableAndSizeAndDuplicate[0];
            n = (Integer)hashTableAndSizeAndDuplicate[1];
            alternatingKeysAndValues = Arrays.copyOf(alternatingKeysAndValues, n * 2);
        } else {
            hashTable = hashTablePlus;
        }
        return new RegularImmutableMap<K, V>(hashTable, alternatingKeysAndValues, n);
    }

    @CheckForNull
    private static Object createHashTable(@Nullable Object[] alternatingKeysAndValues, int n, int tableSize, int keyOffset) {
        Object[] objectArray;
        if (n == 1) {
            CollectPreconditions.checkEntryNotNull(Objects.requireNonNull(alternatingKeysAndValues[keyOffset]), Objects.requireNonNull(alternatingKeysAndValues[keyOffset ^ 1]));
            return null;
        }
        int mask = tableSize - 1;
        ImmutableMap.Builder.DuplicateKey duplicateKey = null;
        if (tableSize <= 128) {
            Object[] objectArray2;
            byte[] hashTable = new byte[tableSize];
            Arrays.fill(hashTable, (byte)-1);
            int outI = 0;
            block0: for (int i = 0; i < n; ++i) {
                int keyIndex = 2 * i + keyOffset;
                int outKeyIndex = 2 * outI + keyOffset;
                Object key = Objects.requireNonNull(alternatingKeysAndValues[keyIndex]);
                Object value = Objects.requireNonNull(alternatingKeysAndValues[keyIndex ^ 1]);
                CollectPreconditions.checkEntryNotNull(key, value);
                int h = Hashing.smear(key.hashCode());
                while (true) {
                    int previousKeyIndex;
                    if ((previousKeyIndex = hashTable[h &= mask] & 0xFF) == 255) break;
                    if (key.equals(alternatingKeysAndValues[previousKeyIndex])) {
                        duplicateKey = new ImmutableMap.Builder.DuplicateKey(key, value, Objects.requireNonNull(alternatingKeysAndValues[previousKeyIndex ^ 1]));
                        alternatingKeysAndValues[previousKeyIndex ^ 1] = value;
                        continue block0;
                    }
                    ++h;
                }
                hashTable[h] = (byte)outKeyIndex;
                if (outI < i) {
                    alternatingKeysAndValues[outKeyIndex] = key;
                    alternatingKeysAndValues[outKeyIndex ^ 1] = value;
                }
                ++outI;
            }
            if (outI == n) {
                objectArray2 = hashTable;
            } else {
                Object[] objectArray3 = new Object[3];
                objectArray3[0] = hashTable;
                objectArray3[1] = outI;
                objectArray2 = objectArray3;
                objectArray3[2] = duplicateKey;
            }
            return objectArray2;
        }
        if (tableSize <= 32768) {
            Object[] objectArray4;
            short[] hashTable = new short[tableSize];
            Arrays.fill(hashTable, (short)-1);
            int outI = 0;
            block2: for (int i = 0; i < n; ++i) {
                int keyIndex = 2 * i + keyOffset;
                int outKeyIndex = 2 * outI + keyOffset;
                Object key = Objects.requireNonNull(alternatingKeysAndValues[keyIndex]);
                Object value = Objects.requireNonNull(alternatingKeysAndValues[keyIndex ^ 1]);
                CollectPreconditions.checkEntryNotNull(key, value);
                int h = Hashing.smear(key.hashCode());
                while (true) {
                    int previousKeyIndex;
                    if ((previousKeyIndex = hashTable[h &= mask] & 0xFFFF) == 65535) break;
                    if (key.equals(alternatingKeysAndValues[previousKeyIndex])) {
                        duplicateKey = new ImmutableMap.Builder.DuplicateKey(key, value, Objects.requireNonNull(alternatingKeysAndValues[previousKeyIndex ^ 1]));
                        alternatingKeysAndValues[previousKeyIndex ^ 1] = value;
                        continue block2;
                    }
                    ++h;
                }
                hashTable[h] = (short)outKeyIndex;
                if (outI < i) {
                    alternatingKeysAndValues[outKeyIndex] = key;
                    alternatingKeysAndValues[outKeyIndex ^ 1] = value;
                }
                ++outI;
            }
            if (outI == n) {
                objectArray4 = hashTable;
            } else {
                Object[] objectArray5 = new Object[3];
                objectArray5[0] = hashTable;
                objectArray5[1] = outI;
                objectArray4 = objectArray5;
                objectArray5[2] = duplicateKey;
            }
            return objectArray4;
        }
        int[] hashTable = new int[tableSize];
        Arrays.fill(hashTable, -1);
        int outI = 0;
        block4: for (int i = 0; i < n; ++i) {
            int keyIndex = 2 * i + keyOffset;
            int outKeyIndex = 2 * outI + keyOffset;
            Object key = Objects.requireNonNull(alternatingKeysAndValues[keyIndex]);
            Object value = Objects.requireNonNull(alternatingKeysAndValues[keyIndex ^ 1]);
            CollectPreconditions.checkEntryNotNull(key, value);
            int h = Hashing.smear(key.hashCode());
            while (true) {
                int previousKeyIndex;
                if ((previousKeyIndex = hashTable[h &= mask]) == -1) break;
                if (key.equals(alternatingKeysAndValues[previousKeyIndex])) {
                    duplicateKey = new ImmutableMap.Builder.DuplicateKey(key, value, Objects.requireNonNull(alternatingKeysAndValues[previousKeyIndex ^ 1]));
                    alternatingKeysAndValues[previousKeyIndex ^ 1] = value;
                    continue block4;
                }
                ++h;
            }
            hashTable[h] = outKeyIndex;
            if (outI < i) {
                alternatingKeysAndValues[outKeyIndex] = key;
                alternatingKeysAndValues[outKeyIndex ^ 1] = value;
            }
            ++outI;
        }
        if (outI == n) {
            objectArray = hashTable;
        } else {
            Object[] objectArray6 = new Object[3];
            objectArray6[0] = hashTable;
            objectArray6[1] = outI;
            objectArray = objectArray6;
            objectArray6[2] = duplicateKey;
        }
        return objectArray;
    }

    @CheckForNull
    static Object createHashTableOrThrow(@Nullable Object[] alternatingKeysAndValues, int n, int tableSize, int keyOffset) {
        Object hashTablePlus = RegularImmutableMap.createHashTable(alternatingKeysAndValues, n, tableSize, keyOffset);
        if (hashTablePlus instanceof Object[]) {
            Object[] hashTableAndSizeAndDuplicate = (Object[])hashTablePlus;
            ImmutableMap.Builder.DuplicateKey duplicateKey = (ImmutableMap.Builder.DuplicateKey)hashTableAndSizeAndDuplicate[2];
            throw duplicateKey.exception();
        }
        return hashTablePlus;
    }

    private RegularImmutableMap(@CheckForNull Object hashTable, @Nullable Object[] alternatingKeysAndValues, int size) {
        this.hashTable = hashTable;
        this.alternatingKeysAndValues = alternatingKeysAndValues;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object key) {
        Object result = RegularImmutableMap.get(this.hashTable, this.alternatingKeysAndValues, this.size, 0, key);
        if (result == null) {
            return null;
        }
        return (V)result;
    }

    @CheckForNull
    static Object get(@CheckForNull Object hashTableObject, @Nullable Object[] alternatingKeysAndValues, int size, int keyOffset, @CheckForNull Object key) {
        if (key == null) {
            return null;
        }
        if (size == 1) {
            return Objects.requireNonNull(alternatingKeysAndValues[keyOffset]).equals(key) ? Objects.requireNonNull(alternatingKeysAndValues[keyOffset ^ 1]) : null;
        }
        if (hashTableObject == null) {
            return null;
        }
        if (hashTableObject instanceof byte[]) {
            byte[] hashTable = (byte[])hashTableObject;
            int mask = hashTable.length - 1;
            int h = Hashing.smear(key.hashCode());
            while (true) {
                int keyIndex;
                if ((keyIndex = hashTable[h &= mask] & 0xFF) == 255) {
                    return null;
                }
                if (key.equals(alternatingKeysAndValues[keyIndex])) {
                    return alternatingKeysAndValues[keyIndex ^ 1];
                }
                ++h;
            }
        }
        if (hashTableObject instanceof short[]) {
            short[] hashTable = (short[])hashTableObject;
            int mask = hashTable.length - 1;
            int h = Hashing.smear(key.hashCode());
            while (true) {
                int keyIndex;
                if ((keyIndex = hashTable[h &= mask] & 0xFFFF) == 65535) {
                    return null;
                }
                if (key.equals(alternatingKeysAndValues[keyIndex])) {
                    return alternatingKeysAndValues[keyIndex ^ 1];
                }
                ++h;
            }
        }
        int[] hashTable = (int[])hashTableObject;
        int mask = hashTable.length - 1;
        int h = Hashing.smear(key.hashCode());
        int keyIndex;
        while ((keyIndex = hashTable[h &= mask]) != -1) {
            if (key.equals(alternatingKeysAndValues[keyIndex])) {
                return alternatingKeysAndValues[keyIndex ^ 1];
            }
            ++h;
        }
        return null;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new EntrySet(this, this.alternatingKeysAndValues, 0, this.size);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        KeysOrValuesAsList keyList = new KeysOrValuesAsList(this.alternatingKeysAndValues, 0, this.size);
        return new KeySet<Object>(this, keyList);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new KeysOrValuesAsList(this.alternatingKeysAndValues, 1, this.size);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    static final class KeySet<K>
    extends ImmutableSet<K> {
        private final transient ImmutableMap<K, ?> map;
        private final transient ImmutableList<K> list;

        KeySet(ImmutableMap<K, ?> map, ImmutableList<K> list) {
            this.map = map;
            this.list = list;
        }

        @Override
        public UnmodifiableIterator<K> iterator() {
            return this.asList().iterator();
        }

        @Override
        int copyIntoArray(Object[] dst, int offset) {
            return this.asList().copyIntoArray(dst, offset);
        }

        @Override
        public ImmutableList<K> asList() {
            return this.list;
        }

        @Override
        public boolean contains(@CheckForNull Object object) {
            return this.map.get(object) != null;
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    static final class KeysOrValuesAsList
    extends ImmutableList<Object> {
        private final transient @Nullable Object[] alternatingKeysAndValues;
        private final transient int offset;
        private final transient int size;

        KeysOrValuesAsList(@Nullable Object[] alternatingKeysAndValues, int offset, int size) {
            this.alternatingKeysAndValues = alternatingKeysAndValues;
            this.offset = offset;
            this.size = size;
        }

        @Override
        public Object get(int index) {
            Preconditions.checkElementIndex(index, this.size);
            return Objects.requireNonNull(this.alternatingKeysAndValues[2 * index + this.offset]);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    static class EntrySet<K, V>
    extends ImmutableSet<Map.Entry<K, V>> {
        private final transient ImmutableMap<K, V> map;
        private final transient @Nullable Object[] alternatingKeysAndValues;
        private final transient int keyOffset;
        private final transient int size;

        EntrySet(ImmutableMap<K, V> map, @Nullable Object[] alternatingKeysAndValues, int keyOffset, int size) {
            this.map = map;
            this.alternatingKeysAndValues = alternatingKeysAndValues;
            this.keyOffset = keyOffset;
            this.size = size;
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.asList().iterator();
        }

        @Override
        int copyIntoArray(Object[] dst, int offset) {
            return this.asList().copyIntoArray(dst, offset);
        }

        @Override
        ImmutableList<Map.Entry<K, V>> createAsList() {
            return new ImmutableList<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> get(int index) {
                    Preconditions.checkElementIndex(index, size);
                    Object key = Objects.requireNonNull(alternatingKeysAndValues[2 * index + keyOffset]);
                    Object value = Objects.requireNonNull(alternatingKeysAndValues[2 * index + (keyOffset ^ 1)]);
                    return new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value);
                }

                @Override
                public int size() {
                    return size;
                }

                @Override
                public boolean isPartialView() {
                    return true;
                }
            };
        }

        @Override
        public boolean contains(@CheckForNull Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object v = entry.getValue();
                return v != null && v.equals(this.map.get(k));
            }
            return false;
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

