/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.metadata.AcsDOMMetadataProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.metadata.resolver.impl.PredicateRoleDescriptorResolver;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.security.x509.impl.BasicPKIXValidationInformation;
import org.opensaml.security.x509.impl.BasicX509CredentialNameEvaluator;
import org.opensaml.security.x509.impl.StaticPKIXValidationInformationResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.PKIXSignatureTrustEngine;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MsgCtxUtil<InboundMessageType extends SAMLObject, OutboundMessageType extends SAMLObject, NameIdentifierType extends SAMLObject> {
    private static TraceComponent tc = Tr.register(MsgCtxUtil.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    static MsgCtxUtil<?, ?, ?> instance = new MsgCtxUtil();
    static final long serialVersionUID = -4413678121828706961L;

    public static MsgCtxUtil<?, ?, ?> getInstance() {
        return instance;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AcsDOMMetadataProvider parseIdpMetadataProvider(SsoConfig samlConfig) throws SamlException {
        AcsDOMMetadataProvider acsIdpMetadataProvider = null;
        String strIdpMetadata = samlConfig.getIdpMetadata();
        if (strIdpMetadata != null && !strIdpMetadata.isEmpty()) {
            final File fileIdpMetadata = new File(strIdpMetadata);
            InputStream inputStream = null;
            ParserPool parserPool = XMLObjectProviderRegistrySupport.getParserPool();
            try {
                inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                    static final long serialVersionUID = -7645066519357773928L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Object run() throws Exception {
                        if (fileIdpMetadata.exists()) {
                            return new FileInputStream(fileIdpMetadata);
                        }
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.saml.sso20.internal.utils.MsgCtxUtil$1", 1.class, null, null);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                void e;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.saml.sso20.internal.utils.MsgCtxUtil", (String)"108", null, (Object[])new Object[]{samlConfig});
                Exception newe = e.getException();
                if (newe instanceof FileNotFoundException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Provider error MetadataFile:" + strIdpMetadata), (Object[])new Object[]{newe});
                    }
                    throw new SamlException("SAML20_NO_IDP_METADATA_ERROR", newe, new Object[]{strIdpMetadata, samlConfig.getProviderId(), newe.getMessage()});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("unexpected Provider error MetadataFile:" + strIdpMetadata), (Object[])new Object[]{e, newe});
                }
                throw new SamlException("SAML20_IDP_METADATA_PARSE_ERROR", newe, new Object[]{strIdpMetadata, samlConfig.getProviderId(), newe.getMessage()});
            }
            Document doc = null;
            if (inputStream != null && parserPool != null) {
                block18: {
                    try {
                        doc = parserPool.parse(inputStream);
                        if (inputStream == null) break block18;
                    }
                    catch (XMLParserException e) {
                        try {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.internal.utils.MsgCtxUtil", (String)"141", null, (Object[])new Object[]{samlConfig});
                            throw new SamlException("SAML20_IDP_METADATA_PARSE_ERROR", (Exception)((Object)e), new Object[]{strIdpMetadata, samlConfig.getProviderId(), e.getMessage()});
                        }
                        catch (Throwable throwable) {
                            if (inputStream == null) throw throwable;
                            try {
                                inputStream.close();
                                throw throwable;
                            }
                            catch (IOException iOException) {
                                void e2;
                                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.saml.sso20.internal.utils.MsgCtxUtil", (String)"150", null, (Object[])new Object[]{samlConfig});
                                if (!tc.isDebugEnabled()) throw throwable;
                                Tr.debug((TraceComponent)tc, (String)("Can not close InputStream of MetadataFile:" + strIdpMetadata), (Object[])new Object[]{e2});
                            }
                            throw throwable;
                        }
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException newe) {
                        FFDCFilter.processException((Throwable)newe, (String)"com.ibm.ws.security.saml.sso20.internal.utils.MsgCtxUtil", (String)"150", null, (Object[])new Object[]{samlConfig});
                        if (!tc.isDebugEnabled()) break block18;
                        Tr.debug((TraceComponent)tc, (String)("Can not close InputStream of MetadataFile:" + strIdpMetadata), (Object[])new Object[]{e});
                    }
                }
                if (doc == null) return acsIdpMetadataProvider;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"document = ", (Object[])new Object[]{SerializeSupport.nodeToString((Node)doc)});
                }
                acsIdpMetadataProvider = new AcsDOMMetadataProvider(doc.getDocumentElement(), fileIdpMetadata);
                try {
                    acsIdpMetadataProvider.setId(samlConfig.getProviderId());
                    acsIdpMetadataProvider.initialize();
                    return acsIdpMetadataProvider;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.internal.utils.MsgCtxUtil", (String)"166", null, (Object[])new Object[]{samlConfig});
                    throw new SamlException("SAML20_IDP_METADATA_PARSE_ERROR", e, new Object[]{strIdpMetadata, samlConfig.getProviderId(), e.getMessage()});
                }
            }
            String error = Tr.formatMessage((TraceComponent)tc, (String)"SAML20_IDP_METADATA_PARSE_ERROR", (Object[])new Object[]{strIdpMetadata, samlConfig.getProviderId(), "no metadata"});
            throw new SamlException(error, (Exception)new NullPointerException(), true);
        }
        if (!tc.isDebugEnabled()) return acsIdpMetadataProvider;
        Tr.debug((TraceComponent)tc, (String)("The idpMetadataFile in " + samlConfig.getProviderId() + " is null. This has to define the trustStore to verify the signature in SAML Response"), (Object[])new Object[0]);
        return acsIdpMetadataProvider;
    }

    public static TrustEngine<Signature> getTrustedEngine(BasicMessageContext<?, ?> context) throws SamlException {
        SsoConfig ssoConfig = context.getSsoConfig();
        if (!ssoConfig.isPkixTrustEngineEnabled()) {
            return MsgCtxUtil.getTrustedEngineFromMetadata(context);
        }
        return MsgCtxUtil.getTrustedEngineFromPkix(context);
    }

    public static TrustEngine<Signature> getTrustedEngineFromMetadata(BasicMessageContext<?, ?> context) {
        AcsDOMMetadataProvider metadataProvider = context.getMetadataProvider();
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)metadataProvider);
        try {
            roleResolver.initialize();
        }
        catch (ComponentInitializationException componentInitializationException) {
            FFDCFilter.processException((Throwable)componentInitializationException, (String)"com.ibm.ws.security.saml.sso20.internal.utils.MsgCtxUtil", (String)"206", null, (Object[])new Object[]{context});
        }
        MetadataCredentialResolver mdCredResolver = new MetadataCredentialResolver();
        mdCredResolver.setRoleDescriptorResolver((RoleDescriptorResolver)roleResolver);
        mdCredResolver.setKeyInfoCredentialResolver(MsgCtxUtil.getKeyInfoCredResolver());
        try {
            mdCredResolver.initialize();
        }
        catch (ComponentInitializationException componentInitializationException) {
            FFDCFilter.processException((Throwable)componentInitializationException, (String)"com.ibm.ws.security.saml.sso20.internal.utils.MsgCtxUtil", (String)"215", null, (Object[])new Object[]{context});
        }
        ExplicitKeySignatureTrustEngine engine = new ExplicitKeySignatureTrustEngine((CredentialResolver)mdCredResolver, MsgCtxUtil.getKeyInfoCredResolver());
        return engine;
    }

    public static TrustEngine<Signature> getTrustedEngineFromPkix(BasicMessageContext<?, ?> context) throws SamlException {
        SsoConfig ssoConfig = context.getSsoConfig();
        Collection<X509Certificate> x509Certs = ssoConfig.getPkixTrustAnchors();
        Collection<X509CRL> x509CRLs = ssoConfig.getX509Crls();
        BasicPKIXValidationInformation pkixValidationInformation = new BasicPKIXValidationInformation(x509Certs, x509CRLs, Integer.valueOf(20));
        ArrayList<BasicPKIXValidationInformation> infos = new ArrayList<BasicPKIXValidationInformation>();
        HashSet names = new HashSet();
        infos.add(pkixValidationInformation);
        StaticPKIXValidationInformationResolver pkixValidationInfoResolver = new StaticPKIXValidationInformationResolver(infos, names);
        PKIXSignatureTrustEngine pkixSignatureTrustEngine = new PKIXSignatureTrustEngine((PKIXValidationInformationResolver)pkixValidationInfoResolver, MsgCtxUtil.getKeyInfoCredResolver());
        BasicX509CredentialNameEvaluator x509CredentialEvaluator = (BasicX509CredentialNameEvaluator)pkixSignatureTrustEngine.getX509CredentialNameEvaluator();
        x509CredentialEvaluator.setCheckSubjectAltNames(false);
        x509CredentialEvaluator.setCheckSubjectDN(false);
        x509CredentialEvaluator.setCheckSubjectDNCommonName(false);
        return pkixSignatureTrustEngine;
    }

    static KeyInfoCredentialResolver getKeyInfoCredResolver() {
        InlineX509DataProvider x509DataProvider = new InlineX509DataProvider();
        ArrayList<InlineX509DataProvider> providers = new ArrayList<InlineX509DataProvider>();
        providers.add(x509DataProvider);
        BasicProviderKeyInfoCredentialResolver keyInfoCredResolver = new BasicProviderKeyInfoCredentialResolver(providers);
        return keyInfoCredResolver;
    }

    public static boolean validateIssuer(Issuer samlIssuer, BasicMessageContext<?, ?> context, boolean isRsSaml) throws SamlException {
        EntityDescriptor peerEntityMetadata;
        if (samlIssuer.getFormat() != null && !samlIssuer.getFormat().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            throw new SamlException("SAML20_NO_ISSUER_ERR", null, new Object[]{"urn:oasis:names:tc:SAML:2.0:nameid-format:entity", samlIssuer.getFormat()});
        }
        EntityDescriptor entityDescriptor = peerEntityMetadata = isRsSaml ? null : context.getPeerEntityMetadata();
        if (peerEntityMetadata == null) {
            if (!MsgCtxUtil.tryTrustedIssuers(samlIssuer, context)) {
                throw new SamlException("SAML20_INCORRECT_ISSUER_ERR", null, new Object[]{samlIssuer.getValue()});
            }
            return true;
        }
        if (!peerEntityMetadata.getEntityID().equals(samlIssuer.getValue()) && !MsgCtxUtil.tryTrustedIssuers(samlIssuer, context)) {
            throw new SamlException("SAML20_INCORRECT_ISSUER_ERR", null, new Object[]{samlIssuer.getValue()});
        }
        return true;
    }

    static boolean tryTrustedIssuers(Issuer samlIssuer, BasicMessageContext<?, ?> context) {
        String issuer = samlIssuer.getValue();
        SsoConfig ssoConfig = context.getSsoConfig();
        String[] trustedIssuers = ssoConfig.getPkixTrustedIssuers();
        if (trustedIssuers != null) {
            for (String trustedIssuer : trustedIssuers) {
                if ("ALL_ISSUERS".equals(trustedIssuer)) {
                    return true;
                }
                if (!trustedIssuer.equals(issuer)) continue;
                return true;
            }
        }
        return false;
    }
}

