/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.ibm.json.java.JSONObject;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.error.impl.BrowserAndServerLogMessage;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebUtils {
    private static TraceComponent tc = Tr.register(WebUtils.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    static final long serialVersionUID = -3633479442662039800L;

    public static void sendErrorJSON(HttpServletResponse response, int statusCode, String errorCode, String errorDescription) {
        WebUtils.sendErrorJSON(response, statusCode, errorCode, errorDescription, null, false);
    }

    public static void sendErrorJSON(HttpServletResponse response, int statusCode, String errorCode, String errorDescription, String authScheme) {
        WebUtils.sendErrorJSON(response, statusCode, errorCode, errorDescription, authScheme, false);
    }

    public static void sendErrorJSON(HttpServletResponse response, int statusCode, String errorCode, String errorDescription, boolean suppressBasicAuthChallenge) {
        WebUtils.sendErrorJSON(response, statusCode, errorCode, errorDescription, null, suppressBasicAuthChallenge);
    }

    /*
     * WARNING - void declaration
     */
    public static void sendErrorJSON(HttpServletResponse response, int statusCode, String errorCode, String errorDescription, String authScheme, boolean suppressBasicAuthChallenge) {
        block13: {
            String error = "error";
            String error_description = "error_description";
            try {
                if (errorCode != null) {
                    response.setStatus(statusCode);
                    response.setHeader("Content-Type", "application/json;charset=UTF-8");
                    if (statusCode == 401) {
                        if (authScheme == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Authentication scheme was null, will default to basic if not suppressed.", (Object[])new Object[0]);
                            }
                            authScheme = "Basic";
                        }
                        String errMsg = authScheme + " " + "error" + "=\"" + errorCode + "\", " + "error_description" + "=\"" + errorDescription + "\", realm=\"\"";
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Error code:" + statusCode + " errMsg=" + errMsg + " response already committed: " + response.isCommitted()), (Object[])new Object[0]);
                        }
                        if (!suppressBasicAuthChallenge && !response.isCommitted()) {
                            response.setHeader("WWW-Authenticate", errMsg);
                        }
                    }
                    JSONObject responseJSON = new JSONObject();
                    responseJSON.put((Object)"error", (Object)errorCode);
                    if (errorDescription != null) {
                        responseJSON.put((Object)"error_description", (Object)errorDescription);
                    }
                    PrintWriter pw = response.getWriter();
                    pw.write(responseJSON.toString());
                    pw.flush();
                } else {
                    response.sendError(statusCode);
                }
            }
            catch (IOException responseJSON) {
                FFDCFilter.processException((Throwable)responseJSON, (String)"com.ibm.ws.security.oauth20.web.WebUtils", (String)"122", null, (Object[])new Object[]{response, statusCode, errorCode, errorDescription, authScheme, suppressBasicAuthChallenge});
                if (tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)"Internal error processing token introspect request", (Object[])new Object[]{e});
                }
                try {
                    response.sendError(500);
                }
                catch (IOException pw) {
                    void ioe;
                    FFDCFilter.processException((Throwable)pw, (String)"com.ibm.ws.security.oauth20.web.WebUtils", (String)"127", null, (Object[])new Object[]{response, statusCode, errorCode, errorDescription, authScheme, suppressBasicAuthChallenge});
                    if (!tc.isDebugEnabled()) break block13;
                    Tr.debug((TraceComponent)tc, (String)"Internal error process token introspect request error", (Object[])new Object[]{ioe});
                }
            }
        }
    }

    public static void setJSONResponse(HttpServletResponse response, int statusCode, JSONObject jsonObj) {
        String jsonStr = null;
        if (jsonObj != null) {
            jsonStr = jsonObj.toString();
        }
        WebUtils.setJSONResponse(response, statusCode, jsonStr);
    }

    /*
     * WARNING - void declaration
     */
    public static void setJSONResponse(HttpServletResponse response, int statusCode, String jsonStr) {
        block6: {
            try {
                String cacheControlValue = response.getHeader("Cache-Control");
                cacheControlValue = cacheControlValue != null && !cacheControlValue.isEmpty() ? cacheControlValue + ", " + "no-store" : "no-store";
                response.setHeader("Cache-Control", cacheControlValue);
                response.setHeader("Pragma", "no-cache");
                response.setStatus(statusCode);
                if (jsonStr != null) {
                    response.setHeader("Content-Type", "application/json;charset=UTF-8");
                    PrintWriter pw = response.getWriter();
                    pw.write(jsonStr);
                    pw.flush();
                }
            }
            catch (IOException cacheControlValue) {
                FFDCFilter.processException((Throwable)cacheControlValue, (String)"com.ibm.ws.security.oauth20.web.WebUtils", (String)"179", null, (Object[])new Object[]{response, statusCode, jsonStr});
                if (tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)"Internal error processing token introspect request", (Object[])new Object[]{e});
                }
                try {
                    response.sendError(500);
                }
                catch (IOException pw) {
                    void ioe;
                    FFDCFilter.processException((Throwable)pw, (String)"com.ibm.ws.security.oauth20.web.WebUtils", (String)"184", null, (Object[])new Object[]{response, statusCode, jsonStr});
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)"Internal error process token introspect request error", (Object[])new Object[]{ioe});
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String encode(String text, Locale locale, String encoding) {
        String encodedText;
        block2: {
            encodedText = text;
            try {
                encodedText = URLEncoder.encode(text, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                void e1;
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.oauth20.web.WebUtils", (String)"203", null, (Object[])new Object[]{text, locale, encoding});
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Internal error encoding text", (Object[])new Object[]{e1});
            }
        }
        return encodedText;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] encode(String[] textArray, Locale locale, String encoding) {
        String[] encodedTextArray = null;
        if (textArray != null) {
            encodedTextArray = new String[textArray.length];
            int i = 0;
            for (String text : textArray) {
                block4: {
                    try {
                        encodedTextArray[i] = URLEncoder.encode(text, encoding);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        void e1;
                        FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.oauth20.web.WebUtils", (String)"226", null, (Object[])new Object[]{textArray, locale, encoding});
                        if (!tc.isDebugEnabled()) break block4;
                        Tr.debug((TraceComponent)tc, (String)"Internal error encoding text", (Object[])new Object[]{e1});
                    }
                }
                ++i;
            }
        }
        return encodedTextArray;
    }

    public static String htmlEncode(String string) {
        return WebUtils.htmlEncode(string, true, true, true);
    }

    public static String htmlEncode(String string, boolean encodeNewline, boolean encodeSubsequentBlanksToNbsp, boolean encodeNonLatin) {
        if (string == null) {
            return "";
        }
        StringBuilder sb = null;
        for (int i = 0; i < string.length(); ++i) {
            char c;
            String app;
            block30: {
                block29: {
                    app = null;
                    c = string.charAt(i);
                    if (c >= 'A') break block29;
                    switch (c) {
                        case '\"': {
                            app = "&quot;";
                            break;
                        }
                        case '&': {
                            app = "&amp;";
                            break;
                        }
                        case '<': {
                            app = "&lt;";
                            break;
                        }
                        case '>': {
                            app = "&gt;";
                            break;
                        }
                        case ' ': {
                            if (encodeSubsequentBlanksToNbsp && (i == 0 || i - 1 >= 0 && string.charAt(i - 1) == ' ')) {
                                app = "&#160;";
                                break;
                            }
                            break block30;
                        }
                        case '\n': {
                            if (encodeNewline) {
                                app = "<br/>";
                                break;
                            }
                            break block30;
                        }
                    }
                    break block30;
                }
                if (encodeNonLatin && c > '\u0080') {
                    switch (c) {
                        case '\u00e4': {
                            app = "&auml;";
                            break;
                        }
                        case '\u00c4': {
                            app = "&Auml;";
                            break;
                        }
                        case '\u00f6': {
                            app = "&ouml;";
                            break;
                        }
                        case '\u00d6': {
                            app = "&Ouml;";
                            break;
                        }
                        case '\u00fc': {
                            app = "&uuml;";
                            break;
                        }
                        case '\u00dc': {
                            app = "&Uuml;";
                            break;
                        }
                        case '\u00df': {
                            app = "&szlig;";
                            break;
                        }
                        case '\u20ac': {
                            app = "&euro;";
                            break;
                        }
                        case '\u00ab': {
                            app = "&laquo;";
                            break;
                        }
                        case '\u00bb': {
                            app = "&raquo;";
                            break;
                        }
                        case '\u00a0': {
                            app = "&#160;";
                            break;
                        }
                        default: {
                            app = "&#" + c + ";";
                        }
                    }
                }
            }
            if (app != null) {
                if (sb == null) {
                    sb = new StringBuilder(string.substring(0, i));
                }
                sb.append(app);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    public static void throwOidcServerException(HttpServletRequest request, OAuth20Exception e) throws OidcServerException {
        Tr.error((TraceComponent)tc, (String)e.getMsgKey(), (Object[])e.getObjects());
        throw new OidcServerException(new BrowserAndServerLogMessage(tc, e.getMsgKey(), e.getObjects()), "invalid_request", 400);
    }
}

