/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.oauth.core.api.oauth20.OAuth20Component;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.OAuth20ComponentImpl;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UIAccessTokenBuilder {
    private static TraceComponent tc = Tr.register(UIAccessTokenBuilder.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    OAuth20Component _component = null;
    OAuth20Provider _provider = null;
    HttpServletRequest _req = null;
    static final long serialVersionUID = 2460194442954908452L;

    UIAccessTokenBuilder(OAuth20Provider provider, HttpServletRequest req) {
        this._component = provider.getComponent();
        this._provider = provider;
        this._req = req;
    }

    void createHeaderValuesForUI() {
        OidcBaseClient client = this.getClient();
        OAuth20Token token = this.createAccessTokenForAuthenticatedUser();
        String authHeader = this.createAuthHeaderValueFromClientIdAndSecret();
        if (token != null && authHeader != null) {
            this._req.setAttribute("ui_token", (Object)token.getId());
            this._req.setAttribute("ui_authheader", (Object)authHeader);
            this._req.setAttribute("ui_app_pw_enabled", (Object)(client == null ? false : client.isAppPasswordAllowed()));
            this._req.setAttribute("ui_app_tok_enabled", (Object)(client == null ? false : client.isAppTokenAllowed()));
        }
    }

    OidcBaseClient getClient() {
        String clientId = this._provider.getInternalClientId();
        if (clientId == null) {
            return null;
        }
        OidcBaseClient client = null;
        try {
            client = this._provider.getClientProvider().get(clientId);
        }
        catch (OidcServerException oidcServerException) {
            FFDCFilter.processException((Throwable)oidcServerException, (String)"com.ibm.ws.security.oauth20.web.UIAccessTokenBuilder", (String)"74", (Object)this, (Object[])new Object[0]);
        }
        return client;
    }

    OAuth20Token createAccessTokenForAuthenticatedUser() {
        String user;
        if (this._component == null || this._provider == null || this._req == null) {
            return null;
        }
        OAuth20TokenFactory tokenFactory = new OAuth20TokenFactory((OAuth20ComponentImpl)this._component);
        String clientId = this._provider.getInternalClientId();
        String string = user = this._req.getUserPrincipal() != null ? this._req.getUserPrincipal().getName() : null;
        if (clientId == null || clientId.isEmpty() || user == null) {
            Tr.error((TraceComponent)tc, (String)"OAUATH_BASIC_AUTH_FAIL", (Object[])new Object[0]);
            return null;
        }
        Map<String, String[]> tokenAttributesMap = this.getTokenAttributesMap(tokenFactory, clientId, user);
        OAuth20Token token = tokenFactory.createAccessToken(tokenAttributesMap);
        return token;
    }

    Map<String, String[]> getTokenAttributesMap(OAuth20TokenFactory factory, String clientId, String user) {
        return factory.buildTokenMap(clientId, user, null, null, this.getScopes(clientId), null, "implicit_internal");
    }

    String[] getScopes(String clientId) {
        try {
            String scopes = this._provider.getClientProvider().get(clientId).getPreAuthorizedScope();
            return scopes == null ? null : scopes.trim().split("\\s+");
        }
        catch (OidcServerException scopes) {
            FFDCFilter.processException((Throwable)scopes, (String)"com.ibm.ws.security.oauth20.web.UIAccessTokenBuilder", (String)"109", (Object)this, (Object[])new Object[]{clientId});
            return null;
        }
    }

    private String createAuthHeaderValueFromClientIdAndSecret() {
        String clientId = this._provider.getInternalClientId();
        String secret = this._provider.getInternalClientSecret();
        String result = null;
        if (clientId != null && secret != null && clientId.length() > 0 && secret.length() > 0) {
            result = "Basic " + Base64Coder.base64Encode((String)(clientId + ":" + secret));
        }
        return result;
    }
}

